/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.ServerType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.SkinUpload;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.minelittlepony.hdskins.util.IndentedToStringStyle;
import com.minelittlepony.hdskins.util.net.FileTypes;
import com.minelittlepony.hdskins.util.net.MoreHttpResponses;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_310;

@ServerType(value="mojang")
public class YggdrasilSkinServer
implements SkinServer {
    static final SkinServer INSTANCE = new YggdrasilSkinServer();
    private static final Set<Feature> FEATURES = Sets.newHashSet((Object[])new Feature[]{Feature.SYNTHETIC, Feature.UPLOAD_USER_SKIN, Feature.DOWNLOAD_USER_SKIN, Feature.DELETE_USER_SKIN, Feature.MODEL_VARIANTS, Feature.MODEL_TYPES});
    private final transient String address = "https://api.minecraftservices.com";
    private final transient String verify = "https://authserver.mojang.com/validate";
    private final transient String skinUploadAddress = "https://api.minecraftservices.com/minecraft/profile/skins";
    private final transient String activeSkinAddress = "https://api.minecraftservices.com/minecraft/profile/skins/active";
    private final transient boolean requireSecure = true;

    @Override
    public boolean ownsUrl(String url) {
        return false;
    }

    @Override
    public Set<Feature> getFeatures() {
        return FEATURES;
    }

    @Override
    public boolean supportsSkinType(SkinType skinType) {
        return skinType.isVanilla() && skinType != SkinType.CAPE;
    }

    @Override
    public TexturePayload loadSkins(GameProfile profile) throws IOException, AuthenticationException {
        HashMap textures = new HashMap();
        class_310 client = class_310.method_1551();
        MinecraftSessionService session = client.method_1495();
        profile.getProperties().clear();
        GameProfile newProfile = session.fillProfileProperties(profile, true);
        if (newProfile == profile) {
            throw new AuthenticationException("Mojang API error occured. You may be throttled.");
        }
        profile = newProfile;
        try {
            textures.putAll(session.getTextures(profile, true));
        }
        catch (InsecurePublicKeyException e) {
            HDSkins.LOGGER.error((Object)e);
        }
        return new TexturePayload(profile, textures.entrySet().stream().collect(Collectors.toMap(entry -> SkinType.forVanilla((MinecraftProfileTexture.Type)entry.getKey()), Map.Entry::getValue)));
    }

    @Override
    public void uploadSkin(SkinUpload upload) throws IOException, AuthenticationException {
        this.authorize(upload.session());
        if (upload instanceof SkinUpload.Delete) {
            this.execute(HttpRequest.newBuilder(URI.create("https://api.minecraftservices.com/minecraft/profile/skins/active")).DELETE().header("Authorization", "Bearer " + upload.session().accessToken()).build());
        } else if (upload instanceof SkinUpload.FileUpload) {
            SkinUpload.FileUpload fileUpload = (SkinUpload.FileUpload)upload;
            this.execute(HttpRequest.newBuilder(URI.create("https://api.minecraftservices.com/minecraft/profile/skins")).PUT(FileTypes.multiPart(this.mapMetadata(fileUpload.metadata())).field("file", fileUpload.file()).build()).header("Content-Type", "multipart/form-data; boundary=\"MULTI-PART_BOUNDARY\"").header("Accept", "application/json").header("Authorization", "Bearer " + upload.session().accessToken()).build());
        } else {
            if (upload instanceof SkinUpload.UriUpload) {
                throw new IOException("Yggdrasil does not support URI uploads");
            }
            throw new IllegalArgumentException("Unsupported SkinUpload type: " + String.valueOf(upload.getClass()));
        }
        class_310 client = class_310.method_1551();
        client.method_1539().clear();
    }

    private Map<String, String> mapMetadata(Map<String, String> metadata) {
        HashMap<String, String> result = new HashMap<String, String>();
        String model = metadata.getOrDefault("model", "classic");
        result.put("variant", "default".contentEquals(model) ? "classic" : model);
        return result;
    }

    @Override
    public void authorize(SkinUpload.Session session) throws IOException {
        JsonObject json = new JsonObject();
        json.addProperty("accessToken", session.accessToken());
        this.execute(HttpRequest.newBuilder(URI.create("https://authserver.mojang.com/validate")).POST(HttpRequest.BodyPublishers.ofString(json.toString())).header("Content-Type", "application/json").header("Accept", "application/json").build());
    }

    private void execute(HttpRequest request) throws IOException {
        MoreHttpResponses response = MoreHttpResponses.execute(request);
        if (!response.ok()) {
            throw new IOException(response.json(ErrorResponse.class, "Server did not respond correctly. Status Code " + response.response().statusCode()).toString());
        }
    }

    @Override
    public Optional<SkinServer.SkinServerProfile<?>> loadProfile(GameProfile profile) throws IOException, AuthenticationException {
        MoreHttpResponses response = MoreHttpResponses.execute(HttpRequest.newBuilder(URI.create("https://api.minecraftservices.com/minecraft/profile/skins/active")).GET().header("Authorization", "Bearer " + class_310.method_1551().method_1548().method_1674()).build());
        if (!response.ok()) {
            return Optional.empty();
        }
        ProfileResponse prof = response.json(ProfileResponse.class, "Server send invalid profile response");
        prof.profile = profile;
        return Optional.of(prof);
    }

    public String toString() {
        return new IndentedToStringStyle.Builder(this).append("address", "https://api.minecraftservices.com").append("secured", true).toString();
    }

    class ErrorResponse {
        String error;
        String errorMessage;

        ErrorResponse() {
        }

        public String toString() {
            return String.format("%s: %s", this.error, this.errorMessage);
        }
    }

    static class ProfileResponse
    implements SkinServer.SkinServerProfile<Skin> {
        public String id;
        public String name;
        public List<Skin> skins;
        public List<Skin> capes;
        transient GameProfile profile;

        ProfileResponse() {
        }

        @Override
        public GameProfile getGameProfile() {
            return this.profile;
        }

        @Override
        public List<Skin> getSkins(SkinType type) {
            if (type == SkinType.SKIN) {
                return this.skins;
            }
            if (type == SkinType.CAPE) {
                return this.capes;
            }
            return List.of();
        }

        @Override
        public void setActive(SkinType type, Skin texture) {
        }

        static class Skin
        implements SkinServer.SkinServerProfile.Skin {
            public String id;
            public State state;
            public String url;
            public String alias;

            Skin() {
            }

            @Override
            public String getModel() {
                return this.alias;
            }

            @Override
            public boolean isActive() {
                return this.state == State.ACTIVE;
            }

            @Override
            public String getUri() {
                return this.url;
            }
        }

        static enum State {
            ACTIVE,
            INACTIVE;

        }
    }
}

