/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.util.net;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import org.apache.commons.io.FilenameUtils;

public interface FileTypes {
    public static final String MULTI_PART_BOUNDARY = "MULTI-PART_BOUNDARY";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String MULTI_PART_FORM_DATA = "multipart/form-data; boundary=\"MULTI-PART_BOUNDARY\"";

    public static String getMimeType(Path path) {
        try {
            return Strings.nullToEmpty((String)Files.probeContentType(path));
        }
        catch (IOException e) {
            return APPLICATION_OCTET_STREAM;
        }
    }

    public static String getExtension(Path path) {
        return FilenameUtils.getExtension((String)path.getFileName().toString());
    }

    public static Path changeExtension(Path path, String extension) {
        return Paths.get(FilenameUtils.removeExtension((String)path.toString()) + extension, new String[0]);
    }

    public static MultiPartBuilder multiPart() {
        return new MultiPartBuilder();
    }

    public static MultiPartBuilder multiPart(Map<String, ?> fields) {
        MultiPartBuilder builder = FileTypes.multiPart();
        fields.forEach(builder::field);
        return builder;
    }

    public static HttpRequest.BodyPublisher json(Object object) {
        return FileTypes.json(object, new Gson());
    }

    public static HttpRequest.BodyPublisher json(Object object, Gson gson) {
        return HttpRequest.BodyPublishers.ofString(gson.toJson(object), StandardCharsets.UTF_8);
    }

    public static class MultiPartBuilder {
        private static final byte[] HEAD = "--MULTI-PART_BOUNDARY\r\n".getBytes(StandardCharsets.UTF_8);
        private static final byte[] NEWLINE = "\r\n".getBytes(StandardCharsets.UTF_8);
        private static final byte[] TAIL = "--MULTI-PART_BOUNDARY--\r\n".getBytes(StandardCharsets.UTF_8);
        private final List<byte[]> buffer = new ArrayList<byte[]>();
        private long length = 0L;

        public MultiPartBuilder field(String name, Object value) {
            this.append(HEAD);
            this.append("Content-Disposition: form-data; name=\"" + name + "\"\r\n");
            this.append("Content-Type: text/plain; charset=UTF-8\r\n");
            this.append(NEWLINE);
            this.append(String.valueOf(value) + "\r\n");
            return this;
        }

        public MultiPartBuilder field(String name, URI file) throws IOException {
            if ("file".equals(file.getAuthority())) {
                return this.field(name, Path.of(file));
            }
            return this.field(name, file.toString());
        }

        public MultiPartBuilder field(String name, Path file) throws IOException {
            this.append(HEAD);
            this.append("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + file.getFileName().toString() + "\"\r\n");
            this.append("Content-Type: " + FileTypes.getMimeType(file) + "\r\n");
            this.append(NEWLINE);
            this.append(Files.readAllBytes(file));
            this.append(NEWLINE);
            return this;
        }

        public MultiPartBuilder append(String data) {
            return this.append(data.getBytes(StandardCharsets.UTF_8));
        }

        public MultiPartBuilder append(byte[] data) {
            this.buffer.add(data);
            this.length += (long)data.length;
            return this;
        }

        public HttpRequest.BodyPublisher build() {
            this.append(TAIL);
            StringBuilder builder = new StringBuilder();
            for (byte[] chunk : this.buffer) {
                builder.append(new String(chunk, StandardCharsets.UTF_8));
            }
            final HttpRequest.BodyPublisher publisher = HttpRequest.BodyPublishers.ofByteArrays(this.buffer);
            return new HttpRequest.BodyPublisher(){

                @Override
                public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
                    publisher.subscribe(subscriber);
                }

                @Override
                public long contentLength() {
                    return length;
                }
            };
        }
    }
}

