/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.util.net;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.hdskins.util.net.MoreHttpResponses;
import java.io.IOException;
import java.util.Set;

public class HttpException
extends IOException {
    private static final long serialVersionUID = -6168434367054139332L;
    private static final Set<String> MESSAGE_FIELDS = Set.of("message", "detail");
    private final String reason;
    private final int statusCode;

    HttpException(String reason, int statusCode, Throwable cause) {
        super("(" + statusCode + ") " + reason, cause);
        this.reason = reason;
        this.statusCode = statusCode;
    }

    public String getReasonPhrase() {
        return this.reason;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    static HttpException of(MoreHttpResponses response) throws IOException {
        return new HttpException(HttpException.getMessage(response.json(JsonObject.class, () -> "Server did not respond correctly. Status Code " + response.response().statusCode())), response.response().statusCode(), null);
    }

    static String getMessage(JsonObject json) {
        return MESSAGE_FIELDS.stream().filter(arg_0 -> ((JsonObject)json).has(arg_0)).map(arg_0 -> ((JsonObject)json).get(arg_0)).findFirst().orElse((JsonElement)json).getAsString();
    }

    static interface UnsafeSupplier<T> {
        public T get() throws IOException;
    }
}

