/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins;

import com.minelittlepony.hdskins.BufferedCache;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.SkinServerList;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HDSkinsServer
implements ModInitializer {
    public static final String DEFAULT_NAMESPACE = "hdskins";
    public static final Logger LOGGER = LogManager.getLogger();
    private static HDSkinsServer instance;
    private Supplier<MinecraftSessionService> sessionServiceSupplier = () -> null;
    private final SkinServerList servers = new SkinServerList();
    private final BufferedCache<GameProfile, Map<SkinType, MinecraftProfileTexture>> profileLoader = new BufferedCache(this.servers::fillProfiles);

    public static HDSkinsServer getInstance() {
        if (instance == null) {
            instance = new HDSkinsServer();
        }
        return instance;
    }

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)DEFAULT_NAMESPACE, (String)name);
    }

    public HDSkinsServer() {
        instance = this;
    }

    public SkinServerList getServers() {
        return this.servers;
    }

    public CompletableFuture<Map<SkinType, MinecraftProfileTexture>> fillProfile(GameProfile profile) {
        return this.profileLoader.apply((Object)profile);
    }

    public void setSessionService(Supplier<MinecraftSessionService> serviceSupplier) {
        this.sessionServiceSupplier = serviceSupplier;
    }

    public MinecraftSessionService getSessionService() {
        return Objects.requireNonNull(this.sessionServiceSupplier.get(), "getSessionService called too early");
    }

    public void onInitialize() {
        ResourceLoader.get((class_3264)class_3264.field_14190).registerReloader(SkinServerList.SKIN_SERVERS, (class_3302)this.servers);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            ServerLifecycleEvents.SERVER_STARTING.register(server -> this.setSessionService(() -> server.method_73550().comp_837()));
        }
    }
}

