/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui;

import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.hdskins.client.gui.Carousel;
import com.minelittlepony.hdskins.client.gui.PlayerPreviewSpecialGuiElementRenderer;
import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.minelittlepony.hdskins.profile.SkinType;
import net.minecraft.class_10055;
import net.minecraft.class_11256;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_765;
import net.minecraft.class_8080;
import net.minecraft.class_811;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class PlayerBodyWidget<S extends class_10055>
implements Carousel.Element {
    protected final Vector3f position = new Vector3f();
    private final Vector3d offset = new Vector3d();
    private final Vector3f velocity = new Vector3f();
    private final class_8080 limbAnimator = new class_8080();
    private final ElytraState elytraState = new ElytraState();
    public boolean sprinting;
    public boolean jumping;
    public PlayerSkins<?> skins;
    public final S playerState;
    public float lastHandSwingProgress;
    public float nextHandSwingProgress;
    public int handSwingTicks;
    public float upwardSpeed;

    public PlayerBodyWidget(PlayerSkins<?> skins, S playerState) {
        this.skins = skins;
        this.playerState = playerState;
        ((class_10055)this.playerState).field_58171 = class_1299.field_6097;
        ((class_10055)this.playerState).field_55303 = (class_1306)class_310.method_1551().field_1690.method_42552().method_41753();
        if (class_310.method_1551().field_1724 != null) {
            try {
                class_310.method_1551().method_1561().method_68832(playerState).method_62354((class_1297)class_310.method_1551().field_1724, playerState, 1.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ((class_10055)this.playerState).field_53326 = 14.0;
    }

    public void setPose(class_4050 pose) {
        ((class_10055)this.playerState).field_53465 = pose == class_4050.field_18076 && ((class_10055)this.playerState).field_53410 ? class_4050.field_18081 : pose;
    }

    public void swingArm(class_1268 hand) {
        ((class_10055)this.playerState).field_53414 = true;
        ((class_10055)this.playerState).field_53409 = hand;
        ((class_10055)this.playerState).field_53408 = hand == class_1268.field_5808 ? ((class_10055)this.playerState).field_55303 : ((class_10055)this.playerState).field_55303.method_5928();
    }

    public void setHandStack(class_1268 hand, class_1799 stack) {
        class_1306 arm = hand == class_1268.field_5808 ? ((class_10055)this.playerState).field_55303 : ((class_10055)this.playerState).field_55303.method_5928();
        class_310.method_1551().method_65386().method_65598(arm == class_1306.field_6182 ? ((class_10055)this.playerState).field_55307 : ((class_10055)this.playerState).field_55305, stack, arm == class_1306.field_6182 ? class_811.field_4323 : class_811.field_4320, null, null, 0);
    }

    @Override
    public void tick() {
        SkinType type = this.skins.getPosture().getActiveSkinType();
        ((class_10055)this.playerState).field_53520 = this.skins.getSkinTextureBundle();
        if (type == SkinType.ELYTRA != (((class_10055)this.playerState).field_53418.method_7909() == class_1802.field_8833)) {
            ((class_10055)this.playerState).field_53418 = type == SkinType.ELYTRA ? class_1802.field_8833.method_7854() : this.skins.getPosture().getEquipment().getStack(class_1304.field_6174);
        }
        this.lastHandSwingProgress = ((class_10055)this.playerState).field_63604;
        if (((class_10055)this.playerState).field_53414) {
            if (++this.handSwingTicks >= 8) {
                this.handSwingTicks = 0;
                ((class_10055)this.playerState).field_53414 = false;
            }
        } else {
            this.handSwingTicks = 0;
        }
        ((class_10055)this.playerState).field_53465 = this.skins.getPosture().getPose().getPose();
        ((class_10055)this.playerState).field_53413 = ((class_10055)this.playerState).field_53465 == class_4050.field_40118;
        this.nextHandSwingProgress = (float)this.handSwingTicks / 8.0f;
        this.upwardSpeed -= 0.1f;
        if ((double)Math.abs(this.upwardSpeed) < 0.003) {
            this.upwardSpeed = 0.0f;
        }
        if (((class_10055)this.playerState).field_53326 == 0.0 && this.jumping && this.upwardSpeed <= 0.0f && !this.playerState.method_62613(class_4050.field_18078) && !((class_10055)this.playerState).field_53413 && !((class_10055)this.playerState).field_53412 && !((class_10055)this.playerState).field_53459) {
            this.upwardSpeed = this.velocity.y;
        }
        if (this.jumping && ((class_10055)this.playerState).field_53326 <= 0.0) {
            this.jumping = false;
            this.upwardSpeed += 4.0f;
        }
        this.upwardSpeed = (float)((double)this.upwardSpeed * 0.988);
        this.upwardSpeed = (float)((double)this.upwardSpeed - 0.58);
        ((class_10055)this.playerState).field_53326 += (double)this.upwardSpeed;
        if (((class_10055)this.playerState).field_53326 < 0.0) {
            ((class_10055)this.playerState).field_53326 = 0.0;
        }
        ((class_10055)this.playerState).field_53412 = this.playerState.method_62613(class_4050.field_18079);
        ((class_10055)this.playerState).field_53459 = this.playerState.method_62613(class_4050.field_18080);
        this.limbAnimator.method_48568(this.sprinting ? (((class_10055)this.playerState).field_53410 ? 0.1f : 1.0f) : (float)(((class_10055)this.playerState).field_53412 ? 1 : 0), 0.1f, 1.0f);
        this.elytraState.update((class_10055)this.playerState);
        ((class_10055)this.playerState).field_53328 += 1.0f;
        this.offset.set(0.0, -1.25 + ((class_10055)this.playerState).field_53326 / 16.0, 0.0);
        if (((class_10055)this.playerState).field_53410) {
            this.offset.y += 0.125;
        }
        if (this.playerState.method_62613(class_4050.field_18078)) {
            this.offset.y += (double)0.7f;
            this.offset.x += 1.0;
        }
        if (((class_10055)this.playerState).field_53412) {
            ((class_10055)this.playerState).field_53403 = 0.7f;
            if (this.velocity.x < 100.0f) {
                this.velocity.x += 100.0f;
            }
            this.offset.y += 0.5;
        } else if (((class_10055)this.playerState).field_53459) {
            ((class_10055)this.playerState).field_53403 = 0.0f;
            this.offset.y += 1.0;
            this.offset.z -= 0.5;
        } else {
            ((class_10055)this.playerState).field_53403 = 0.0f;
            if (this.velocity.x >= 100.0f) {
                this.velocity.x -= 100.0f;
            }
        }
        ((class_10055)this.playerState).field_53328 += 0.5f;
        ((class_10055)this.playerState).field_53336 = new class_243(this.offset.x, this.offset.y, this.offset.z);
        ((class_10055)this.playerState).field_61820 = class_765.method_23687((int)0, (int)Math.min((int)((class_10055)this.playerState).field_53328, 15));
    }

    @Override
    public void updateState(float xPosition, float yPosition, float mouseX, float mouseY, float tickDelta) {
        ((class_10055)this.playerState).field_53446 = 0.0f;
        ((class_10055)this.playerState).field_53447 = class_3532.method_15393((float)(((class_10055)this.playerState).field_53446 - (float)Math.atan((xPosition - mouseX) / 20.0f) * -30.0f * (float)Math.sin((double)((class_10055)this.playerState).field_53446 * (Math.PI / 180) + 45.0)));
        ((class_10055)this.playerState).field_53448 = this.playerState.method_62613(class_4050.field_18078) ? 10.0f : (float)Math.atan(mouseY / 40.0f) * -20.0f;
        ((class_10055)this.playerState).field_53415 = this.elytraState.leftWingPitch(tickDelta);
        ((class_10055)this.playerState).field_53416 = this.elytraState.leftWingYaw(tickDelta);
        ((class_10055)this.playerState).field_53417 = this.elytraState.leftWingRoll(tickDelta);
        ((class_10055)this.playerState).field_63604 = class_3532.method_16439((float)tickDelta, (float)this.lastHandSwingProgress, (float)this.nextHandSwingProgress);
        ((class_10055)this.playerState).field_53405 = 1.0f;
        if (!((class_10055)this.playerState).field_53413) {
            ((class_10055)this.playerState).field_53450 = this.limbAnimator.method_48572(tickDelta);
            ((class_10055)this.playerState).field_53451 = this.limbAnimator.method_48570(tickDelta);
        } else {
            ((class_10055)this.playerState).field_53450 = 0.0f;
            ((class_10055)this.playerState).field_53451 = 0.0f;
        }
    }

    @Override
    public void render(class_332 context, Bounds bounds, int mouseX, int mouseY, Quaternionf rotation) {
        context.field_59826.method_70922((class_11256)new PlayerPreviewSpecialGuiElementRenderer.Element((class_10055)this.playerState, this.position, rotation, bounds.left, bounds.right(), bounds.top, bounds.bottom(), (float)bounds.height / 3.0f, context.field_44659.method_70863()));
    }

    public static class ElytraState {
        private static final float STANDING_PITCH = 0.2617994f;
        private static final float STANDING_ROLL = -0.2617994f;
        private float leftWingPitch;
        private float leftWingYaw;
        private float leftWingRoll;
        private float lastLeftWingPitch;
        private float lastLeftWingYaw;
        private float lastLeftWingRoll;

        public void update(class_10055 state) {
            this.lastLeftWingPitch = this.leftWingPitch;
            this.lastLeftWingYaw = this.leftWingYaw;
            this.lastLeftWingRoll = this.leftWingRoll;
            float g = state.field_53410 ? 0.69813174f : 0.2617994f;
            float h = state.field_53410 ? -0.7853982f : -0.2617994f;
            float i = state.field_53410 ? 0.08726646f : 0.0f;
            this.leftWingPitch += (g - this.leftWingPitch) * 0.3f;
            this.leftWingYaw += (i - this.leftWingYaw) * 0.3f;
            this.leftWingRoll += (h - this.leftWingRoll) * 0.3f;
        }

        public float leftWingPitch(float tickProgress) {
            return class_3532.method_16439((float)tickProgress, (float)this.lastLeftWingPitch, (float)this.leftWingPitch);
        }

        public float leftWingYaw(float tickProgress) {
            return class_3532.method_16439((float)tickProgress, (float)this.lastLeftWingYaw, (float)this.leftWingYaw);
        }

        public float leftWingRoll(float tickProgress) {
            return class_3532.method_16439((float)tickProgress, (float)this.lastLeftWingRoll, (float)this.leftWingRoll);
        }
    }
}

