/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.player.skins;

import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.minelittlepony.hdskins.client.resources.HDPlayerSkinTextureDownloader;
import com.minelittlepony.hdskins.profile.SkinType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class LocalPlayerSkins
extends PlayerSkins<LocalTexture> {
    public LocalPlayerSkins(PlayerSkins.Posture posture) {
        super(posture);
    }

    @Override
    protected LocalTexture createTexture(SkinType type, Supplier<class_2960> blank) {
        return new LocalTexture(this, type, blank);
    }

    @Override
    public String getSkinVariant() {
        return this.getPosture().getSkinVariant().map(PlayerSkins.Posture.SkinVariant::name).orElse("default");
    }

    @Override
    protected boolean isProvided(SkinType type) {
        return this.getPosture().getActiveSkinType() == type;
    }

    public class LocalTexture
    implements PlayerSkins.PlayerSkin {
        private final SkinType type;
        private final class_2960 id;
        private final Supplier<class_2960> defaultTexture;
        private Optional<CompletableFuture<class_2960>> local = Optional.empty();

        public LocalTexture(LocalPlayerSkins this$0, SkinType type, Supplier<class_2960> blank) {
            this.type = type;
            this.id = HDSkins.id("generated_preview/" + this$0.getPosture().getProfile().id().toString() + "/" + type.getPathName());
            this.defaultTexture = blank;
        }

        @Override
        public class_2960 getId() {
            return this.isReady() ? this.id : this.defaultTexture.get();
        }

        public void setLocal(Path file) throws IOException {
            this.local.ifPresent(l -> l.cancel(true));
            this.local = Optional.of(HDPlayerSkinTextureDownloader.downloadAndRegisterTexture(this.id, file, "", this.type));
        }

        @Override
        public boolean isReady() {
            return this.local.filter(i -> i.isDone() && !i.isCancelled() && !i.isCompletedExceptionally()).isPresent();
        }

        @Override
        public void close() {
            this.local.ifPresent(l -> l.cancel(true));
            this.local = Optional.empty();
        }
    }
}

