/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.player.skins;

import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.ServerPlayerSkins;
import com.minelittlepony.hdskins.client.resources.DynamicTextures;
import com.minelittlepony.hdskins.client.resources.EquipmentList;
import com.minelittlepony.hdskins.client.resources.HDPlayerSkinTextureDownloader;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2960;

public class PreviousServerPlayerSkins
extends PlayerSkins<ServerPlayerSkins.RemoteTexture> {
    private final ServerPlayerSkins fallback;
    private final SkinServer.SkinServerProfile.Skin skin;
    private final SkinType type;

    public PreviousServerPlayerSkins(ServerPlayerSkins fallback, SkinServer.SkinServerProfile.Skin skin, SkinType type) {
        super(new PostureOverrides(fallback.getPosture()));
        this.fallback = fallback;
        this.skin = skin;
        this.type = type;
    }

    public SkinServer.SkinServerProfile.Skin getSkin() {
        return this.skin;
    }

    public SkinType getType() {
        return this.type;
    }

    @Override
    protected ServerPlayerSkins.RemoteTexture createTexture(SkinType type, Supplier<class_2960> blank) {
        if (type == this.type) {
            String uri = this.skin.getUri();
            String hash = String.valueOf(uri.hashCode());
            return new ServerPlayerSkins.RemoteTexture(blank, new DynamicTextures.Result(uri, HDPlayerSkinTextureDownloader.downloadAndRegisterTexture(HDSkins.id(String.format("dynamic/%s/%s", type.getId().method_12832(), hash)), DynamicTextures.createTempFile(hash), uri, type)), this.skin.isActive());
        }
        return (ServerPlayerSkins.RemoteTexture)this.fallback.get(type);
    }

    @Override
    protected boolean isProvided(SkinType type) {
        return type == this.type || this.fallback.isProvided(type);
    }

    @Override
    public String getSkinVariant() {
        return this.fallback.getSkinVariant();
    }

    record PostureOverrides(PlayerSkins.Posture posture) implements PlayerSkins.Posture
    {
        @Override
        public GameProfile getProfile() {
            return this.posture.getProfile();
        }

        @Override
        public EquipmentList.EquipmentSet getEquipment() {
            return HDSkins.getInstance().getDummyPlayerEquipmentList().getDefault();
        }

        @Override
        public PlayerSkins.Posture.Pose getPose() {
            return PlayerSkins.Posture.Pose.STAND;
        }

        @Override
        public SkinType getActiveSkinType() {
            return this.posture.getActiveSkinType();
        }

        @Override
        public Optional<PlayerSkins.Posture.SkinVariant> getSkinVariant() {
            return this.posture.getSkinVariant();
        }

        @Override
        public class_2960 getDefaultSkin(SkinType type, String variant) {
            return this.posture.getDefaultSkin(type, variant);
        }

        @Override
        public TextureLoader.Exclusion getExclusion() {
            return this.posture.getExclusion();
        }
    }
}

