/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.player.skins;

import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.PreviousServerPlayerSkins;
import com.minelittlepony.hdskins.client.resources.DynamicTextures;
import com.minelittlepony.hdskins.profile.SkinCallback;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.TexturePayload;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ServerPlayerSkins
extends PlayerSkins<RemoteTexture> {
    private Optional<DynamicTextures> textureManager = Optional.empty();
    private Optional<? extends SkinServer.SkinServerProfile<?>> profile = Optional.empty();
    private final Map<SkinType, List<PreviousServerPlayerSkins>> skinLists = new HashMap<SkinType, List<PreviousServerPlayerSkins>>();

    public ServerPlayerSkins(PlayerSkins.Posture posture) {
        super(posture);
    }

    public void loadProfile(Optional<? extends SkinServer.SkinServerProfile<?>> profile) {
        this.profile = profile;
        this.skinLists.clear();
    }

    public void loadTextures(TexturePayload payload, SkinCallback loadCallback) {
        super.close();
        this.textureManager = Optional.of(new DynamicTextures(payload, loadCallback));
    }

    @Override
    protected RemoteTexture createTexture(SkinType type, Supplier<class_2960> blank) {
        return new RemoteTexture(blank, this.textureManager.flatMap(tpm -> tpm.loadTexture(type, (class_2960)blank.get())).orElse(null), true);
    }

    public List<PreviousServerPlayerSkins> getProfileSkins(SkinType type) {
        return this.skinLists.computeIfAbsent(type, t -> this.profile.map(profile -> profile.getSkins((SkinType)t).stream().map(skin -> new PreviousServerPlayerSkins(this, (SkinServer.SkinServerProfile.Skin)skin, type)).toList()).orElse(List.of()));
    }

    @Override
    public void close() {
        this.textureManager = Optional.empty();
        this.profile = Optional.empty();
        this.skinLists.clear();
        super.close();
    }

    @Override
    public String getSkinVariant() {
        return this.textureManager.flatMap(manager -> manager.getTextureMetadata(SkinType.SKIN)).map(metadata -> metadata.getMetadata("model")).orElseGet(() -> class_1068.method_4648((UUID)this.getPosture().getProfile().id()).comp_1629().name());
    }

    @Override
    protected boolean isProvided(SkinType type) {
        return ((RemoteTexture)this.get(type)).isReady() || this.textureManager.flatMap(manager -> manager.getTextureMetadata(type)).isPresent();
    }

    public record RemoteTexture(Supplier<class_2960> blank, @Nullable DynamicTextures.Result texture, boolean active) implements PlayerSkins.PlayerSkin
    {
        @Override
        public class_2960 getId() {
            if (this.texture == null || this.texture.id().isCancelled() || this.texture.id().isCompletedExceptionally() || !this.texture.id().isDone()) {
                return this.blank.get();
            }
            return this.texture.id().getNow(this.blank.get());
        }

        @Override
        public boolean isReady() {
            return this.texture != null && this.texture.id().isDone() && !this.texture.id().isCancelled();
        }

        @Override
        public void close() {
            if (this.texture != null) {
                this.texture.id().cancel(true);
            }
        }
    }
}

