/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.profile;

import com.google.common.cache.LoadingCache;
import com.minelittlepony.hdskins.HDSkinsServer;
import com.minelittlepony.hdskins.Memoize;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.PlayerSkinLayers;
import com.minelittlepony.hdskins.client.SkinCacheClearCallback;
import com.minelittlepony.hdskins.client.VanillaModels;
import com.minelittlepony.hdskins.client.profile.DynamicSkinTextures;
import com.minelittlepony.hdskins.client.profile.FileStore;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.class_12079;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SkinLoader {
    private final LoadingCache<GameProfile, CompletableFuture<ProvidedSkins>> cache = Memoize.createAsyncLoadingCache(15L, profile -> {
        if (((Boolean)HDSkins.getInstance().getConfig().useBatchLoading.get()).booleanValue()) {
            return HDSkinsServer.getInstance().fillProfile((GameProfile)profile).thenComposeAsync(this::fetchTextures, (Executor)class_310.method_1551());
        }
        return CompletableFuture.supplyAsync(() -> HDSkinsServer.getInstance().getServers().fillProfile((GameProfile)profile), (Executor)class_156.method_27958()).thenComposeAsync(this::fetchTextures, (Executor)class_310.method_1551());
    });
    private final FileStore fileStore = new FileStore();

    public DynamicSkinTextures get(final GameProfile profile) {
        return new DynamicSkinTextures(){
            private final AtomicReference<ProvidedSkins> value;
            {
                this.value = new AtomicReference<ProvidedSkins>(SkinLoader.this.load(profile).getNow(ProvidedSkins.EMPTY));
            }

            @Override
            public Set<class_2960> getProvidedSkinTypes() {
                return this.value.get().getProvidedSkinTypes();
            }

            @Override
            public Optional<class_12079.class_12081> getSkin(SkinType type) {
                return this.value.get().getSkin(type);
            }

            @Override
            public Optional<String> getModel() {
                return this.value.get().getModel();
            }

            @Override
            public boolean hasChanged() {
                ProvidedSkins value = SkinLoader.this.load(profile).getNow(ProvidedSkins.EMPTY);
                return this.value.getAndSet(value) != value;
            }
        };
    }

    public CompletableFuture<ProvidedSkins> load(GameProfile profile) {
        return (CompletableFuture)this.cache.getUnchecked((Object)profile);
    }

    private CompletableFuture<ProvidedSkins> fetchTextures(Map<SkinType, MinecraftProfileTexture> textures) {
        Map<SkinType, CompletableFuture> tasks = textures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.fileStore.get((SkinType)entry.getKey(), (MinecraftProfileTexture)entry.getValue()).thenApply(id -> new class_12079.class_10726(id, id))));
        return CompletableFuture.allOf((CompletableFuture[])tasks.values().stream().toArray(CompletableFuture[]::new)).thenApply(nothing -> new ProvidedSkins(Optional.ofNullable((MinecraftProfileTexture)textures.get(SkinType.SKIN)).map(skin -> VanillaModels.of(skin.getMetadata("model"))), tasks.keySet().stream().map(SkinType::getId).collect(Collectors.toSet()), tasks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (class_12079.class_12081)((CompletableFuture)entry.getValue()).join()))));
    }

    public void clear() {
        HDSkins.LOGGER.info("Clearing local player skin cache");
        this.cache.invalidateAll();
        HDSkinsServer.getInstance().getServers().invalidateProfiles();
        PlayerSkinLayers.invalidateCaches();
        this.fileStore.clear();
        ((SkinCacheClearCallback)SkinCacheClearCallback.EVENT.invoker()).onSkinCacheCleared();
    }

    public record ProvidedSkins(Optional<String> model, Set<class_2960> providedSkinTypes, Map<SkinType, class_12079.class_12081> skins) implements DynamicSkinTextures
    {
        public static final ProvidedSkins EMPTY = new ProvidedSkins(Optional.empty(), Set.of(), Map.of());

        @Override
        public Set<class_2960> getProvidedSkinTypes() {
            return this.providedSkinTypes;
        }

        @Override
        public Optional<class_12079.class_12081> getSkin(SkinType type) {
            return Optional.ofNullable(this.skins.get(type));
        }

        @Override
        public Optional<String> getModel() {
            return this.model;
        }

        @Override
        public boolean hasChanged() {
            return false;
        }
    }
}

