/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.resources;

import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.resources.HDPlayerSkinTextureDownloader;
import com.minelittlepony.hdskins.profile.SkinCallback;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DynamicTextures {
    private final TexturePayload payload;
    private final SkinCallback loadCallback;

    public DynamicTextures(TexturePayload payload, SkinCallback loadCallback) {
        this.payload = payload;
        this.loadCallback = loadCallback;
    }

    public Optional<MinecraftProfileTexture> getTextureMetadata(SkinType type) {
        return Optional.ofNullable(this.payload.textures().getOrDefault(type, null));
    }

    public Optional<Result> loadTexture(SkinType type, class_2960 def) {
        return this.getTextureMetadata(type).map(texture -> {
            class_2960 id = HDSkins.id(String.format("dynamic/%s/%s", type.getId().method_12832(), texture.getHash()));
            String uri = texture.getUrl();
            return new Result(uri, (CompletableFuture<class_2960>)HDPlayerSkinTextureDownloader.downloadAndRegisterTexture(id, DynamicTextures.createTempFile(texture.getHash()), uri, type).handle((u, throwable) -> {
                if (u != null) {
                    this.loadCallback.onSkinAvailable(type, (class_2960)u, (MinecraftProfileTexture)texture);
                }
                return u == null ? def : u;
            }));
        });
    }

    @Nullable
    public static Path createTempFile(String filename) {
        try {
            Path f = Files.createTempFile(filename, "skin-preview", new FileAttribute[0]);
            Files.deleteIfExists(f);
            return f;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public record Result(String uri, CompletableFuture<class_2960> id) {
        public InputStream openStream() throws IOException {
            return new URL(this.uri).openStream();
        }
    }
}

