/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.resources;

import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.minelittlepony.hdskins.Memoize;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.profile.DynamicSkinTextures;
import com.minelittlepony.hdskins.client.resources.HDPlayerSkinTextureDownloader;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_12079;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3302;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SkinResourceManager
implements class_3302 {
    public static final class_2960 ID = HDSkins.id("skins");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(SkinType.class, SkinType.adapter()).create();
    private final TextureLoader loader = new TextureLoader("hd_skins", (image, exclusions) -> HDPlayerSkinTextureDownloader.remapTexture(image));
    private final Map<SkinType, SkinStore> store = new HashMap<SkinType, SkinStore>();
    private long lastLoadTime;
    private final LoadingCache<class_2960, CompletableFuture<class_2960>> textures = Memoize.createAsyncLoadingCache(15L, this.loader::loadAsync);

    public CompletableFuture<Void> method_25931(class_3302.class_11558 store, Executor prepareExecutor, class_3302.class_4045 sync, Executor applyExecutor) {
        return sync.method_18352(null).thenRunAsync(() -> {
            this.store.clear();
            this.loader.stop();
            this.textures.invalidateAll();
            store.method_72361().method_14487().stream().map(domain -> class_2960.method_60655((String)domain, (String)"textures/skins/skins.json")).forEach(identifier -> store.method_72361().method_14489(identifier).stream().map(this::loadSkinData).filter(Optional::isPresent).map(Optional::get).forEach(data -> data.skins.forEach(s -> this.store.computeIfAbsent(s.getType(), SkinStore::new).addSkin((SkinData.Skin)s))));
            this.lastLoadTime = System.currentTimeMillis();
        }, applyExecutor);
    }

    private Optional<SkinData> loadSkinData(class_3298 res) {
        block8: {
            Optional<SkinData> optional;
            InputStreamReader reader = new InputStreamReader(res.method_14482());
            try {
                optional = Optional.ofNullable((SkinData)GSON.fromJson((Reader)reader, SkinData.class));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonParseException e) {
                    LOGGER.warn("Invalid skins.json in " + res.method_14480(), (Throwable)e);
                    break block8;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            reader.close();
            return optional;
        }
        return Optional.empty();
    }

    public DynamicSkinTextures getSkinTextures(final GameProfile profile) {
        return new DynamicSkinTextures(){
            private long initTime = System.currentTimeMillis();

            @Override
            public Set<class_2960> getProvidedSkinTypes() {
                return Set.of();
            }

            @Override
            public Optional<class_12079.class_12081> getSkin(SkinType type) {
                return SkinResourceManager.this.getCustomPlayerTexture(profile, type).map(id -> new class_12079.class_10726(id, id));
            }

            @Override
            public Optional<String> getModel() {
                return SkinResourceManager.this.getCustomPlayerModel(profile);
            }

            @Override
            public boolean hasChanged() {
                if (this.initTime < SkinResourceManager.this.lastLoadTime) {
                    this.initTime = System.currentTimeMillis();
                    return true;
                }
                return false;
            }
        };
    }

    public Optional<class_2960> getCustomPlayerTexture(GameProfile profile, SkinType type) {
        return this.store.computeIfAbsent(type, SkinStore::new).getSkin(profile).map(SkinData.Skin::getTexture).map(id -> this.convertTexture(type, (class_2960)id));
    }

    public Optional<String> getCustomPlayerModel(GameProfile profile) {
        return this.store.computeIfAbsent(SkinType.SKIN, SkinStore::new).getSkin(profile).map(SkinData.Skin::getModel);
    }

    public class_2960 convertTexture(SkinType type, class_2960 identifier) {
        if (type != SkinType.SKIN) {
            return identifier;
        }
        return ((CompletableFuture)this.textures.getUnchecked((Object)identifier)).getNow(identifier);
    }

    static class SkinData {
        List<Skin> skins;

        SkinData() {
        }

        static class Skin {
            @Nullable
            private SkinType type;
            @Nullable
            String name;
            @Nullable
            UUID uuid;
            private String skin;
            @Nullable
            private String model;
            @Nullable
            private transient class_2960 texture;
            @Nullable
            private String pattern;
            @Nullable
            private transient Predicate<String> predicate;

            Skin() {
            }

            public String getModel() {
                return this.model == null ? "default" : this.model;
            }

            public class_2960 getTexture() {
                if (this.texture == null) {
                    this.texture = this.createTexture();
                }
                return this.texture;
            }

            private class_2960 createTexture() {
                if (this.skin.indexOf(47) > -1 || this.skin.indexOf(58) > -1 || this.skin.indexOf(46) > -1) {
                    if (this.skin.indexOf(46) == -1) {
                        this.skin = this.skin + ".png";
                    }
                    if (this.skin.indexOf(58) == -1) {
                        return HDSkins.id(this.skin);
                    }
                    return class_2960.method_60654((String)this.skin);
                }
                return HDSkins.id(String.format("textures/skins/%s.png", this.skin));
            }

            @Nullable
            public Predicate<String> getPredicate() {
                if (this.predicate == null && this.pattern != null) {
                    this.predicate = Pattern.compile(this.pattern).asPredicate();
                }
                return this.predicate;
            }

            public SkinType getType() {
                return this.type == null ? SkinType.SKIN : this.type;
            }
        }
    }

    static class SkinStore {
        private final List<SkinData.Skin> predicates = new ArrayList<SkinData.Skin>();
        private final Map<UUID, SkinData.Skin> uuids = new HashMap<UUID, SkinData.Skin>();
        private final Map<String, SkinData.Skin> names = new HashMap<String, SkinData.Skin>();

        SkinStore(SkinType type) {
        }

        public void addSkin(SkinData.Skin skin) {
            if (skin.skin != null) {
                if (skin.uuid != null) {
                    this.uuids.put(skin.uuid, skin);
                }
                if (skin.name != null) {
                    this.names.put(skin.name, skin);
                }
                if (skin.getPredicate() != null) {
                    this.predicates.add(skin);
                }
            }
        }

        @Nullable
        public Optional<SkinData.Skin> getSkin(GameProfile profile) {
            SkinData.Skin skin = this.uuids.get(profile.id());
            if (skin == null && (skin = this.names.get(profile.name())) == null) {
                return this.predicates.stream().filter(f -> f.getPredicate().test(profile.name())).findFirst();
            }
            return Optional.ofNullable(skin);
        }
    }
}

