/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.profile;

import com.google.gson.TypeAdapter;
import com.minelittlepony.common.util.registry.Registries;
import com.minelittlepony.common.util.registry.RegistryTypeAdapter;
import com.minelittlepony.hdskins.client.HDSkins;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class SkinType
implements Comparable<SkinType> {
    public static final SkinType UNKNOWN = new SkinType(HDSkins.id("unknown"), class_1799.field_8037, false);
    public static final class_2378<SkinType> REGISTRY = Registries.createDefaulted((class_2960)HDSkins.id("skin_type"), SkinType::getId, (Object)UNKNOWN);
    private static final TypeAdapter<SkinType> ADAPTER = RegistryTypeAdapter.of(REGISTRY, (ls, registry) -> registry.method_10220().filter(type -> type.getParameterizedName().equalsIgnoreCase((String)ls)).findFirst().orElseGet(() -> SkinType.createUnsupported(ls)));
    private static final Map<MinecraftProfileTexture.Type, SkinType> VANILLA = new EnumMap<MinecraftProfileTexture.Type, SkinType>(MinecraftProfileTexture.Type.class);
    public static final SkinType SKIN = SkinType.forVanilla(MinecraftProfileTexture.Type.SKIN, new class_1799((class_1935)class_1802.field_8577));
    public static final SkinType CAPE = SkinType.forVanilla(MinecraftProfileTexture.Type.CAPE, new class_1799((class_1935)class_1802.field_8077));
    public static final SkinType ELYTRA = SkinType.forVanilla(MinecraftProfileTexture.Type.ELYTRA, new class_1799((class_1935)class_1802.field_8833));
    private final class_2960 id;
    private final class_1799 iconStack;
    private final class_2960 icon;
    private final boolean unsupported;

    protected SkinType(class_2960 id, class_1799 iconStack, boolean unsupported) {
        this.id = id;
        this.icon = this.getId().method_45134(p -> "textures/gui/skin_type/" + p + ".png");
        this.iconStack = iconStack;
        this.unsupported = unsupported;
    }

    public class_2960 icon() {
        return this.icon;
    }

    public class_1799 iconStack() {
        return this.iconStack;
    }

    public String name() {
        return this.getId().toString();
    }

    @Deprecated
    public String getParameterizedName() {
        return this.name().replace(':', '_').replace('/', '_').toLowerCase(Locale.US);
    }

    public String getPathName() {
        return this.getId().method_12836() + "/" + this.getId().method_12832();
    }

    public final class_2960 getId() {
        return this.id;
    }

    public final int ordinal() {
        return REGISTRY.method_10206((Object)this);
    }

    public boolean isKnown() {
        return this != UNKNOWN;
    }

    public boolean isVanilla() {
        return this.getEnum().isPresent();
    }

    public boolean isUnsupported() {
        return this.unsupported;
    }

    public Optional<MinecraftProfileTexture.Type> getEnum() {
        return Optional.empty();
    }

    public final boolean equals(Object other) {
        return other instanceof SkinType && this.compareTo((SkinType)other) == 0;
    }

    @Override
    public final int compareTo(SkinType o) {
        return this.getId().method_12833(o.getId());
    }

    public String toString() {
        return this.getId().toString();
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public static TypeAdapter<SkinType> adapter() {
        return ADAPTER;
    }

    public static Stream<SkinType> values() {
        return REGISTRY.method_10220();
    }

    private static SkinType createUnsupported(String parameterizedName) {
        class_2960 id = SkinType.deParameterize(parameterizedName);
        return (SkinType)class_2378.method_10230(REGISTRY, (class_2960)id, (Object)new SkinType(id, class_1802.field_8077.method_7854(), true));
    }

    private static class_2960 deParameterize(String parameterizedName) {
        String[] parts = parameterizedName.split("_", 2);
        parts[1] = parts[1].replace('_', '/');
        return class_2960.method_60655((String)parts[0], (String)parts[1]);
    }

    public static SkinType register(class_2960 id, class_1799 iconStack) {
        return (SkinType)class_2378.method_10230(REGISTRY, (class_2960)id, (Object)new SkinType(id, iconStack, false));
    }

    public static SkinType forVanilla(MinecraftProfileTexture.Type vanilla) {
        return VANILLA.getOrDefault(vanilla, UNKNOWN);
    }

    public static SkinType forVanilla(MinecraftProfileTexture.Type vanilla, class_1799 iconStack) {
        return VANILLA.computeIfAbsent(vanilla, v -> new VanillaType(vanilla, iconStack));
    }

    public static <T> Map<SkinType, T> convertMap(Map<MinecraftProfileTexture.Type, T> textures) {
        return textures.entrySet().stream().collect(Collectors.toMap(e -> SkinType.forVanilla((MinecraftProfileTexture.Type)e.getKey()), Map.Entry::getValue));
    }

    private static final class VanillaType
    extends SkinType {
        private final Optional<MinecraftProfileTexture.Type> vanilla;

        VanillaType(MinecraftProfileTexture.Type vanilla, class_1799 iconStack) {
            super(class_2960.method_60656((String)vanilla.name().toLowerCase(Locale.US)), iconStack, false);
            this.vanilla = Optional.of(vanilla);
            class_2378.method_10230((class_2378)REGISTRY, (class_2960)this.getId(), (Object)this);
        }

        @Override
        public String name() {
            return this.vanilla.get().name();
        }

        @Override
        public Optional<MinecraftProfileTexture.Type> getEnum() {
            return this.vanilla;
        }
    }
}

