/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.SkinUpload;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2561;

public interface SkinServer {
    public Set<Feature> getFeatures();

    default public Set<Feature> getFeatures(SkinType skinType) {
        return this.getFeatures();
    }

    default public Map<class_2561, class_2561> getMetadata() {
        return Map.of();
    }

    public boolean ownsUrl(String var1);

    public boolean supportsSkinType(SkinType var1);

    public void authorize(SkinUpload.Session var1) throws IOException, AuthenticationException;

    default public TexturePayload loadSkins(SkinUpload.Session session) throws IOException, AuthenticationException {
        return this.loadSkins(session.profile());
    }

    public TexturePayload loadSkins(GameProfile var1) throws IOException, AuthenticationException;

    default public List<TexturePayload> loadSkins(Collection<GameProfile> profiles) throws IOException {
        return profiles.parallelStream().flatMap(profile -> {
            try {
                return Stream.of(this.loadSkins((GameProfile)profile));
            }
            catch (AuthenticationException | IOException e) {
                return Stream.empty();
            }
        }).toList();
    }

    public void uploadSkin(SkinUpload var1) throws IOException, AuthenticationException;

    default public Optional<? extends SkinServerProfile<?>> loadProfile(SkinUpload.Session session) throws IOException, AuthenticationException {
        return Optional.empty();
    }

    public static interface SkinServerProfile<T extends Skin> {
        public List<T> getSkins(SkinType var1);

        public void setActive(SkinType var1, T var2) throws IOException, AuthenticationException;

        public static interface Skin {
            public String getModel();

            public boolean isActive();

            public String getUri();
        }
    }
}

