/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.minelittlepony.hdskins.HDSkinsServer;
import com.minelittlepony.hdskins.profile.ProfileUtils;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.Gateway;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.SkinServerSerializer;
import com.minelittlepony.hdskins.util.ResourceUtil;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkinServerList
implements class_4013 {
    public static final class_2960 SKIN_SERVERS = HDSkinsServer.id("skins/servers.json");
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(SkinServer.class, (Object)SkinServerSerializer.INSTANCE).create();
    private List<Gateway> skinServers = new LinkedList<Gateway>();
    private long timestamp = System.currentTimeMillis();

    public void method_14491(class_3300 mgr) {
        LOGGER.info("Loading skin servers");
        this.skinServers = ImmutableList.copyOf((Collection)ResourceUtil.streamAllResources(mgr, class_3264.field_14190, SKIN_SERVERS).map(res -> {
            SkinServerJson skinServerJson;
            block8: {
                LOGGER.info("Found {} in {}", (Object)SKIN_SERVERS, (Object)res.method_14480());
                BufferedReader reader = res.method_43039();
                try {
                    skinServerJson = (SkinServerJson)GSON.fromJson((Reader)reader, SkinServerJson.class);
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonParseException | IOException e) {
                        LOGGER.warn("Unable to load resource '{}' from '{}'", (Object)SKIN_SERVERS, (Object)res.method_14480(), (Object)e);
                        return null;
                    }
                }
                reader.close();
            }
            return skinServerJson;
        }).filter(Objects::nonNull).reduce(new LinkedList(), (gateways, res) -> {
            res.apply((List<Gateway>)gateways);
            return gateways;
        }, (a, b) -> b));
    }

    public Map<GameProfile, Map<SkinType, MinecraftProfileTexture>> fillProfiles(Collection<GameProfile> profiles) {
        HashMap result = new HashMap();
        List<GameProfile> profileList = profiles.stream().filter(profile -> this.getEmbeddedTextures((GameProfile)profile).findFirst().filter(textures -> {
            result.put(profile, new PartialTextures(Set.of(), (Map<SkinType, MinecraftProfileTexture>)textures));
            return true;
        }).isEmpty() && profile.id() != null).collect(Collectors.toList());
        Map profileLookup = profiles.stream().collect(Collectors.toUnmodifiableMap(GameProfile::id, Function.identity()));
        Set requestedSkinTypes = SkinType.REGISTRY.method_10220().filter(SkinType::isKnown).collect(Collectors.toSet());
        for (Gateway gateway : this.skinServers) {
            try {
                if (gateway.getServer().getFeatures().contains((Object)Feature.SYNTHETIC)) continue;
                gateway.getServer().loadSkins(profileList).forEach(textures -> {
                    GameProfile profile = (GameProfile)profileLookup.get(textures.profileId());
                    if (profile == null) {
                        LOGGER.warn("Server {} sent textures for unrequested profile {}. Ignoring.", (Object)gateway.toString(), (Object)textures.profileId());
                    } else if (result.computeIfAbsent(profile, p -> new PartialTextures(new HashSet<SkinType>(requestedSkinTypes), new HashMap<SkinType, MinecraftProfileTexture>())).appendTextures(textures.textures())) {
                        profileList.remove(profile);
                        this.writeEmbeddedTextures(profile, ((PartialTextures)result.get(profile)).textures());
                    }
                });
                if (!profileList.isEmpty()) continue;
                break;
            }
            catch (IOException e2) {
                LOGGER.trace((Object)e2);
            }
        }
        return result.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> Map.copyOf(((PartialTextures)e.getValue()).textures())));
    }

    public Map<SkinType, MinecraftProfileTexture> fillProfile(GameProfile profile) {
        return this.fillProfiles(Set.of(profile)).getOrDefault(profile, Map.of());
    }

    public Stream<Map<SkinType, MinecraftProfileTexture>> getEmbeddedTextures(GameProfile profile) {
        return ProfileUtils.readCustomBlob(profile, "hd_textures", ProfileUtils.TextureData.class).filter(i -> i.timestamp() == -1L || i.timestamp() >= this.timestamp).map(ProfileUtils.TextureData::textures).filter(this::isUrlPermitted);
    }

    public GameProfile writeEmbeddedTextures(GameProfile profile, Map<SkinType, MinecraftProfileTexture> textures) {
        return ProfileUtils.writeCustomBlob(profile, "hd_textures", new ProfileUtils.TextureData(this.timestamp, textures));
    }

    public void invalidateProfiles() {
        this.timestamp = System.currentTimeMillis();
    }

    private boolean isUrlPermitted(Map<SkinType, MinecraftProfileTexture> blob) {
        return blob.values().stream().map(MinecraftProfileTexture::getUrl).allMatch(url -> this.skinServers.stream().anyMatch(s -> s.getServer().ownsUrl((String)url)));
    }

    public Iterator<Gateway> getCycler() {
        return Iterators.cycle(this.skinServers);
    }

    public Iterable<Gateway> getGateways() {
        return new ArrayList<Gateway>(this.skinServers);
    }

    private static <T> void addAllStart(List<T> list, List<T> toAdd) {
        list.addAll(0, toAdd);
    }

    record PartialTextures(Set<SkinType> requestedSkinTypes, Map<SkinType, MinecraftProfileTexture> textures) {
        boolean appendTextures(Map<SkinType, MinecraftProfileTexture> textures) {
            textures.forEach(this.textures::putIfAbsent);
            this.requestedSkinTypes.removeAll(textures.keySet());
            return this.requestedSkinTypes.isEmpty();
        }
    }

    private static class SkinServerJson {
        boolean overwrite = false;
        InsertType insert = InsertType.END;
        List<SkinServer> servers = Collections.emptyList();

        private SkinServerJson() {
        }

        private void apply(List<Gateway> skinServers) {
            if (this.overwrite) {
                skinServers.clear();
            }
            LOGGER.info("Found {} servers", (Object)this.servers.size());
            this.insert.consumer.accept(skinServers, this.servers.stream().map(Gateway::new).toList());
        }
    }

    private static enum InsertType {
        START(SkinServerList::addAllStart),
        END(List::addAll);

        final BiConsumer<List<Gateway>, List<Gateway>> consumer;

        private InsertType(BiConsumer<List<Gateway>, List<Gateway>> consumer) {
            this.consumer = consumer;
        }
    }
}

