/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.minelittlepony.hdskins.client.VanillaModels;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.ServerType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.SkinUpload;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.minelittlepony.hdskins.util.IndentedToStringStyle;
import com.minelittlepony.hdskins.util.net.FileTypes;
import com.minelittlepony.hdskins.util.net.HttpException;
import com.minelittlepony.hdskins.util.net.MoreHttpResponses;
import com.minelittlepony.hdskins.util.net.URIUtil;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;

@ServerType(value="valhalla")
public class ValhallaSkinServer
implements SkinServer {
    private static final String API_PREFIX = "/api/v1";
    private static final String SRC = "https://github.com/MineLittlePony/ValhallaSkinServer";
    private static final Set<Feature> FEATURES = Sets.newHashSet((Object[])new Feature[]{Feature.DOWNLOAD_USER_SKIN, Feature.UPLOAD_USER_SKIN, Feature.DELETE_USER_SKIN, Feature.MODEL_VARIANTS, Feature.MODEL_TYPES});
    private final String address;
    private transient String accessToken;

    public ValhallaSkinServer(String address) {
        this.address = address;
    }

    private static URIUtil.NameValuePair param(String name, String value) {
        return new URIUtil.NameValuePair(name, value);
    }

    @SafeVarargs
    private URI buildBackendUri(String path, URIUtil.NameValuePair ... params) {
        try {
            return URIUtil.buildURI(this.address + "/api/v1/" + path, params);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to build URI", e);
        }
    }

    private URI buildBackendUserUri(UUID uuid) {
        return this.buildBackendUri(String.format("user/%s", uuid.toString()), new URIUtil.NameValuePair[0]);
    }

    private URI buildBackendHistoryUri(UUID uuid) {
        return this.buildBackendUri(String.format("history/%s", uuid.toString()), new URIUtil.NameValuePair[0]);
    }

    @Override
    public Set<Feature> getFeatures() {
        return FEATURES;
    }

    @Override
    public boolean supportsSkinType(SkinType skinType) {
        return skinType.isKnown() && skinType != SkinType.CAPE;
    }

    @Override
    public boolean ownsUrl(String url) {
        try {
            url = new URI(url).getHost();
            String domain = new URI(this.address).getHost();
            return domain.contentEquals(url) || url.startsWith("textures") && domain.contentEquals(url.replace("textures", "skins"));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    @Override
    public TexturePayload loadSkins(GameProfile profile) throws IOException {
        URI path = this.buildBackendUserUri(profile.id());
        return MoreHttpResponses.execute(HttpRequest.newBuilder(path).GET().build()).requireOk().json(TexturePayload.class, "Invalid texture payload");
    }

    @Override
    public List<TexturePayload> loadSkins(Collection<GameProfile> profiles) throws IOException {
        BulkTextures data = new BulkTextures(profiles.stream().map(GameProfile::id).toList());
        return MoreHttpResponses.execute((HttpRequest)HttpRequest.newBuilder((URI)this.buildBackendUri((String)"bulk_textures", (URIUtil.NameValuePair[])new URIUtil.NameValuePair[0])).POST((HttpRequest.BodyPublisher)FileTypes.json((Object)data)).header((String)"Content-Type", (String)"application/json").build()).requireOk().json(BulkTexturesResponse.class, (String)"Invalid texture payload").users;
    }

    @Override
    public TexturePayload loadSkins(SkinUpload.Session session) throws IOException, AuthenticationException {
        return this.doAuthorizedRequest(session, accessToken -> new TexturePayload(session.profile(), MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendUri("textures", new URIUtil.NameValuePair[0])).GET().header("Authorization", accessToken).build()).requireOk().json(TexturePayload.Textures.class, "Invalid texture payload")));
    }

    @Override
    public void uploadSkin(SkinUpload upload) throws IOException, AuthenticationException {
        this.doAuthorizedRequest(upload.session(), accessToken -> {
            SkinUpload skinUpload = upload;
            Objects.requireNonNull(skinUpload);
            SkinUpload selector0$temp = skinUpload;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SkinUpload.Delete.class, SkinUpload.FileUpload.class, SkinUpload.UriUpload.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    SkinUpload.Delete ignored = (SkinUpload.Delete)selector0$temp;
                    yield MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendUri("textures", ValhallaSkinServer.param("type", upload.type().getParameterizedName()))).DELETE().header("Authorization", accessToken).build()).requireOk();
                }
                case 1 -> {
                    SkinUpload.FileUpload fileUpload = (SkinUpload.FileUpload)selector0$temp;
                    yield MoreHttpResponses.execute(FileTypes.multiPart().field("type", fileUpload.type().getParameterizedName()).field("file", fileUpload.file()).field("meta", new Gson().toJson(this.addChecksum(fileUpload.metadata(), fileUpload.file().toUri()))).build(HttpRequest.newBuilder(this.buildBackendUri("textures", new URIUtil.NameValuePair[0]))::PUT).header("Accept", "application/json").header("Authorization", accessToken).build()).requireOk();
                }
                case 2 -> {
                    SkinUpload.UriUpload uriUpload = (SkinUpload.UriUpload)selector0$temp;
                    yield MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendUri("textures", new URIUtil.NameValuePair[0])).POST(FileTypes.json(Map.of("type", uriUpload.type().getParameterizedName(), "file", uriUpload.uri().toString(), "meta", this.addChecksum(uriUpload.metadata(), uriUpload.uri())))).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", accessToken).build()).requireOk();
                }
            };
        });
    }

    private Map<String, String> addChecksum(Map<String, String> metadata, URI uri) throws IOException {
        if (metadata.containsKey("checksum")) {
            return metadata;
        }
        metadata = new HashMap<String, String>(metadata);
        metadata.put("checksum", URIUtil.getChecksum(uri));
        return Map.copyOf(metadata);
    }

    @Override
    public void authorize(SkinUpload.Session session) throws IOException, AuthenticationException {
        if (this.accessToken != null) {
            return;
        }
        GameProfile profile = session.profile();
        AuthHandshake handshake = this.authHandshake(profile.name());
        if (handshake.offline) {
            return;
        }
        session.validate(handshake.serverId);
        AuthResponse response = this.authResponse(profile.name(), handshake.verifyToken);
        if (!response.userId.equals(profile.id())) {
            throw new IOException("UUID mismatch!");
        }
        this.accessToken = response.accessToken;
    }

    public Optional<SkinServer.SkinServerProfile<?>> loadProfile(final SkinUpload.Session session) throws IOException, AuthenticationException {
        return MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendHistoryUri(session.profile().id())).GET().build()).accept(r -> r.json(Textures.class, "Server sent invalid profile response")).map(p -> {
            final Function textures = class_156.method_34866(type -> {
                HashSet visited = new HashSet();
                return p.textures().getOrDefault(type, List.of()).stream().filter(texture -> texture.metadata().containsKey("checksum")).sorted(Comparator.comparing(t -> -t.startTime)).filter(texture -> visited.add(texture.metadata().get("checksum") + texture.getModel())).toList();
            });
            return new SkinServer.SkinServerProfile<Texture>(){

                @Override
                public List<Texture> getSkins(SkinType type) {
                    return (List)textures.apply(type);
                }

                @Override
                public void setActive(SkinType type, Texture texture) throws IOException, AuthenticationException {
                    ValhallaSkinServer.this.uploadSkin(new SkinUpload.UriUpload(session, type, URI.create(texture.getUri()), texture.metadata));
                }
            };
        });
    }

    private <T> T doAuthorizedRequest(SkinUpload.Session session, AuthorizedRequest<T> requester) throws IOException, AuthenticationException {
        this.authorize(session);
        try {
            return requester.doRequest(this.accessToken);
        }
        catch (HttpException e) {
            if (e.getStatusCode() != 401) {
                throw e;
            }
            this.accessToken = null;
            this.authorize(session);
            return requester.doRequest(this.accessToken);
        }
        catch (IOException e) {
            if (e.getMessage().equals("Authorization failed")) {
                this.accessToken = null;
                this.authorize(session);
                return requester.doRequest(this.accessToken);
            }
            throw e;
        }
    }

    private AuthHandshake authHandshake(String name) throws IOException {
        return MoreHttpResponses.execute(FileTypes.multiPart().field("name", name).build(HttpRequest.newBuilder(this.buildBackendUri("auth/minecraft", new URIUtil.NameValuePair[0]))::POST).header("Accept", "application/json")).requireOk().json(AuthHandshake.class, "Invalid handshake response");
    }

    private AuthResponse authResponse(String name, long verifyToken) throws IOException {
        return MoreHttpResponses.execute(FileTypes.multiPart().field("name", name).field("verifyToken", verifyToken).build(HttpRequest.newBuilder(this.buildBackendUri("auth/minecraft/callback", new URIUtil.NameValuePair[0]))::POST).header("Accept", "application/json")).requireOk().json(AuthResponse.class, "Invalid auth response");
    }

    public String toString() {
        return new IndentedToStringStyle.Builder(this).append("address", this.address).toString();
    }

    @Override
    public Map<class_2561, class_2561> getMetadata() {
        return Map.of(class_2561.method_43471((String)"hdskins.label.documentation"), class_2561.method_43470((String)(this.address + "/docs")).method_27692(class_124.field_1073).method_54663(-16776961).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(this.address + "/docs")))), class_2561.method_43471((String)"hdskins.label.source"), class_2561.method_43470((String)SRC).method_27692(class_124.field_1073).method_54663(-16776961).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create(SRC)))), class_2561.method_43471((String)"hdskins.label.author"), class_2561.method_43470((String)"Killjoy"));
    }

    private record BulkTextures(List<UUID> uuids) {
    }

    private record BulkTexturesResponse(List<TexturePayload> users) {
    }

    private static interface AuthorizedRequest<T> {
        public T doRequest(String var1) throws IOException, AuthenticationException;
    }

    private record AuthHandshake(boolean offline, String serverId, long verifyToken) {
    }

    private record AuthResponse(String accessToken, UUID userId) {
    }

    private record Textures(String profileId, String profilename, Map<SkinType, List<Texture>> textures) {
    }

    private record Texture(long startTime, String endTime, Map<String, String> metadata, String url) implements SkinServer.SkinServerProfile.Skin
    {
        @Override
        public String getModel() {
            return VanillaModels.of(this.metadata.get("model"));
        }

        @Override
        public boolean isActive() {
            return this.endTime == null || "null".equalsIgnoreCase(this.endTime);
        }

        @Override
        public String getUri() {
            return this.url;
        }
    }
}

