/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.util.net;

import com.google.common.hash.Hashing;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.class_310;

public interface URIUtil {
    public static URI buildURI(String path, NameValuePair ... parameters) throws URISyntaxException {
        URI uri = URI.create(path);
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), Arrays.stream(parameters).map(NameValuePair::toURIComponent).collect(Collectors.joining("&")), uri.getFragment());
    }

    public static String getChecksum(URI uri) throws IOException {
        return Hashing.farmHashFingerprint64().hashBytes(URIUtil.getBytes(uri)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(URI uri) throws IOException {
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            return Files.readAllBytes(Path.of(uri));
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)uri.toURL().openConnection(class_310.method_1551().method_1487());
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode / 100 != 2) {
                throw new IOException("Failed to open " + String.valueOf(uri) + ", HTTP error code: " + responseCode);
            }
            byte[] byArray = connection.getInputStream().readAllBytes();
            return byArray;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public record NameValuePair(String name, String value) {
        String toURIComponent() {
            return URLEncoder.encode(this.name, StandardCharsets.UTF_8) + "=" + URLEncoder.encode(this.value, StandardCharsets.UTF_8);
        }
    }
}

