/*
 * Decompiled with CFR 0.152.
 */
package com.github.crystal0404.mods.crystalcarpetaddition.utils;

import carpet.api.settings.Rule;
import com.github.crystal0404.mods.crystalcarpetaddition.CrystalCarpetAdditionMod;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Objects;
import me.fallenbreath.conditionalmixin.api.mixin.ConditionTester;
import me.fallenbreath.conditionalmixin.api.util.VersionChecker;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.service.MixinService;

public final class CCAUtils {
    private static final ImmutableMap<@NotNull String, @NotNull Key> JAVA_PARAMETERS = new ImmutableMap.Builder().put((Object)"cca.disable.EasterEggs", (Object)new Key(!CCAUtils.isFalse("cca.disable.EasterEggs"), true)).put((Object)"cca.enable.debug", (Object)new Key(Boolean.getBoolean("cca.enable.debug"), false)).put((Object)"cca.enable.MagicSettings", (Object)new Key(Boolean.getBoolean("cca.enable.MagicSettings"), false)).buildOrThrow();

    public static boolean tryFindClass(String className) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (IOException ioException) {
            CrystalCarpetAdditionMod.LOGGER.error("[CCA] An unknown exception occurred while trying to find the class");
            throw new RuntimeException(ioException);
        }
    }

    private static boolean isFalse(String name) {
        boolean result = false;
        try {
            result = "false".equalsIgnoreCase(System.getProperty(name));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isLoad(String modId, String versionPredicate) {
        return VersionChecker.doesModVersionSatisfyPredicate((String)modId, (String)versionPredicate);
    }

    @Deprecated
    public static boolean isLoad(String ruleName, String modId, String versionPredicate) {
        if (VersionChecker.doesModVersionSatisfyPredicate((String)modId, (String)versionPredicate)) {
            return true;
        }
        CrystalCarpetAdditionMod.LOGGER.warn("[CCA] Rule \"{}\" is disabled, Because \"{}\" does not meet condition \"{}\"", new Object[]{ruleName, modId, versionPredicate});
        return false;
    }

    public static boolean isEnableDebug() {
        return Objects.requireNonNull((Key)JAVA_PARAMETERS.get((Object)"cca.enable.debug")).value();
    }

    static {
        JAVA_PARAMETERS.forEach((k, v) -> {
            if (v.value() != v.defaultValue()) {
                CrystalCarpetAdditionMod.LOGGER.warn("[CCA] -D{}={}", k, (Object)v.value());
            }
        });
    }

    private record Key(boolean value, boolean defaultValue) {
    }

    public static final class EnableMagicSetting
    implements ConditionTester,
    Rule.Condition {
        public boolean isSatisfied(String mixinClassName) {
            return Objects.requireNonNull((Key)JAVA_PARAMETERS.get((Object)"cca.enable.MagicSettings")).value();
        }

        public boolean shouldRegister() {
            return Objects.requireNonNull((Key)JAVA_PARAMETERS.get((Object)"cca.enable.MagicSettings")).value();
        }
    }

    public static final class DisableEasterEggs
    implements ConditionTester {
        public boolean isSatisfied(String mixinClassName) {
            return Objects.requireNonNull((Key)JAVA_PARAMETERS.get((Object)"cca.disable.EasterEggs")).value();
        }
    }
}

