/*
 * Decompiled with CFR 0.152.
 */
package com.github.crystal0404.mods.crystalcarpetaddition.utils.annotation.impl;

import com.github.crystal0404.mods.crystalcarpetaddition.CrystalCarpetAdditionMod;
import com.github.crystal0404.mods.crystalcarpetaddition.utils.CCAUtils;
import com.github.crystal0404.mods.crystalcarpetaddition.utils.annotation.Condition;
import com.github.crystal0404.mods.crystalcarpetaddition.utils.annotation.Restriction;

public abstract class AnnotationProcessor {
    public static boolean shouldRegister(Restriction restriction, String rule) {
        for (Condition condition : restriction.conflict()) {
            if (!CCAUtils.isLoad(condition.value(), condition.versionPredicates())) continue;
            AnnotationProcessor.conflictInfo(rule, condition);
            return false;
        }
        for (Condition condition : restriction.require()) {
            if (CCAUtils.isLoad(condition.value(), condition.versionPredicates())) continue;
            AnnotationProcessor.requireInfo(rule, condition);
            return false;
        }
        return true;
    }

    private static void conflictInfo(String rule, Condition condition) {
        if (!CCAUtils.isEnableDebug()) {
            return;
        }
        CrystalCarpetAdditionMod.LOGGER.info("[CCA] Rule {} is disabled, Because of the conflict with {}({}).", new Object[]{rule, condition.value(), condition.versionPredicates()});
    }

    private static void requireInfo(String rule, Condition condition) {
        if (!CCAUtils.isEnableDebug()) {
            return;
        }
        CrystalCarpetAdditionMod.LOGGER.info("[CCA] Rule {} is disabled, Because of the require with {}({}).", new Object[]{rule, condition.value(), condition.versionPredicates()});
    }
}

