/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings.defaults;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.defaults.DefaultBindProvider;
import dev.isxander.controlify.bindings.defaults.LayeredDefaultBindProvider;
import dev.isxander.controlify.bindings.defaults.MapBackedDefaultBindProvider;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.platform.client.resource.SimpleControlifyReloadListener;
import dev.isxander.controlify.utils.CUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DefaultBindManager
implements SimpleControlifyReloadListener<Preparations> {
    public static final String DIRECTORY = "controllers/default_bind";
    private static final FileToIdConverter converter = FileToIdConverter.m_246568_((String)"controllers/default_bind");
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<ResourceLocation, DefaultBindProvider> defaultsByNamespace = new HashMap<ResourceLocation, DefaultBindProvider>();

    @Override
    public CompletableFuture<@Nullable Preparations> load(ResourceManager manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Map defaultFiles = converter.m_246760_(manager);
            HashMap<ResourceLocation, DefaultBindProvider> defaultsByNamespace = new HashMap<ResourceLocation, DefaultBindProvider>();
            ResourceLocation defaultNamespaceFile = converter.m_245698_(ControllerType.DEFAULT.namespace());
            if (!defaultFiles.containsKey(defaultNamespaceFile)) {
                LOGGER.error("No default binds found! Everything will be unbound!");
                return null;
            }
            LayeredDefaultBindProvider defaultNamespaceDefaults = new LayeredDefaultBindProvider((List)this.readDefaults(defaultNamespaceFile, (List)defaultFiles.get(defaultNamespaceFile)).getSecond());
            defaultsByNamespace.put(ControllerType.DEFAULT.namespace(), defaultNamespaceDefaults);
            for (Map.Entry stack : defaultFiles.entrySet()) {
                ResourceLocation id = (ResourceLocation)stack.getKey();
                List files = (List)stack.getValue();
                if (id.equals((Object)defaultNamespaceFile)) continue;
                Pair<ResourceLocation, List<LayeredDefaultBindProvider.Layer>> defaults = this.readDefaults(id, files);
                ((List)defaults.getSecond()).add(new LayeredDefaultBindProvider.Layer(defaultNamespaceDefaults, false));
                LayeredDefaultBindProvider defaultBindProvider = new LayeredDefaultBindProvider((List)defaults.getSecond());
                defaultsByNamespace.put((ResourceLocation)defaults.getFirst(), defaultBindProvider);
            }
            return new Preparations(defaultsByNamespace);
        }, executor);
    }

    private Pair<ResourceLocation, List<LayeredDefaultBindProvider.Layer>> readDefaults(ResourceLocation id, List<Resource> files) {
        ArrayList<LayeredDefaultBindProvider.Layer> defaults = new ArrayList<LayeredDefaultBindProvider.Layer>();
        for (Resource resource : files) {
            try {
                BufferedReader reader = resource.m_215508_();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    ControllerDefault def = (ControllerDefault)ControllerDefault.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElseThrow();
                    defaults.add(0, new LayeredDefaultBindProvider.Layer(def.provider(), def.clearBelow()));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException | IllegalStateException e) {
                LOGGER.error("Failed to parse {}", (Object)id, (Object)e);
            }
        }
        ResourceLocation namespace = converter.m_245273_(id);
        return Pair.of((Object)namespace, defaults);
    }

    @Override
    public CompletableFuture<Void> apply(@Nullable Preparations data, ResourceManager manager, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            ArrayList defaultedBindings = new ArrayList();
            for (ControllerEntity controller : Controlify.instance().getControllerManager().map(ControllerManager::getConnectedControllers).orElse(List.of())) {
                controller.input().ifPresent(input -> {
                    if (!((InputComponent.Config)input.confObj()).keepDefaultBindings) {
                        for (InputBinding binding : input.getAllBindings()) {
                            if (!binding.boundInput().equals(binding.defaultInput())) continue;
                            defaultedBindings.add(binding);
                        }
                    }
                });
            }
            this.defaultsByNamespace.clear();
            if (data != null) {
                this.defaultsByNamespace.putAll(data.map());
            }
            for (InputBinding binding : defaultedBindings) {
                binding.setBoundInput(binding.defaultInput());
            }
        }, executor);
    }

    public DefaultBindProvider getDefaultBindProvider(ResourceLocation namespace) {
        DefaultBindProvider provider = this.defaultsByNamespace.get(namespace);
        if (provider == null) {
            provider = this.defaultsByNamespace.get(ControllerType.DEFAULT.namespace());
        }
        if (provider == null) {
            provider = DefaultBindProvider.EMPTY;
        }
        return provider;
    }

    @Override
    public ResourceLocation getReloadId() {
        return CUtil.rl("default_binds");
    }

    private record ControllerDefault(boolean clearBelow, MapBackedDefaultBindProvider provider) {
        public static final Codec<ControllerDefault> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("clear_below", (Object)false).forGetter(ControllerDefault::clearBelow), (App)MapBackedDefaultBindProvider.MAP_CODEC.fieldOf("defaults").forGetter(ControllerDefault::provider)).apply((Applicative)instance, ControllerDefault::new));
    }

    public record Preparations(Map<ResourceLocation, DefaultBindProvider> map) {
    }
}

