/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.input.mapping;

import dev.isxander.controlify.controller.input.ControllerState;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.ModifiableControllerState;
import dev.isxander.controlify.controller.input.mapping.MapType;
import dev.isxander.controlify.utils.MthExt;
import net.minecraft.resources.ResourceLocation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MappingEntry {
    public void apply(ControllerState var1, ModifiableControllerState var2);

    public MapType inputType();

    public MapType outputType();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FromNothing
    extends MappingEntry {

        public record ToHat(ResourceLocation to, MapType inputType, MapType outputType) implements FromNothing
        {
            public ToHat(ResourceLocation to) {
                this(to, MapType.NOTHING, MapType.HAT);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setHat(this.to, HatState.CENTERED);
            }
        }

        public record ToAxis(ResourceLocation to, float state, MapType inputType, MapType outputType) implements FromNothing
        {
            public ToAxis(ResourceLocation to, float state) {
                this(to, state, MapType.NOTHING, MapType.AXIS);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setAxis(this.to, this.state);
            }
        }

        public record ToButton(ResourceLocation to, boolean state, MapType inputType, MapType outputType) implements FromNothing
        {
            public ToButton(ResourceLocation to, boolean state) {
                this(to, state, MapType.NOTHING, MapType.BUTTON);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setButton(this.to, this.state);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FromHat
    extends MappingEntry {

        public record ToHat(ResourceLocation from, ResourceLocation to, MapType inputType, MapType outputType) implements FromHat
        {
            public ToHat(ResourceLocation from, ResourceLocation to) {
                this(from, to, MapType.HAT, MapType.HAT);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setHat(this.to, oldState.getHatState(this.from));
            }
        }

        public record ToAxis(ResourceLocation from, ResourceLocation to, HatState targetState, float onState, float offState, MapType inputType, MapType outputType) implements FromHat
        {
            public ToAxis(ResourceLocation from, ResourceLocation to, HatState targetState, float onState, float offState) {
                this(from, to, targetState, onState, offState, MapType.HAT, MapType.AXIS);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setAxis(this.to, oldState.getHatState(this.from) == this.targetState ? this.onState : this.offState);
            }
        }

        public record ToButton(ResourceLocation from, ResourceLocation to, HatState targetState, MapType inputType, MapType outputType) implements FromHat
        {
            public ToButton(ResourceLocation from, ResourceLocation to, HatState targetState) {
                this(from, to, targetState, MapType.HAT, MapType.BUTTON);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setButton(this.to, oldState.getHatState(this.from) == this.targetState);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FromAxis
    extends MappingEntry {

        public record ToHat(ResourceLocation from, ResourceLocation to, float threshold, HatState targetState, MapType inputType, MapType outputType) implements FromAxis
        {
            public ToHat(ResourceLocation from, ResourceLocation to, float threshold, HatState targetState) {
                this(from, to, threshold, targetState, MapType.AXIS, MapType.HAT);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                float oldVal = oldState.getAxisState(this.from);
                newState.setHat(this.to, oldVal >= this.threshold ? this.targetState : HatState.CENTERED);
            }
        }

        public record ToAxis(ResourceLocation from, ResourceLocation to, float minIn, float minOut, float maxIn, float maxOut, MapType inputType, MapType outputType) implements FromAxis
        {
            public ToAxis(ResourceLocation from, ResourceLocation to, float minIn, float minOut, float maxIn, float maxOut) {
                this(from, to, minIn, minOut, maxIn, maxOut, MapType.AXIS, MapType.AXIS);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                float oldVal = oldState.getAxisState(this.from);
                float newVal = MthExt.remap(oldVal, this.minIn, this.maxIn, this.minOut, this.maxOut);
                newState.setAxis(this.to, newVal);
            }
        }

        public record ToButton(ResourceLocation from, ResourceLocation to, float threshold, MapType inputType, MapType outputType) implements FromAxis
        {
            public ToButton(ResourceLocation from, ResourceLocation to, float threshold) {
                this(from, to, threshold, MapType.AXIS, MapType.BUTTON);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setButton(this.to, oldState.getAxisState(this.from) >= this.threshold);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface FromButton
    extends MappingEntry {

        public record ToHat(ResourceLocation from, ResourceLocation to, HatState offState, HatState onState, MapType inputType, MapType outputType) implements FromButton
        {
            public ToHat(ResourceLocation from, ResourceLocation to, HatState offState, HatState onState) {
                this(from, to, offState, onState, MapType.BUTTON, MapType.HAT);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setHat(this.to, oldState.isButtonDown(this.from) ? this.onState : this.offState);
            }
        }

        public record ToAxis(ResourceLocation from, ResourceLocation to, float offState, float onState, MapType inputType, MapType outputType) implements FromButton
        {
            public ToAxis(ResourceLocation from, ResourceLocation to, float offState, float onState) {
                this(from, to, offState, onState, MapType.BUTTON, MapType.AXIS);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                newState.setAxis(this.to, oldState.isButtonDown(this.from) ? this.onState : this.offState);
            }
        }

        public record ToButton(ResourceLocation from, ResourceLocation to, boolean invert, MapType inputType, MapType outputType) implements FromButton
        {
            public ToButton(ResourceLocation from, ResourceLocation to, boolean invert) {
                this(from, to, invert, MapType.BUTTON, MapType.BUTTON);
            }

            @Override
            public void apply(ControllerState oldState, ModifiableControllerState newState) {
                boolean fromState = oldState.isButtonDown(this.from);
                if (this.invert()) {
                    fromState = !fromState;
                }
                newState.setButton(this.to, fromState);
            }
        }
    }
}

