/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controllermanager;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.controllermanager.UniqueControllerID;
import dev.isxander.controlify.driver.steamdeck.SteamDeckUtil;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.hid.HIDIdentifier;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.ResourceProvider;

public abstract class AbstractControllerManager
implements ControllerManager {
    protected final Controlify controlify;
    protected final Minecraft minecraft;
    protected final Map<UniqueControllerID, ControllerEntity> controllersByJid = new Object2ObjectOpenHashMap();
    protected final Map<String, ControllerEntity> controllersByUid = new Object2ObjectOpenHashMap();
    protected final Map<String, ControllerHIDService.ControllerHIDInfo> hidInfoByUid = new Object2ObjectOpenHashMap();
    protected final ControlifyLogger logger;

    public AbstractControllerManager(ControlifyLogger logger) {
        this.controlify = Controlify.instance();
        this.minecraft = Minecraft.m_91087_();
        this.logger = logger.createSubLogger("ControllerManager");
        this.loadGamepadMappings((ResourceProvider)this.minecraft.m_91098_());
    }

    public Optional<ControllerEntity> tryCreate(UniqueControllerID ucid, ControllerHIDService.ControllerHIDInfo hidInfo) {
        ControlifyLogger controllerLogger = this.logger.createSubLogger("Controller #" + String.valueOf(ucid));
        try {
            if (this.controllersByJid.containsKey(ucid)) {
                controllerLogger.warn("Tried to create controller that already is initialised: {}.", ucid);
                return Optional.empty();
            }
            if (hidInfo.type().dontLoad()) {
                controllerLogger.debugLog("Preventing load of controller #" + String.valueOf(ucid) + " because its type prevents loading.");
                return Optional.empty();
            }
            if (hidInfo.type().isSteamDeck() && SteamDeckUtil.DECK_MODE.isDesktopMode()) {
                controllerLogger.log("Preventing load of controller #{} because Steam Deck is in desktop mode.", ucid);
                return Optional.empty();
            }
            return this.createController(ucid, hidInfo, controllerLogger);
        }
        catch (Throwable e) {
            controllerLogger.error("Failed to create controller #{}!", e, ucid);
            CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)("Creating controller #" + String.valueOf(ucid)));
            CrashReportCategory category = crashReport.m_127514_("Controller Info");
            category.m_128159_("Unique controller ID", (Object)ucid);
            category.m_128159_("Controller identification", (Object)hidInfo.type());
            category.m_128159_("HID path", (Object)hidInfo.hidDevice().map(HIDDevice::path).orElse("N/A"));
            category.m_128159_("HID service status", (Object)(Controlify.instance().controllerHIDService().isDisabled() ? "Disabled" : "Enabled"));
            category.m_128159_("System name", (Object)Optional.ofNullable(this.getControllerSystemName(ucid)).orElse("N/A"));
            controllerLogger.crashReport(crashReport);
            return Optional.empty();
        }
    }

    protected abstract Optional<ControllerEntity> createController(UniqueControllerID var1, ControllerHIDService.ControllerHIDInfo var2, ControlifyLogger var3);

    @Override
    public void tick(boolean outOfFocus) {
        for (ControllerEntity controller : this.controllersByUid.values()) {
            controller.update(outOfFocus);
            ControlifyEvents.CONTROLLER_STATE_UPDATE.invoke(new ControlifyEvents.ControllerStateUpdate(controller));
        }
    }

    protected void onControllerConnected(ControllerEntity controller, boolean hotplug) {
        boolean newController = this.controlify.config().loadControllerConfig(controller);
        this.logger.log("Controller connected: {}", ControllerUtils.createControllerString(controller));
        ControlifyEvents.CONTROLLER_CONNECTED.invoke(new ControlifyEvents.ControllerConnected(controller, hotplug, newController));
    }

    protected void onControllerRemoved(ControllerEntity controller) {
        this.logger.log("Controller disconnected: {}", ControllerUtils.createControllerString(controller));
        this.closeController(controller.uid());
        ControlifyEvents.CONTROLLER_DISCONNECTED.invoke(new ControlifyEvents.ControllerDisconnected(controller));
    }

    @Override
    public Optional<ControllerEntity> reinitController(ControllerEntity controller, ControllerHIDService.ControllerHIDInfo hidInfo) {
        this.onControllerRemoved(controller);
        Optional<ControllerEntity> newController = this.tryCreate(controller.info().ucid(), hidInfo);
        newController.ifPresent(c -> ControllerUtils.wrapControllerError(() -> this.onControllerConnected((ControllerEntity)c, true), "Connecting controller", c));
        return newController;
    }

    protected void addController(UniqueControllerID ucid, ControllerEntity controller) {
        this.controllersByUid.put(controller.uid(), controller);
        this.controllersByJid.put(ucid, controller);
    }

    @Override
    public void closeController(String uid) {
        ControllerEntity controller = this.controllersByUid.remove(uid);
        if (controller == null) {
            return;
        }
        controller.close();
        this.controllersByJid.remove(controller.info().ucid());
        Optional.ofNullable(this.hidInfoByUid.remove(uid)).ifPresent(this.controlify.controllerHIDService()::unconsumeController);
    }

    @Override
    public List<ControllerEntity> getConnectedControllers() {
        return ImmutableList.copyOf(this.controllersByUid.values());
    }

    @Override
    public boolean isControllerConnected(String uid) {
        return this.controllersByUid.containsKey(uid);
    }

    protected int getControllerCountWithMatchingHID(HIDIdentifier hid) {
        return (int)this.controllersByJid.values().stream().filter(c -> c.info().hid().isPresent() && c.info().hid().get().asIdentifier().equals(hid)).count();
    }

    @Override
    public void close() {
        this.controllersByUid.values().forEach(ControllerEntity::close);
    }

    protected abstract void loadGamepadMappings(ResourceProvider var1);

    protected abstract String getControllerSystemName(UniqueControllerID var1);
}

