/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.font;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.platform.client.resource.SimpleControlifyReloadListener;
import dev.isxander.controlify.utils.CUtil;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class InputFontMapper
implements SimpleControlifyReloadListener<Preparations> {
    private ImmutableMap<ResourceLocation, FontMap> mappings = ImmutableMap.of();
    private FontMap defaultFontMap;
    private static final Codec<Character> CHAR_CODEC = Codec.STRING.comapFlatMap(str -> {
        if (str.length() != 1) {
            return DataResult.error(() -> "Expected a single character string, got " + str);
        }
        return DataResult.success((Object)Character.valueOf(str.charAt(0)));
    }, String::valueOf);
    private static final Codec<Pair<Character, Map<ResourceLocation, Character>>> FONT_MAP_CODEC = Codec.pair((Codec)CHAR_CODEC.fieldOf("unknown").codec(), (Codec)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, CHAR_CODEC));
    private static final FileToIdConverter fileToIdConverter = FileToIdConverter.m_246568_((String)"controllers/font_mappings");

    @Override
    public CompletableFuture<Preparations> load(ResourceManager manager, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            Map mappingResources = fileToIdConverter.m_247457_(manager);
            Map<ResourceLocation, FontMap> mappings = mappingResources.entrySet().stream().flatMap(entry -> {
                ResourceLocation rl = (ResourceLocation)entry.getKey();
                Resource resource = (Resource)entry.getValue();
                ResourceLocation namespace = fileToIdConverter.m_245273_(rl);
                try (BufferedReader reader = resource.m_215508_();){
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    FontMap map = FONT_MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).resultOrPartial(CUtil.LOGGER::error).map(pair -> new FontMap(namespace, ((Character)pair.getFirst()).charValue(), (Map)pair.getSecond())).orElse(null);
                    if (map == null) return Stream.empty();
                    Stream<Pair> stream = Stream.of(Pair.of((Object)namespace, (Object)map));
                    return stream;
                }
                catch (Exception e) {
                    CUtil.LOGGER.error("Failed to load font mappings for namespace {}", namespace, e);
                }
                return Stream.empty();
            }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            return new Preparations(mappings);
        });
    }

    @Override
    public CompletableFuture<Void> apply(Preparations data, ResourceManager manager, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            data.mappings().forEach((arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
            this.mappings = builder.build();
            this.defaultFontMap = (FontMap)this.mappings.get((Object)ControllerType.DEFAULT.namespace());
        }, executor);
    }

    public FontMap getMappings(ResourceLocation namespace) {
        return (FontMap)this.mappings.getOrDefault((Object)namespace, (Object)this.defaultFontMap);
    }

    public Component getComponentFromBinding(ResourceLocation namespace, @Nullable InputBinding binding) {
        if (binding == null) {
            return Component.m_237113_((String)"?");
        }
        List<ResourceLocation> relevantInputs = binding.boundInput().getRelevantInputs();
        return this.getComponentFromInputs(namespace, relevantInputs);
    }

    public Component getComponentFromBind(ResourceLocation namespace, Input input) {
        List<ResourceLocation> relevantInputs = input.getRelevantInputs();
        return this.getComponentFromInputs(namespace, relevantInputs);
    }

    public Component getComponentFromInputs(ResourceLocation namespace, List<ResourceLocation> inputs) {
        if (inputs.isEmpty()) {
            return Component.m_237113_((String)"<unbound>");
        }
        FontMap fontMap = this.getMappings(namespace);
        String literal = inputs.stream().map(input -> String.valueOf(this.getChar(fontMap, (ResourceLocation)input))).collect(Collectors.joining("+"));
        return Component.m_237113_((String)literal).m_130938_(style -> style.m_131150_(fontMap.namespace().m_246208_("controller/")));
    }

    private char getChar(FontMap fontMap, ResourceLocation input) {
        Character ch = fontMap.inputToChar().get(input);
        if (ch == null) {
            ch = this.defaultFontMap.inputToChar().getOrDefault(input, Character.valueOf(fontMap.unknown()));
        }
        return ch.charValue();
    }

    @Override
    public ResourceLocation getReloadId() {
        return CUtil.rl("font_mappings");
    }

    public record Preparations(Map<ResourceLocation, FontMap> mappings) {
    }

    public record FontMap(ResourceLocation namespace, char unknown, Map<ResourceLocation, Character> inputToChar) {
    }
}

