/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.guide;

import dev.isxander.controlify.font.BindingFontHelper;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.layout.RenderComponent;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class GuideActionRenderer<T>
implements RenderComponent {
    private final GuideAction<T> guideAction;
    private final boolean rtl;
    private final boolean textContrast;
    private Component bindingText;
    private int bindingTextWidth;
    private Component name = null;

    public GuideActionRenderer(GuideAction<T> action, boolean rtl, boolean textContrast) {
        this.guideAction = action;
        this.rtl = rtl;
        this.textContrast = textContrast;
        this.bindingText = action.binding().inputIcon();
        this.bindingTextWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.bindingText);
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float deltaTime) {
        if (!this.isVisible()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92852_((FormattedText)this.name);
        int bindingHeight = BindingFontHelper.getComponentHeight(font, (FormattedText)this.bindingText);
        int n = y + bindingHeight / 2;
        Objects.requireNonNull(font);
        int centeredTextY = n - 9 / 2;
        if (!this.rtl) {
            graphics.m_280614_(font, this.bindingText, x, centeredTextY, -1, false);
            x += this.bindingTextWidth + 4;
        }
        if (this.textContrast) {
            Objects.requireNonNull(font);
            graphics.m_280509_(x - 1, centeredTextY - 1, x + textWidth + 1, centeredTextY + 9 + 1, Integer.MIN_VALUE);
        }
        graphics.m_280614_(font, this.name, x, centeredTextY, -1, false);
        x += textWidth + 4;
        if (this.rtl) {
            graphics.m_280614_(font, this.bindingText, x, centeredTextY, -1, false);
        }
    }

    @Override
    public Vector2ic size() {
        if (!this.isVisible()) {
            return new Vector2i();
        }
        Font font = Minecraft.m_91087_().f_91062_;
        int n = font.m_92852_((FormattedText)this.name) + 4 + this.bindingTextWidth;
        int n2 = BindingFontHelper.getComponentHeight(font, (FormattedText)this.bindingText);
        Objects.requireNonNull(font);
        return new Vector2i(n, Math.max(n2, 9) + 2);
    }

    @Override
    public boolean isVisible() {
        return this.name != null && !this.guideAction.binding().isUnbound() && this.bindingText != null;
    }

    public void updateName(T ctx) {
        this.bindingText = this.guideAction.binding().inputIcon();
        this.bindingTextWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.bindingText);
        this.name = this.guideAction.name().supply(ctx).orElse(null);
    }
}

