/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.gyro.GyroState;
import dev.isxander.controlify.controller.input.ControllerState;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.utils.ClientUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ControllerCalibrationScreen
extends Screen
implements DontInteruptScreen {
    private static final int CALIBRATION_TIME = 100;
    protected final Controlify controlify;
    protected final ControllerManager controllerManager;
    protected final ControllerEntity controller;
    private final Supplier<Screen> parent;
    private MultiLineLabel waitLabel;
    private MultiLineLabel infoLabel;
    private MultiLineLabel completeLabel;
    protected Button readyButton;
    protected Button laterButton;
    protected boolean calibrating = false;
    protected boolean calibrated = false;
    protected int calibrationTicks = 0;
    @Nullable
    private final Map<ResourceLocation, float[]> axisData;
    private GyroState accumulatedGyroVelocity = new GyroState();

    public ControllerCalibrationScreen(ControllerEntity controller, Screen parent) {
        this(controller, () -> parent);
    }

    public ControllerCalibrationScreen(ControllerEntity controller, Supplier<Screen> parent) {
        super((Component)Component.m_237115_((String)"controlify.calibration.title"));
        this.controlify = Controlify.instance();
        this.controllerManager = this.controlify.getControllerManager().orElseThrow();
        this.controller = controller;
        this.parent = parent;
        Optional<InputComponent> inputOpt = controller.input();
        this.axisData = inputOpt.map(inputComponent -> new HashMap(inputComponent.axisCount())).orElse(null);
    }

    protected void m_7856_() {
        this.readyButton = Button.m_253074_((Component)Component.m_237115_((String)"controlify.calibration.ready"), btn -> this.onButtonPress()).m_252780_(150).m_252794_(this.f_96543_ / 2 - 150 - 5, this.f_96544_ - 8 - 20).m_253136_();
        this.m_142416_((GuiEventListener)this.readyButton);
        this.laterButton = Button.m_253074_((Component)Component.m_237115_((String)"controlify.calibration.later"), btn -> this.onLaterButtonPress()).m_252780_(150).m_252794_(this.f_96543_ / 2 + 5, this.f_96544_ - 8 - 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"controlify.calibration.later.tooltip"))).m_253136_();
        this.m_142416_((GuiEventListener)this.laterButton);
        this.infoLabel = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)Component.m_237115_((String)"controlify.calibration.info"), (int)(this.f_96543_ - 30));
        this.waitLabel = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)Component.m_237115_((String)"controlify.calibration.wait"), (int)(this.f_96543_ - 30));
        this.completeLabel = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)Component.m_237115_((String)"controlify.calibration.complete"), (int)(this.f_96543_ - 30));
    }

    protected void startCalibration() {
        this.calibrating = true;
        this.readyButton.f_93623_ = false;
        this.readyButton.m_93666_((Component)Component.m_237115_((String)"controlify.calibration.calibrating"));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237110_((String)"controlify.calibration.title", (Object[])new Object[]{this.controller.name()}).m_130940_(ChatFormatting.BOLD), this.f_96543_ / 2, 8, -1);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
        float progress = ((float)(this.calibrationTicks - 1) + delta) / 100.0f;
        progress = 1.0f - (float)Math.pow(1.0f - progress, 3.0);
        ClientUtils.drawBar(graphics, this.f_96543_ / 2 / 2, 15, progress);
        graphics.m_280168_().m_85849_();
        MultiLineLabel label = this.calibrating ? this.waitLabel : (this.calibrated ? this.completeLabel : this.infoLabel);
        label.m_6276_(graphics, this.f_96543_ / 2, 55);
        graphics.m_280168_().m_85836_();
        int n = this.readyButton.m_252907_();
        Objects.requireNonNull(this.f_96547_);
        float scale = Math.min(3.0f, (float)(n - (55 + 9 * label.m_5770_()) - 2) / 64.0f);
        PoseStack poseStack = graphics.m_280168_();
        float f = (float)this.f_96543_ / 2.0f - 32.0f * scale;
        Objects.requireNonNull(this.f_96547_);
        poseStack.m_252880_(f, (float)(55 + 9 * label.m_5770_()), 0.0f);
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        ClientUtils.drawSprite(graphics, this.controller.info().type().getIconSprite(), 0, 0, 64, 64);
        graphics.m_280168_().m_85849_();
    }

    public void m_86600_() {
        if (!this.controllerManager.isControllerConnected(this.controller.uid())) {
            this.m_7379_();
            return;
        }
        if (!this.calibrating) {
            return;
        }
        if (this.stateChanged()) {
            this.calibrationTicks = 0;
            if (this.axisData != null) {
                this.axisData.clear();
            }
            this.accumulatedGyroVelocity = new GyroState();
        }
        if (this.calibrationTicks < 100) {
            this.processAxisData(this.calibrationTicks);
            this.processGyroData();
            ++this.calibrationTicks;
        } else {
            this.calibrateAxis();
            this.generateGyroCalibration();
            this.calibrating = false;
            this.calibrated = true;
            this.readyButton.f_93623_ = true;
            this.readyButton.m_93666_((Component)Component.m_237115_((String)"controlify.calibration.done"));
            this.controller.input().map(input -> input.config().config()).ifPresent(config -> {
                config.deadzonesCalibrated = true;
                config.delayedCalibration = false;
            });
            this.controller.gyro().map(gyro -> gyro.config().config()).ifPresent(config -> {
                config.calibrated = true;
            });
            Controlify.instance().config().setDirty();
            Controlify.instance().config().saveIfDirty();
        }
    }

    private void processAxisData(int tick) {
        if (this.axisData == null) {
            return;
        }
        InputComponent input = this.controller.input().orElseThrow();
        ControllerState state = input.rawStateNow();
        for (DeadzoneGroup group : input.getDeadzoneGroups().values()) {
            float[] axisData = this.axisData.computeIfAbsent(group.name(), k -> new float[100]);
            float max = 0.0f;
            for (ResourceLocation axis : group.axes()) {
                max = Math.max(max, Math.abs(state.getAxisState(axis)));
            }
            axisData[tick] = max;
        }
    }

    private void processGyroData() {
        this.controller.gyro().ifPresent(gyro -> this.accumulatedGyroVelocity.add(gyro.getState()));
    }

    private void calibrateAxis() {
        if (this.axisData == null) {
            return;
        }
        InputComponent input = this.controller.input().orElseThrow();
        input.config().config().deadzones.clear();
        for (DeadzoneGroup group : input.getDeadzoneGroups().values()) {
            float[] axisData = this.axisData.get(group.name());
            if (axisData == null) continue;
            float maxAbs = 0.0f;
            for (int tick = 0; tick < 100; ++tick) {
                float axisValue = axisData[tick];
                maxAbs = Math.max(maxAbs, Math.abs(axisValue));
            }
            input.config().config().deadzones.put(group.name(), Float.valueOf(maxAbs + 0.08f));
        }
    }

    private void generateGyroCalibration() {
        this.controller.gyro().ifPresent(gyro -> {
            gyro.config().config().calibration = this.accumulatedGyroVelocity.div(100.0f);
        });
    }

    private boolean stateChanged() {
        InputComponent input = this.controller.input().orElseThrow();
        float amt = 0.4f;
        for (ResourceLocation axis : input.rawStateNow().getAxes()) {
            float prevAxisValue;
            float axisValue;
            float[] axisData = this.axisData.get(axis);
            if (axisData == null || !(Math.abs((axisValue = input.rawStateNow().getAxisState(axis)) - (prevAxisValue = input.rawStateThen().getAxisState(axis))) > amt)) continue;
            return true;
        }
        return false;
    }

    private void onButtonPress() {
        if (!this.calibrated) {
            this.startCalibration();
            this.m_169411_((GuiEventListener)this.laterButton);
            this.readyButton.m_252865_(this.f_96543_ / 2 - 75);
        } else {
            this.m_7379_();
        }
    }

    private void onLaterButtonPress() {
        if (!this.calibrated) {
            boolean dirty = false;
            dirty |= this.controller.input().map(input -> {
                input.config().config().delayedCalibration = true;
                return true;
            }).orElse(false).booleanValue();
            if (dirty |= this.controller.gyro().map(gyro -> {
                gyro.config().config().delayedCalibration = true;
                return true;
            }).orElse(false).booleanValue()) {
                Controlify.instance().config().setDirty();
            }
            this.m_7379_();
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent.get());
    }

    public boolean m_6913_() {
        return false;
    }
}

