/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.GamepadInputs;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.input.mapping.ControllerMapping;
import dev.isxander.controlify.controller.input.mapping.MapType;
import dev.isxander.controlify.controller.input.mapping.MappingEntry;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ClientUtils;
import dev.isxander.controlify.utils.ColorUtils;
import dev.isxander.controlify.utils.render.Blit;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ControllerMappingMakerScreen
extends Screen
implements ScreenControllerEventListener,
ScreenProcessorProvider,
DontInteruptScreen {
    private final InputComponent inputComponent;
    private final ControllerMapping.Builder mappingBuilder = new ControllerMapping.Builder();
    private final ScreenProcessor<ControllerMappingMakerScreen> screenProcessor = new ScreenProcessorImpl(this);
    private int delayTillNextStage = 20;
    public static final List<MappingStage> GAMEPAD_STAGES = List.of(new MappingStage(GamepadInputs.SOUTH_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("face_down"), "face_down", "faceview"), new MappingStage(GamepadInputs.WEST_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("face_left"), "face_left", "faceview"), new MappingStage(GamepadInputs.EAST_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("face_right"), "face_right", "faceview"), new MappingStage(GamepadInputs.NORTH_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("face_up"), "face_up", "faceview"), new MappingStage(GamepadInputs.LEFT_SHOULDER_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("left_bumper"), "left_bumper", "triggerview"), new MappingStage(GamepadInputs.RIGHT_SHOULDER_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("right_bumper"), "right_bumper", "triggerview"), new MappingStage(GamepadInputs.START_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("left_special"), "left_special", "faceview"), new MappingStage(GamepadInputs.GUIDE_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("right_special"), "right_special", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("left_stick_down"), "left_stick_press", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("right_stick_down"), "right_stick_press", "faceview"), new MappingStage(GamepadInputs.DPAD_UP_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("dpad_up"), "dpad_up", "faceview"), new MappingStage(GamepadInputs.DPAD_LEFT_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("dpad_left"), "dpad_left", "faceview"), new MappingStage(GamepadInputs.DPAD_DOWN_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("dpad_down"), "dpad_down", "faceview"), new MappingStage(GamepadInputs.DPAD_RIGHT_BUTTON, MapType.BUTTON, ControllerMappingMakerScreen.button("dpad_right"), "dpad_right", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_AXIS_LEFT, MapType.AXIS, ControllerMappingMakerScreen.axis("left_stick", true), "left_stick_left", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_AXIS_DOWN, MapType.AXIS, ControllerMappingMakerScreen.axis("left_stick", false), "left_stick_down", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_AXIS_RIGHT, MapType.AXIS, ControllerMappingMakerScreen.axis("left_stick", true), "left_stick_right", "faceview"), new MappingStage(GamepadInputs.LEFT_STICK_AXIS_UP, MapType.AXIS, ControllerMappingMakerScreen.axis("left_stick", false), "left_stick_up", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_AXIS_LEFT, MapType.AXIS, ControllerMappingMakerScreen.axis("right_stick", true), "right_stick_left", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_AXIS_DOWN, MapType.AXIS, ControllerMappingMakerScreen.axis("right_stick", false), "right_stick_down", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_AXIS_RIGHT, MapType.AXIS, ControllerMappingMakerScreen.axis("right_stick", true), "right_stick_right", "faceview"), new MappingStage(GamepadInputs.RIGHT_STICK_AXIS_UP, MapType.AXIS, ControllerMappingMakerScreen.axis("right_stick", false), "right_stick_up", "faceview"), new MappingStage(GamepadInputs.LEFT_TRIGGER_AXIS, MapType.AXIS, (Component)Component.m_237115_((String)"controlify.gui.mapping_maker.instruction.left_trigger"), "left_trigger", "triggerview"), new MappingStage(GamepadInputs.RIGHT_TRIGGER_AXIS, MapType.AXIS, (Component)Component.m_237115_((String)"controlify.gui.mapping_maker.instruction.right_trigger"), "right_trigger", "triggerview"));
    private MappingStage currentStage = null;
    private final List<MappingStage> stages;
    private Button goBackButton;
    private final Screen lastScreen;

    public ControllerMappingMakerScreen(InputComponent inputComponent, Screen lastScreen, List<MappingStage> stages, Iterable<DeadzoneGroup> deadzoneGroups) {
        super((Component)Component.m_237113_((String)"Gamepad Emulation Mapping Creator"));
        this.inputComponent = inputComponent;
        this.lastScreen = lastScreen;
        this.stages = stages;
        this.mappingBuilder.putDeadzoneGroups(deadzoneGroups);
        ((InputComponent.Config)inputComponent.confObj()).mapping = null;
    }

    public static ControllerMappingMakerScreen createGamepadMapping(InputComponent inputComponent, Screen lastScreen) {
        return new ControllerMappingMakerScreen(inputComponent, lastScreen, GAMEPAD_STAGES, GamepadInputs.DEADZONE_GROUPS);
    }

    protected void m_7856_() {
        this.goBackButton = Button.m_253074_((Component)Component.m_237115_((String)"controlify.gui.mapping_maker.go_back"), button -> this.goBackStage()).m_252987_(this.f_96543_ / 2 - 152, this.f_96544_ - 60, 150, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"controlify.gui.mapping_maker.go_back.tooltip"))).m_253136_();
        this.m_142416_((GuiEventListener)this.goBackButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"controlify.gui.mapping_maker.no_map"), button -> this.mapAsNone()).m_252987_(this.f_96543_ / 2 + 2, this.f_96544_ - 60, 150, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"controlify.gui.mapping_maker.no_map.tooltip"))).m_253136_());
        this.goBackButton.f_93623_ = false;
    }

    public void m_86600_() {
        if (this.delayTillNextStage >= 0) {
            --this.delayTillNextStage;
            if (this.delayTillNextStage == -1) {
                if (this.currentStage == null) {
                    this.setStage(this.stages.get(0));
                } else {
                    int index = this.stages.indexOf(this.currentStage);
                    int nextIndex = index + 1;
                    if (nextIndex >= this.stages.size()) {
                        this.m_7379_();
                    } else {
                        this.setStage(this.stages.get(index + 1));
                        this.goBackButton.f_93623_ = true;
                    }
                }
            }
        } else {
            if (this.currentStage == null) {
                this.setStage(this.stages.get(0));
            } else if (this.currentStage.isSatisfied() && this.delayTillNextStage == -1) {
                this.delayTillNextStage = 20;
            }
            if (this.currentStage != null && !this.currentStage.isSatisfied()) {
                ControllerStateView stateNow = this.inputComponent.stateNow();
                ControllerStateView stateThen = this.inputComponent.stateThen();
                this.processStage(this.currentStage, stateNow, stateThen);
            }
        }
    }

    private void processStage(MappingStage stage, ControllerStateView stateNow, ControllerStateView stateThen) {
        for (ResourceLocation button : stateNow.getButtons()) {
            boolean prev;
            boolean now = stateNow.isButtonDown(button);
            if (now == (prev = stateThen.isButtonDown(button))) continue;
            Record mapping = switch (stage.outputType()) {
                default -> throw new IncompatibleClassChangeError();
                case MapType.BUTTON -> new MappingEntry.FromButton.ToButton(button, stage.originInput(), !now);
                case MapType.AXIS -> new MappingEntry.FromButton.ToAxis(button, stage.originInput(), prev ? 1.0f : 0.0f, now ? 1.0f : 0.0f);
                case MapType.HAT -> {
                    HatState state = now ? HatState.DOWN : HatState.UP;
                    yield new MappingEntry.FromButton.ToHat(button, stage.originInput(), HatState.CENTERED, state);
                }
                case MapType.NOTHING -> null;
            };
            this.mappingBuilder.putMapping((MappingEntry)((Object)mapping));
            stage.setSatisfied(true);
            return;
        }
        for (ResourceLocation axis : stateNow.getAxes()) {
            float now = stateNow.getAxisState(axis);
            float prev = stateThen.getAxisState(axis);
            float diff = prev - now;
            if (!(Math.abs(diff) > 0.3f)) continue;
            Record mapping = switch (stage.outputType()) {
                default -> throw new IncompatibleClassChangeError();
                case MapType.BUTTON -> new MappingEntry.FromAxis.ToButton(axis, stage.originInput(), 0.5f);
                case MapType.AXIS -> new MappingEntry.FromAxis.ToAxis(axis, stage.originInput(), 0.0f, 0.0f, 1.0f, 1.0f);
                case MapType.HAT -> new MappingEntry.FromAxis.ToHat(axis, stage.originInput(), 0.5f, diff > 0.0f ? HatState.UP : HatState.DOWN);
                case MapType.NOTHING -> null;
            };
            this.mappingBuilder.putMapping((MappingEntry)((Object)mapping));
            stage.setSatisfied(true);
            return;
        }
        for (ResourceLocation hat : stateNow.getHats()) {
            HatState prev;
            HatState now = stateNow.getHatState(hat);
            if (now == (prev = stateThen.getHatState(hat))) continue;
            Record mapping = switch (stage.outputType()) {
                default -> throw new IncompatibleClassChangeError();
                case MapType.BUTTON -> new MappingEntry.FromHat.ToButton(hat, stage.originInput(), now);
                case MapType.AXIS -> new MappingEntry.FromHat.ToAxis(hat, stage.originInput(), now, 0.0f, 1.0f);
                case MapType.HAT -> new MappingEntry.FromHat.ToHat(hat, stage.originInput());
                case MapType.NOTHING -> null;
            };
            this.mappingBuilder.putMapping((MappingEntry)((Object)mapping));
            stage.setSatisfied(true);
            return;
        }
    }

    private void setStage(MappingStage stage) {
        this.currentStage = stage;
    }

    private void mapAsNone() {
        Record mapping = switch (this.currentStage.outputType()) {
            default -> throw new IncompatibleClassChangeError();
            case MapType.BUTTON -> new MappingEntry.FromNothing.ToButton(this.currentStage.originInput(), false);
            case MapType.AXIS -> new MappingEntry.FromNothing.ToAxis(this.currentStage.originInput(), 0.0f);
            case MapType.HAT -> new MappingEntry.FromNothing.ToHat(this.currentStage.originInput());
            case MapType.NOTHING -> null;
        };
        this.mappingBuilder.putMapping((MappingEntry)((Object)mapping));
        this.delayTillNextStage = 0;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
        ((InputComponent.Config)this.inputComponent.confObj()).mapping = this.mappingBuilder.build();
        Controlify.instance().config().save();
    }

    private void goBackStage() {
        int index = this.stages.indexOf(this.currentStage);
        int nextIndex = index - 1;
        if (nextIndex >= 0) {
            this.setStage(this.stages.get(index - 1));
            this.currentStage.setSatisfied(false);
        }
        this.goBackButton.f_93623_ = nextIndex > 0;
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        float colour;
        super.m_88315_(guiGraphics, i, j, f);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"controlify.gui.mapping_maker.title"), this.f_96543_ / 2, 15, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, (Component)(this.currentStage == null ? Component.m_237115_((String)"controlify.gui.mapping_maker.please_wait") : this.currentStage.name()), this.f_96543_ / 2, this.f_96544_ - 20, 0xFFFFFF);
        int safeZone = Math.min(this.f_96543_, this.f_96544_) - 30;
        float scale = (float)safeZone / 32.0f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f, -5.0f, 0.0f);
        guiGraphics.m_280168_().m_252880_(-32.0f * scale / 2.0f, 0.0f, 0.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        float f2 = colour = this.currentStage != null && this.currentStage.isSatisfied() ? 0.46f : 1.0f;
        if (this.currentStage != null && this.currentStage.background() != null) {
            Blit.blitTex(guiGraphics, this.currentStage.background(), 0, 0, 0.0f, 0.0f, 32, 32, 32, 32, ColorUtils.grey(colour, 1.0f));
        }
        if (this.currentStage == null || !this.currentStage.isSatisfied()) {
            ResourceLocation texture = this.currentStage != null ? this.currentStage.foreground() : CUtil.rl("textures/gui/controllerdiagram/faceview.png");
            Blit.blitTex(guiGraphics, texture, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32, ColorUtils.grey(colour, 1.0f));
        }
        guiGraphics.m_280168_().m_85849_();
        float progress = this.currentStage != null ? (float)(this.stages.indexOf(this.currentStage) + 1) / (float)this.stages.size() : 0.0f;
        ClientUtils.drawBar(guiGraphics, this.f_96543_ / 2, this.f_96544_ - 30, progress);
    }

    private static Component button(String buttonName) {
        return Component.m_237110_((String)"controlify.gui.mapping_maker.instruction.button", (Object[])new Object[]{Component.m_237115_((String)("controlify.gui.mapping_maker.instruction." + buttonName))});
    }

    private static Component axis(String axisName, boolean horizontal) {
        MutableComponent axis = Component.m_237115_((String)("controlify.gui.mapping_maker.instruction." + axisName));
        return horizontal ? Component.m_237110_((String)"controlify.gui.mapping_maker.instruction.axis_x", (Object[])new Object[]{axis}) : Component.m_237110_((String)"controlify.gui.mapping_maker.instruction.axis_y", (Object[])new Object[]{axis});
    }

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.screenProcessor;
    }

    private static class ScreenProcessorImpl
    extends ScreenProcessor<ControllerMappingMakerScreen> {
        public ScreenProcessorImpl(ControllerMappingMakerScreen screen) {
            super(screen);
        }

        @Override
        public void onControllerUpdate(ControllerEntity controller) {
        }
    }

    public static class MappingStage {
        private final ResourceLocation originInput;
        private final MapType outputType;
        private final Component name;
        private final ResourceLocation foreground;
        private final ResourceLocation background;
        private boolean satisfied;

        public MappingStage(ResourceLocation originInput, MapType outputType, Component name, String foreground, String background) {
            this.originInput = originInput;
            this.outputType = outputType;
            this.name = name;
            this.foreground = CUtil.rl("textures/gui/controllerdiagram/" + foreground + ".png");
            this.background = CUtil.rl("textures/gui/controllerdiagram/" + foreground + ".png");
        }

        public ResourceLocation originInput() {
            return this.originInput;
        }

        public MapType outputType() {
            return this.outputType;
        }

        public Component name() {
            return this.name;
        }

        public ResourceLocation foreground() {
            return this.foreground;
        }

        public ResourceLocation background() {
            return this.background;
        }

        public boolean isSatisfied() {
            return this.satisfied;
        }

        public void setSatisfied(boolean satisfied) {
            this.satisfied = satisfied;
        }
    }
}

