/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.core;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.utils.InitialScreenRegistryDuck;
import dev.isxander.controlify.utils.MouseMinecraftCallNotifier;
import dev.isxander.controlify.utils.animation.impl.Animator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
implements InitialScreenRegistryDuck {
    @Shadow
    @Final
    public MouseHandler f_91067_;
    @Shadow
    @Nullable
    public Screen f_91080_;
    @Unique
    private final List<Function<Runnable, Screen>> initialScreenCallbacks = new ArrayList<Function<Runnable, Screen>>();
    @Unique
    private boolean initialScreensHappened = false;

    @Shadow
    public abstract void m_91152_(@Nullable Screen var1);

    @Shadow
    public abstract float m_91297_();

    @Shadow
    public abstract void m_91394_();

    @Shadow
    public abstract CrashReport m_91354_(CrashReport var1);

    @Unique
    private void emergencySaveAndCrash(CrashReport crashReport) {
        CrashReport filled = this.m_91354_(crashReport);
        this.m_91394_();
        Minecraft.m_91332_((CrashReport)filled);
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MouseHandler;releaseMouse()V")})
    private void notifyInjectionToNotRun(Screen screen, CallbackInfo ci) {
        ((MouseMinecraftCallNotifier)this.f_91067_).imFromMinecraftSetScreen();
    }

    @Inject(method={"setScreen"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init(Lnet/minecraft/client/Minecraft;II)V", shift=At.Shift.AFTER)})
    private void hideMouseAfterRelease(Screen screen, CallbackInfo ci) {
        if (ControlifyApi.get().currentInputMode().isController()) {
            Controlify.instance().hideMouse(true, true);
        }
    }

    @Inject(method={"onGameLoadFinished"}, at={@At(value="RETURN")})
    private void initControlifyNow(CallbackInfo ci) {
        try {
            Controlify.instance().initializeControlify();
        }
        catch (Throwable t) {
            CrashReport report = CrashReport.m_127521_((Throwable)t, (String)"Failed to initialize Controlify");
            this.emergencySaveAndCrash(report);
        }
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/MouseHandler;turnPlayer()V")})
    private void doPlayerLook(boolean tick, CallbackInfo ci) {
        Controlify.instance().inGameInputHandler().ifPresent(ih -> ih.processPlayerLook(this.getTickDelta()));
    }

    @Inject(method={"close"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/telemetry/ClientTelemetryManager;close()V", remap=true)}, remap=false)
    private void onMinecraftClose(CallbackInfo ci) {
        Controlify.instance().getControllerManager().ifPresent(ControllerManager::close);
    }

    @Inject(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/GameRenderer;render(FJZ)V")})
    private void tickAnimator(boolean tick, CallbackInfo ci) {
        Animator.INSTANCE.tick(this.getTickDelta());
    }

    @Unique
    private float getTickDelta() {
        return this.m_91297_();
    }

    @Override
    public void controlify$registerInitialScreen(Function<Runnable, Screen> screenFactory) {
        boolean doNow = this.initialScreensHappened;
        doNow = true;
        if (doNow) {
            Screen lastScreen = this.f_91080_;
            this.m_91152_(screenFactory.apply(() -> this.m_91152_(lastScreen)));
        } else {
            this.initialScreenCallbacks.add(screenFactory);
        }
    }
}

