/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.guide.screen;

import com.google.common.collect.ImmutableList;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.TabButton;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TabNavigationBar.class})
public class TabNavigationBarMixin {
    @Shadow
    @Final
    private ImmutableList<TabButton> f_267495_;

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void renderControllerButtonOverlay(GuiGraphics graphics, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (Controlify.instance().currentInputMode().isController()) {
            Controlify.instance().getCurrentController().ifPresent(c -> {
                if (c.genericConfig().config().showScreenGuides) {
                    this.renderControllerButtonOverlay(graphics, (ControllerEntity)c);
                }
            });
        }
    }

    @Unique
    private void renderControllerButtonOverlay(GuiGraphics graphics, ControllerEntity controller) {
        if (this.f_267495_.size() <= 1) {
            return;
        }
        TabButton firstTab = (TabButton)this.f_267495_.get(0);
        TabButton lastTab = (TabButton)this.f_267495_.get(this.f_267495_.size() - 1);
        Font font = Minecraft.m_91087_().f_91062_;
        Component prevTabText = ControlifyBindings.GUI_PREV_TAB.on(controller).inputIcon();
        int prevTabTextWidth = font.m_92852_((FormattedText)prevTabText);
        int n = firstTab.m_252754_() - 2 - prevTabTextWidth;
        int n2 = firstTab.m_252907_() / 2;
        Objects.requireNonNull(font);
        graphics.m_280430_(font, prevTabText, n, n2 + 9 / 2, 0xFFFFFF);
        Component nextTabText = ControlifyBindings.GUI_NEXT_TAB.on(controller).inputIcon();
        int n3 = lastTab.m_252754_() + lastTab.m_5711_() + 2;
        int n4 = lastTab.m_252907_() / 2;
        Objects.requireNonNull(font);
        graphics.m_280430_(font, nextTabText, n3, n4 + 9 / 2, 0xFFFFFF);
    }
}

