/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.mixins.feature.rumble.waterland;

import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.mixins.feature.rumble.waterland.PlayerMixin;
import dev.isxander.controlify.rumble.BasicRumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import java.util.Objects;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends PlayerMixin {
    protected LocalPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void splashRumble(CallbackInfo ci) {
        if (this.m_5833_()) {
            return;
        }
        ControlifyApi.get().getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> {
            Entity entity = (Entity)Objects.requireNonNullElse(this.m_6688_(), this);
            float f = entity == this ? 0.2f : 0.9f;
            Vec3 vec3 = entity.m_20184_();
            float impactForce = Math.min(1.0f, (float)Math.sqrt(vec3.f_82479_ * vec3.f_82479_ * (double)0.2f + vec3.f_82480_ * vec3.f_82480_ + vec3.f_82481_ * vec3.f_82481_ * (double)0.2f) * f);
            if (impactForce >= 0.05f) {
                float multiplier = Math.min(1.0f, impactForce / 0.5f);
                rumble.rumbleManager().play(RumbleSource.PLAYER, BasicRumbleEffect.byTime(t -> new RumbleState(multiplier * (1.0f - t.floatValue()), multiplier * 0.5f), impactForce < 0.25f ? 10 : 20));
            }
        });
    }
}

