/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.haptic.HapticEffects;
import dev.isxander.controlify.gui.guide.ContainerGuideCtx;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.guide.GuideActionRenderer;
import dev.isxander.controlify.gui.layout.AnchorPoint;
import dev.isxander.controlify.gui.layout.ColumnLayoutComponent;
import dev.isxander.controlify.gui.layout.PositionedComponent;
import dev.isxander.controlify.gui.layout.RowLayoutComponent;
import dev.isxander.controlify.mixins.feature.guide.screen.AbstractContainerScreenAccessor;
import dev.isxander.controlify.mixins.feature.screenop.ScreenAccessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public class AbstractContainerScreenProcessor<T extends AbstractContainerScreen<?>>
extends ScreenProcessor<T> {
    private PositionedComponent<ColumnLayoutComponent<RowLayoutComponent<GuideActionRenderer<ContainerGuideCtx>>>> leftLayout;
    private PositionedComponent<ColumnLayoutComponent<RowLayoutComponent<GuideActionRenderer<ContainerGuideCtx>>>> rightLayout;
    private final Supplier<Slot> hoveredSlot;
    private final ClickSlotFunction clickSlotFunction;
    private final Predicate<ControllerEntity> doItemSlotActions;

    public AbstractContainerScreenProcessor(T screen, Supplier<Slot> hoveredSlot, ClickSlotFunction clickSlotFunction, Predicate<ControllerEntity> doItemSlotActions) {
        super(screen);
        this.hoveredSlot = hoveredSlot;
        this.clickSlotFunction = clickSlotFunction;
        this.doItemSlotActions = doItemSlotActions;
    }

    @Override
    protected void handleScreenVMouse(ControllerEntity controller, VirtualMouseHandler vmouse) {
        AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)this.screen;
        ContainerGuideCtx ctx = new ContainerGuideCtx(this.hoveredSlot.get(), ((AbstractContainerScreen)this.screen).m_6262_().m_142621_(), accessor.invokeHasClickedOutside(vmouse.getCurrentX(1.0f), vmouse.getCurrentY(1.0f), accessor.getLeftPos(), accessor.getTopPos(), 0));
        Slot hoveredSlot = this.hoveredSlot.get();
        if (hoveredSlot != null) {
            if (hoveredSlot.m_6657_() && this.doItemSlotActions.test(controller)) {
                return;
            }
            if (ControlifyBindings.INV_SELECT.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.f_40219_, 0, ClickType.PICKUP);
                this.hapticNavigate();
            }
            if (ControlifyBindings.INV_QUICK_MOVE.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.f_40219_, 0, ClickType.QUICK_MOVE);
                this.hapticNavigate();
            }
            if (ControlifyBindings.INV_TAKE_HALF.on(controller).justPressed()) {
                this.clickSlotFunction.clickSlot(hoveredSlot, hoveredSlot.f_40219_, 1, ClickType.PICKUP);
                this.hapticNavigate();
            }
        } else {
            vmouse.handleCompatibilityBinds(controller);
        }
        if (!((AbstractContainerScreen)this.screen).m_6262_().m_142621_().m_41619_() && ControlifyBindings.DROP_INVENTORY.on(controller).justPressed()) {
            this.clickSlotFunction.clickSlot(null, -999, 0, ClickType.PICKUP);
            this.hapticNavigate();
        }
        if (this.leftLayout != null && this.rightLayout != null) {
            for (RowLayoutComponent row : this.leftLayout.getComponent().getChildComponents()) {
                for (GuideActionRenderer element : row.getChildComponents()) {
                    element.updateName(ctx);
                }
            }
            for (RowLayoutComponent row : this.rightLayout.getComponent().getChildComponents()) {
                for (GuideActionRenderer element : row.getChildComponents()) {
                    element.updateName(ctx);
                }
            }
            this.leftLayout.updatePosition(((AbstractContainerScreen)this.screen).f_96543_, ((AbstractContainerScreen)this.screen).f_96544_);
            this.rightLayout.updatePosition(((AbstractContainerScreen)this.screen).f_96543_, ((AbstractContainerScreen)this.screen).f_96544_);
        }
    }

    @Override
    public void onWidgetRebuild() {
        ControllerEntity controller = ControlifyApi.get().getCurrentController().filter(c -> c.input().isPresent()).orElse(null);
        if (controller == null) {
            return;
        }
        this.leftLayout = new PositionedComponent<ColumnLayoutComponent<RowLayoutComponent<GuideActionRenderer<ContainerGuideCtx>>>>(ColumnLayoutComponent.builder().spacing(2).elementPosition(ColumnLayoutComponent.ElementPosition.LEFT).colPadding(2).element(RowLayoutComponent.builder().spacing(5).rowPadding(0).elementPosition(RowLayoutComponent.ElementPosition.MIDDLE).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.INV_SELECT.on(controller), ctx -> {
            if (!ctx.holdingItem().m_41619_()) {
                if (ctx.hoveredSlot() != null && ctx.hoveredSlot().m_6657_()) {
                    if (ctx.hoveredSlot().m_5857_(ctx.holdingItem())) {
                        if (ctx.holdingItem().m_41613_() > 1) {
                            return Optional.of(Component.m_237115_((String)"controlify.guide.container.place_all"));
                        }
                        return Optional.of(Component.m_237115_((String)"controlify.guide.container.place_one"));
                    }
                    return Optional.of(Component.m_237115_((String)"controlify.guide.container.swap"));
                }
                if (ctx.cursorOutsideContainer()) {
                    return Optional.of(Component.m_237115_((String)"controlify.guide.container.drop"));
                }
            }
            if (ctx.hoveredSlot() != null && ctx.hoveredSlot().m_6657_()) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.container.take"));
            }
            return Optional.empty();
        }), false, false)).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.GUI_BACK.on(controller), ctx -> Optional.of(Component.m_237115_((String)"controlify.guide.container.exit"))), false, false)).build()).build(), AnchorPoint.BOTTOM_LEFT, 0, 0, AnchorPoint.BOTTOM_LEFT);
        this.rightLayout = new PositionedComponent<ColumnLayoutComponent<RowLayoutComponent<GuideActionRenderer<ContainerGuideCtx>>>>(ColumnLayoutComponent.builder().spacing(2).elementPosition(ColumnLayoutComponent.ElementPosition.RIGHT).colPadding(2).element(RowLayoutComponent.builder().spacing(5).rowPadding(0).elementPosition(RowLayoutComponent.ElementPosition.MIDDLE).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.DROP_INVENTORY.on(controller), ctx -> {
            if (!ctx.holdingItem().m_41619_()) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.container.drop"));
            }
            return Optional.empty();
        }), true, false)).build()).element(RowLayoutComponent.builder().spacing(5).rowPadding(0).elementPosition(RowLayoutComponent.ElementPosition.MIDDLE).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.INV_QUICK_MOVE.on(controller), ctx -> {
            if (ctx.hoveredSlot() != null && ctx.hoveredSlot().m_6657_() && ctx.holdingItem().m_41619_()) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.container.quick_move"));
            }
            return Optional.empty();
        }), true, false)).element(new GuideActionRenderer<ContainerGuideCtx>(new GuideAction<ContainerGuideCtx>(ControlifyBindings.INV_TAKE_HALF.on(controller), ctx -> {
            if (ctx.hoveredSlot() != null && ctx.hoveredSlot().m_7993_().m_41613_() > 1 && ctx.holdingItem().m_41619_()) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.container.take_half"));
            }
            if (ctx.hoveredSlot() != null && !ctx.holdingItem().m_41619_() && ctx.hoveredSlot().m_5857_(ctx.holdingItem())) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.container.take_one"));
            }
            return Optional.empty();
        }), true, false)).build()).build(), AnchorPoint.BOTTOM_RIGHT, 0, 0, AnchorPoint.BOTTOM_RIGHT);
        if (ControlifyApi.get().currentInputMode().isController()) {
            this.setRenderGuide(true);
        }
    }

    @Override
    public void onInputModeChanged(InputMode mode) {
        this.setRenderGuide(mode.isController());
    }

    private void setRenderGuide(boolean render) {
        render &= ControlifyApi.get().getCurrentController().map(c -> c.genericConfig().config().showScreenGuides).orElse(false).booleanValue();
        List<Renderable> renderables = ((ScreenAccessor)this.screen).getRenderables();
        if (this.leftLayout == null || this.rightLayout == null) {
            return;
        }
        if (render) {
            if (!renderables.contains(this.leftLayout)) {
                renderables.add(this.leftLayout);
            }
            if (!renderables.contains(this.rightLayout)) {
                renderables.add(this.rightLayout);
            }
        } else {
            renderables.remove(this.leftLayout);
            renderables.remove(this.rightLayout);
        }
    }

    public void onHoveredSlotChanged(Slot newSlot, Slot oldSlot) {
        if (ControlifyApi.get().currentInputMode().isController()) {
            this.hapticNavigate();
        }
    }

    private void hapticNavigate() {
        ControlifyApi.get().getCurrentController().flatMap(ControllerEntity::hdHaptics).ifPresent(hh -> hh.playHaptic(HapticEffects.NAVIGATE));
    }

    @Override
    public VirtualMouseBehaviour virtualMouseBehaviour() {
        return VirtualMouseBehaviour.CURSOR_ONLY;
    }

    @FunctionalInterface
    public static interface ClickSlotFunction {
        public void clickSlot(Slot var1, int var2, int var3, ClickType var4);
    }
}

