package dev.isxander.controlify.mixins.core;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.InputMode;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFWCharModsCallbackI;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(KeyboardHandler.class)
public class KeyboardHandlerMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @WrapOperation(
            method = "setup",
            at = @At(
                    value = "INVOKE",
                    target = "Lcom/mojang/blaze3d/platform/InputConstants;setupKeyboardCallbacks(JLorg/lwjgl/glfw/GLFWKeyCallbackI;Lorg/lwjgl/glfw/GLFWCharModsCallbackI;)V"
            )
    )
    private void wrapKeyboardEvents(
            long window,
            GLFWKeyCallbackI keyCallback,
            GLFWCharModsCallbackI charCallback,
            Operation<Void> original
    ) {
        original.call(
                window,
                (GLFWKeyCallbackI) (w, k, s, a, m) -> {
                    controlify$onKeyboardInput();
                    keyCallback.invoke(w, k, s, a, m);
                },
                (GLFWCharModsCallbackI) (w, c, m) -> {
                    controlify$onKeyboardInput();
                    charCallback.invoke(w, c, m);
                }
        );
    }

    @Unique
    private void controlify$onKeyboardInput() {
        minecraft.execute(() -> {
            if (Controlify.instance().currentInputMode() != InputMode.MIXED) {
                Controlify.instance().setInputMode(InputMode.KEYBOARD_MOUSE);
            }
        });
    }
}
