/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBindingBuilder;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.InputBindingImpl;
import dev.isxander.controlify.bindings.defaults.DefaultBindProvider;
import dev.isxander.controlify.bindings.input.EmptyInput;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.utils.CUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputBindingBuilderImpl
implements InputBindingBuilder {
    @Nullable
    private ResourceLocation id;
    @Nullable
    private Component category;
    @Nullable
    private Component customName;
    @Nullable
    private Component customDescription;
    @Nullable
    private Input defaultInput;
    private final Set<BindContext> allowedContexts = new HashSet<BindContext>();
    @Nullable
    private ResourceLocation radialCandidate;
    private final Set<KeyMapping> keyCorrelations = new HashSet<KeyMapping>();
    private KeyMapping keyEmulation = null;
    private Function<ControllerEntity, Boolean> keyEmulationToggle = null;
    private boolean locked;

    @Override
    public InputBindingBuilder id(@NotNull ResourceLocation rl) {
        this.checkLocked();
        this.id = rl;
        return this;
    }

    @Override
    public InputBindingBuilder id(@NotNull String namespace, @NotNull String path) {
        return this.id(CUtil.rl(namespace, path));
    }

    @Override
    public InputBindingBuilder category(@NotNull Component text) {
        this.checkLocked();
        this.category = text;
        return this;
    }

    @Override
    public InputBindingBuilder name(@NotNull Component text) {
        this.checkLocked();
        this.customName = text;
        return this;
    }

    @Override
    public InputBindingBuilder description(@NotNull Component text) {
        this.checkLocked();
        this.customDescription = text;
        return this;
    }

    @Override
    public InputBindingBuilder defaultInput(@Nullable Input input) {
        this.checkLocked();
        this.defaultInput = input;
        return this;
    }

    @Override
    public InputBindingBuilder allowedContexts(BindContext ... contexts) {
        this.checkLocked();
        if (contexts != null) {
            this.allowedContexts.addAll(List.of(contexts));
        }
        return this;
    }

    @Override
    public InputBindingBuilder radialCandidate(@Nullable ResourceLocation icon) {
        this.checkLocked();
        this.radialCandidate = icon;
        return this;
    }

    @Override
    public InputBindingBuilder addKeyCorrelation(@NotNull KeyMapping keyMapping) {
        this.checkLocked();
        this.keyCorrelations.add(keyMapping);
        return this;
    }

    @Override
    public InputBindingBuilder keyEmulation(@NotNull KeyMapping keyMapping, @Nullable Function<ControllerEntity, Boolean> toggleCondition) {
        this.checkLocked();
        this.keyEmulation = keyMapping;
        this.keyEmulationToggle = toggleCondition;
        this.addKeyCorrelation(keyMapping);
        return this;
    }

    @Override
    public InputBindingBuilder keyEmulation(@NotNull KeyMapping keyMapping) {
        return this.keyEmulation(keyMapping, null);
    }

    public InputBindingImpl build(ControllerEntity controller) {
        Validate.isTrue((boolean)this.locked, (String)"Tried to build builder before it was locked.", (Object[])new Object[0]);
        Component name = this.createDefaultString(controller, null, false);
        if (this.customName != null) {
            name = this.customName;
        }
        Component description = this.createDefaultString(controller, "desc", true);
        if (this.customDescription != null) {
            description = this.customDescription;
        }
        if (description == null) {
            description = Component.m_237119_();
        }
        Supplier<Input> defaultSupplier = () -> {
            DefaultBindProvider provider = Controlify.instance().defaultBindManager().getDefaultBindProvider(controller.info().type().namespace());
            Input input = provider.getDefaultBind(this.id);
            if (input == null) {
                input = this.defaultInput;
            }
            if (input == null) {
                input = EmptyInput.INSTANCE;
            }
            return input;
        };
        return new InputBindingImpl(controller, this.id, name, description, this.category, defaultSupplier, this.allowedContexts, this.radialCandidate);
    }

    @NotNull
    public ResourceLocation getIdAndLock() {
        this.checkLocked();
        this.locked = true;
        Validate.notNull((Object)this.id, (String)"Must call `.id(ResourceLocation)` on builder!", (Object[])new Object[0]);
        Validate.notNull((Object)this.category, (String)"Must call `.category(Component)` on builder %s!".formatted(this.id), (Object[])new Object[0]);
        return this.id;
    }

    public Set<KeyMapping> getKeyCorrelations() {
        return this.keyCorrelations;
    }

    @Nullable
    public KeyMapping getKeyEmulation() {
        return this.keyEmulation;
    }

    @Nullable
    public Function<ControllerEntity, Boolean> getKeyEmulationToggle() {
        return this.keyEmulationToggle;
    }

    private void checkLocked() {
        Validate.isTrue((!this.locked ? 1 : 0) != 0, (String)"Tried to modify binding builder after is has been locked!", (Object[])new Object[0]);
    }

    private Component createDefaultString(ControllerEntity controller, @Nullable String suffix, boolean notExistToNull) {
        Objects.requireNonNull(this.id);
        ResourceLocation type = controller.info().type().namespace();
        Object typeSpecificKey = type.m_269108_("controlify.binding", this.id.m_214298_());
        if (suffix != null) {
            typeSpecificKey = (String)typeSpecificKey + "." + suffix;
        }
        if (Language.m_128107_().m_6722_((String)typeSpecificKey)) {
            return Component.m_237115_((String)typeSpecificKey);
        }
        Object genericKey = this.id.m_214296_("controlify.binding");
        if (suffix != null) {
            genericKey = (String)genericKey + "." + suffix;
        }
        if (notExistToNull && !Language.m_128107_().m_6722_((String)genericKey)) {
            return null;
        }
        return Component.m_237115_((String)genericKey);
    }
}

