/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.render.Blit;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class RadialIcons {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    public static final ResourceLocation EMPTY = CUtil.rl("empty");
    public static final ResourceLocation FABRIC_ICON = CUtil.rl("fabric-resource-loader-v0", "icon.png");
    private static Map<ResourceLocation, RadialIcon> icons = null;
    private static Queue<Runnable> deferredRegistrations = new ArrayDeque<Runnable>();

    public static Map<ResourceLocation, RadialIcon> getIcons() {
        if (icons == null) {
            icons = RadialIcons.registerIcons();
            deferredRegistrations.forEach(Runnable::run);
            deferredRegistrations = null;
        }
        return icons;
    }

    public static void registerIcon(ResourceLocation location, RadialIcon icon) {
        if (icons == null) {
            deferredRegistrations.add(() -> RadialIcons.registerIcon(location, icon));
            return;
        }
        icons.put(location, icon);
    }

    public static ResourceLocation getItem(Item item) {
        return RadialIcons.prefixLocation("item", BuiltInRegistries.f_257033_.m_7981_((Object)item));
    }

    public static ResourceLocation getEffect(MobEffect effect) {
        return RadialIcons.prefixLocation("effect", BuiltInRegistries.f_256974_.m_7981_((Object)effect));
    }

    private static void addItems(Map<ResourceLocation, RadialIcon> map) {
        BuiltInRegistries.f_257033_.m_6579_().forEach(entry -> {
            ResourceKey key = (ResourceKey)entry.getKey();
            ItemStack stack = ((Item)entry.getValue()).m_7968_();
            map.put(RadialIcons.prefixLocation("item", key.m_135782_()), (graphics, x, y, tickDelta) -> graphics.m_280480_(stack, x, y));
        });
    }

    private static void addPotionEffects(Map<ResourceLocation, RadialIcon> map) {
        MobEffectTextureManager mobEffectTextureManager = minecraft.m_91306_();
        BuiltInRegistries.f_256974_.m_6579_().forEach(entry -> {
            ResourceKey key = (ResourceKey)entry.getKey();
            MobEffect effect = (MobEffect)entry.getValue();
            TextureAtlasSprite sprite = mobEffectTextureManager.m_118732_(effect);
            if (sprite != null) {
                map.put(RadialIcons.prefixLocation("effect", key.m_135782_()), (graphics, x, y, tickDelta) -> {
                    if (sprite.m_247685_() != null) {
                        graphics.m_280168_().m_85836_();
                        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
                        graphics.m_280168_().m_85841_(0.88f, 0.88f, 1.0f);
                        Blit.blitSprite(graphics, sprite, 0, 0, 18, 18, -1);
                        graphics.m_280168_().m_85849_();
                    }
                });
            }
        });
    }

    private static ResourceLocation prefixLocation(String prefix, ResourceLocation location) {
        return CUtil.rl(location.m_135827_(), prefix + "/" + location.m_135815_());
    }

    private static Map<ResourceLocation, RadialIcon> registerIcons() {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        map.put(EMPTY, (graphics, x, y, tickDelta) -> {});
        map.put(FABRIC_ICON, (graphics, x, y, tickDelta) -> {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
            graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
            Blit.blitTex(graphics, FABRIC_ICON, 0, 0, 0, 0, 32, 32, 32, 32);
            graphics.m_280168_().m_85849_();
        });
        RadialIcons.addItems((Map<ResourceLocation, RadialIcon>)map);
        RadialIcons.addPotionEffects((Map<ResourceLocation, RadialIcon>)map);
        return map;
    }
}

