/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.compatibility.simplevoicechat;

import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.InputBindingBuilder;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.compatibility.simplevoicechat.mixins.KeyEventsAccessor;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.render.Blit;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class SimpleVoiceChatCompat {
    private static InputBindingSupplier pttHoldSupplier;
    private static InputBindingSupplier pttToggleSupplier;
    private static InputBindingSupplier whisperHoldSupplier;
    private static InputBindingSupplier whisperToggleSupplier;
    private static boolean pttDown;
    private static boolean whisperDown;

    public static void init() {
        ResourceLocation muteIcon = SimpleVoiceChatCompat.registerIcon16x(CUtil.rl("voicechat", "textures/icons/microphone_off.png"));
        ResourceLocation pttIcon = SimpleVoiceChatCompat.registerIcon16x(CUtil.rl("voicechat", "textures/icons/microphone.png"));
        ResourceLocation whisperIcon = SimpleVoiceChatCompat.registerIcon16x(CUtil.rl("voicechat", "textures/icons/microphone_whisper.png"));
        MutableComponent category = Component.m_237115_((String)"key.categories.voicechat");
        pttHoldSupplier = ControlifyBindApi.get().registerBinding(arg_0 -> SimpleVoiceChatCompat.lambda$init$0((Component)category, arg_0));
        pttToggleSupplier = ControlifyBindApi.get().registerBinding(arg_0 -> SimpleVoiceChatCompat.lambda$init$1((Component)category, pttIcon, arg_0));
        whisperHoldSupplier = ControlifyBindApi.get().registerBinding(arg_0 -> SimpleVoiceChatCompat.lambda$init$2((Component)category, arg_0));
        whisperToggleSupplier = ControlifyBindApi.get().registerBinding(arg_0 -> SimpleVoiceChatCompat.lambda$init$3((Component)category, whisperIcon, arg_0));
        ControlifyBindApi.get().registerBinding(arg_0 -> SimpleVoiceChatCompat.lambda$init$4((Component)category, muteIcon, arg_0));
        ControlifyEvents.ACTIVE_CONTROLLER_TICKED.register(event -> {
            ControllerEntity controller = event.controller();
            InputBinding pttHold = pttHoldSupplier.on(controller);
            InputBinding pttToggle = pttToggleSupplier.on(controller);
            InputBinding whisperHold = whisperHoldSupplier.on(controller);
            InputBinding whisperToggle = whisperToggleSupplier.on(controller);
            if (pttToggle.justPressed()) {
                pttDown = !pttDown;
                SimpleVoiceChatCompat.checkConnected();
            }
            if (whisperToggle.justPressed()) {
                whisperDown = !whisperDown;
                SimpleVoiceChatCompat.checkConnected();
            }
            if (pttHold.justPressed() || whisperHold.justPressed()) {
                SimpleVoiceChatCompat.checkConnected();
            }
            if (pttHold.digitalNow()) {
                pttDown = true;
            } else if (pttHold.justReleased()) {
                pttDown = false;
            }
            if (whisperHold.digitalNow()) {
                whisperDown = true;
            } else if (whisperHold.justReleased()) {
                whisperDown = false;
            }
            controller.dualSense().ifPresent(ds -> ds.setMuteLight(ClientManager.getPlayerStateManager().isMuted()));
        });
    }

    public static boolean isPTTDown() {
        return pttDown;
    }

    public static boolean isWhisperDown() {
        return whisperDown;
    }

    private static void checkConnected() {
        if (Minecraft.m_91087_().m_91265_() == null && Minecraft.m_91087_().f_91080_ == null) {
            ((KeyEventsAccessor)ClientManager.instance().getKeyEvents()).invokeCheckConnected();
        }
    }

    private static ResourceLocation registerIcon16x(ResourceLocation location) {
        ControlifyBindApi.get().registerRadialIcon(location, (graphics, x, y, tickDelta) -> Blit.blitTex(graphics, location, x, y, 0.0f, 0.0f, 16, 16, 16, 16));
        return location;
    }

    private static /* synthetic */ InputBindingBuilder lambda$init$4(Component category, ResourceLocation muteIcon, InputBindingBuilder builder) {
        return builder.id("voicechat", "mute_microphone").category(category).radialCandidate(muteIcon).keyEmulation(KeyEvents.KEY_MUTE);
    }

    private static /* synthetic */ InputBindingBuilder lambda$init$3(Component category, ResourceLocation whisperIcon, InputBindingBuilder builder) {
        return builder.name((Component)Component.m_237115_((String)"key.whisper").m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)"controlify.compat.svc.toggle"))).id("voicechat", "whisper_toggle").category(category).radialCandidate(whisperIcon).addKeyCorrelation(KeyEvents.KEY_WHISPER);
    }

    private static /* synthetic */ InputBindingBuilder lambda$init$2(Component category, InputBindingBuilder builder) {
        return builder.name((Component)Component.m_237115_((String)"key.whisper").m_7220_(CommonComponents.f_263701_).m_7220_((Component)Component.m_237115_((String)"controlify.compat.svc.hold"))).id("voicechat", "whisper_hold").category(category).addKeyCorrelation(KeyEvents.KEY_WHISPER);
    }

    private static /* synthetic */ InputBindingBuilder lambda$init$1(Component category, ResourceLocation pttIcon, InputBindingBuilder builder) {
        return builder.id("voicechat", "ptt_toggle").category(category).radialCandidate(pttIcon).addKeyCorrelation(KeyEvents.KEY_PTT);
    }

    private static /* synthetic */ InputBindingBuilder lambda$init$0(Component category, InputBindingBuilder builder) {
        return builder.id("voicechat", "ptt_hold").category(category).addKeyCorrelation(KeyEvents.KEY_PTT);
    }
}

