/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.impl;

import com.google.common.base.Joiner;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.ModifiableControllerState;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ControllerStateImpl
implements ModifiableControllerState {
    private final Map<ResourceLocation, Boolean> buttons = new Object2BooleanArrayMap();
    private final Map<ResourceLocation, Float> axes = new Object2FloatArrayMap();
    private final Map<ResourceLocation, Float> restingAxes = new Object2FloatArrayMap();
    private final Map<ResourceLocation, HatState> hats = new Object2ObjectArrayMap();

    @Override
    public boolean isButtonDown(ResourceLocation button) {
        return this.buttons.getOrDefault(button, false);
    }

    @Override
    public Set<ResourceLocation> getButtons() {
        return this.buttons.keySet();
    }

    @Override
    public float getAxisState(ResourceLocation axis) {
        return this.axes.getOrDefault(axis, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Set<ResourceLocation> getAxes() {
        return this.axes.keySet();
    }

    @Override
    public float getAxisResting(ResourceLocation axis) {
        return this.restingAxes.getOrDefault(axis, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public HatState getHatState(ResourceLocation hat) {
        return this.hats.getOrDefault(hat, HatState.CENTERED);
    }

    @Override
    public Set<ResourceLocation> getHats() {
        return this.hats.keySet();
    }

    @Override
    public void setButton(ResourceLocation button, boolean value) {
        this.buttons.put(button, value);
    }

    @Override
    public void setAxis(ResourceLocation axis, float value) {
        this.axes.put(axis, Float.valueOf(value));
    }

    public void setRestingAxis(ResourceLocation axis, float value) {
        if (!this.axes.containsKey(axis)) {
            throw new IllegalArgumentException("Cannot set resting axis for axis that doesn't exist");
        }
        this.restingAxes.put(axis, Float.valueOf(value));
    }

    @Override
    public void setHat(ResourceLocation hat, HatState value) {
        this.hats.put(hat, value);
    }

    @Override
    public void clearState() {
        this.buttons.clear();
        this.axes.clear();
        this.restingAxes.clear();
        this.hats.clear();
    }

    public String toDebugString() {
        Joiner.MapJoiner joiner = Joiner.on((String)",").withKeyValueSeparator("=");
        return "ControllerState{axes:%s,buttons:%s,hats:%s}".formatted(joiner.join(this.axes), joiner.join(this.buttons), joiner.join(this.hats));
    }
}

