/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.controllers;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.input.AxisInput;
import dev.isxander.controlify.bindings.input.ButtonInput;
import dev.isxander.controlify.bindings.input.EmptyInput;
import dev.isxander.controlify.bindings.input.HatInput;
import dev.isxander.controlify.bindings.input.Input;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.gui.screen.BindConsumerScreen;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.ControllerWidget;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class BindController
implements Controller<Input> {
    private final Option<Input> option;
    public final ControllerEntity controller;
    private boolean conflicting;

    public BindController(Option<Input> option, ControllerEntity controller) {
        this.option = option;
        this.controller = controller;
    }

    public Option<Input> option() {
        return this.option;
    }

    public Component formatValue() {
        return Component.m_237119_();
    }

    public void setConflicting(boolean conflicting) {
        this.conflicting = conflicting;
    }

    public boolean getConflicting() {
        return this.conflicting;
    }

    public BindControllerElement provideWidget(YACLScreen yaclScreen, Dimension<Integer> dimension) {
        return new BindControllerElement(this, yaclScreen, dimension);
    }

    public static class BindControllerElement
    extends ControllerWidget<BindController>
    implements ComponentProcessor {
        public boolean awaitingControllerInput = false;
        private final Component awaitingText = Component.m_237115_((String)"controlify.gui.bind_input_awaiting").m_130940_(ChatFormatting.ITALIC);

        public BindControllerElement(BindController control, YACLScreen screen, Dimension<Integer> dim) {
            super((Controller)control, screen, dim);
        }

        protected void drawValueText(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.awaitingControllerInput) {
                int n = (Integer)this.getDimension().xLimit() - this.textRenderer.m_92852_((FormattedText)this.awaitingText) - this.getXPadding();
                float f = ((Integer)this.getDimension().centerY()).intValue();
                Objects.requireNonNull(this.textRenderer);
                graphics.m_280614_(this.textRenderer, this.awaitingText, n, (int)(f - 9.0f / 2.0f), 0xFFFFFF, true);
            } else {
                Input bind = (Input)((BindController)this.control).option().pendingValue();
                if (EmptyInput.equals(bind)) {
                    return;
                }
                Component text = Controlify.instance().inputFontMapper().getComponentFromBind(((BindController)this.control).controller.info().type().namespace(), bind);
                int width = this.textRenderer.m_92852_((FormattedText)text);
                int n = (Integer)this.getDimension().xLimit() - width - 1;
                float f = ((Integer)this.getDimension().centerY()).intValue();
                Objects.requireNonNull(this.textRenderer);
                graphics.m_280614_(this.textRenderer, text, n, (int)(f - 9.0f / 2.0f + 1.0f), -1, false);
            }
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.m_93696_() && keyCode == 257) {
                this.openConsumerScreen();
                return true;
            }
            return false;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.getDimension().isPointInside((Number)((int)mouseX), (Number)((int)mouseY))) {
                this.openConsumerScreen();
                return true;
            }
            return false;
        }

        private void openConsumerScreen() {
            this.awaitingControllerInput = true;
            Minecraft.m_91087_().m_91152_((Screen)new BindConsumerScreen(this::getPressedBind, ((BindController)this.control).option(), this, Minecraft.m_91087_().f_91080_));
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
            if (controller != ((BindController)this.control).controller) {
                return true;
            }
            if (ControlifyBindings.GUI_PRESS.on(controller).justPressed()) {
                this.openConsumerScreen();
                return true;
            }
            return false;
        }

        protected int getHoveredControlWidth() {
            return this.getUnhoveredControlWidth();
        }

        protected int getUnhoveredControlWidth() {
            if (this.awaitingControllerInput) {
                return this.textRenderer.m_92852_((FormattedText)this.awaitingText);
            }
            Component text = Controlify.instance().inputFontMapper().getComponentFromBind(((BindController)this.control).controller.info().type().namespace(), (Input)((BindController)this.control).option().pendingValue());
            return this.textRenderer.m_92852_((FormattedText)text);
        }

        protected int getValueColor() {
            return ((BindController)this.control).conflicting ? 0xFF5555 : super.getValueColor();
        }

        public Optional<Input> getPressedBind() {
            InputComponent input = ((BindController)this.control).controller.input().orElseThrow();
            ControllerStateView state = input.stateNow();
            ControllerStateView prevState = input.stateThen();
            for (ResourceLocation button : state.getButtons()) {
                if (!state.isButtonDown(button) || prevState.isButtonDown(button)) continue;
                return Optional.of(new ButtonInput(button));
            }
            for (ResourceLocation axis : state.getAxes()) {
                if (!(state.getAxisState(axis) > 0.5f) || !(prevState.getAxisState(axis) <= 0.5f)) continue;
                return Optional.of(new AxisInput(axis));
            }
            for (ResourceLocation hat : state.getHats()) {
                HatState hatState = state.getHatState(hat);
                if (hatState == HatState.CENTERED || prevState.getHatState(hat) != HatState.CENTERED) continue;
                return Optional.of(new HatInput(hat, hatState));
            }
            return Optional.empty();
        }
    }
}

