/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.controllers;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import dev.isxander.controlify.controller.input.DeadzoneGroup;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.render.ControlifyVertexConsumer;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class Deadzone2DImageRenderer
implements ImageRenderer {
    private final InputComponent input;
    private final DeadzoneGroup deadzoneGroup;
    private final Supplier<Option<Float>> deadzoneOption;

    public Deadzone2DImageRenderer(InputComponent input, DeadzoneGroup deadzoneGroup, Supplier<Option<Float>> deadzoneOption) {
        this.input = input;
        this.deadzoneGroup = deadzoneGroup;
        this.deadzoneOption = deadzoneOption;
    }

    public int render(GuiGraphics graphics, int x, int y, int renderWidth, float tickDelta) {
        float radius = (float)renderWidth / 4.0f;
        int renderHeight = (int)(radius * 2.0f);
        List<ResourceLocation> deadzones = this.deadzoneGroup.axes();
        float up = this.input.rawStateNow().getAxisState(deadzones.get(0));
        float down = this.input.rawStateNow().getAxisState(deadzones.get(1));
        float left = this.input.rawStateNow().getAxisState(deadzones.get(2));
        float right = this.input.rawStateNow().getAxisState(deadzones.get(3));
        float currentX = right - left;
        float currentY = down - up;
        graphics.m_280656_(x, (int)((float)x + radius * 2.0f), (int)((float)y + radius), -5592406);
        graphics.m_280315_((int)((float)x + radius), y, (int)((float)y + radius * 2.0f), -5592406);
        Deadzone2DImageRenderer.drawCircleOutline(graphics.m_280168_(), (float)x + radius, (float)y + radius, 0.0f, radius, 1.0f, -1, 360);
        float deadzone = ((Float)this.deadzoneOption.get().pendingValue()).floatValue();
        boolean aboveDeadzone = Math.abs(currentX) > deadzone || Math.abs(currentY) > deadzone;
        Deadzone2DImageRenderer.drawCircleOutline(graphics.m_280168_(), (float)x + radius, (float)y + radius, 0.0f, deadzone * radius, 1.0f, aboveDeadzone ? -16711681 : -65536, 360);
        Deadzone2DImageRenderer.drawCircle(graphics.m_280168_(), (float)x + radius + currentX * radius, (float)y + radius + currentY * radius, 0.0f, 1.0f, -16711936, 8);
        Font font = Minecraft.m_91087_().f_91062_;
        DecimalFormat format = new DecimalFormat("0.000");
        graphics.m_280488_(font, "X: " + format.format(currentX), (int)((float)x + radius * 2.0f + 5.0f), y, -1);
        String string = "Y: " + format.format(currentY);
        int n = (int)((float)x + radius * 2.0f + 5.0f);
        Objects.requireNonNull(font);
        graphics.m_280488_(font, string, n, y + 9 + 1, -1);
        return renderHeight;
    }

    public void close() {
    }

    private static void drawCircle(PoseStack poseStack, float originX, float originY, float z, float radius, int colour, int segments) {
        Deadzone2DImageRenderer.drawCircleOutline(poseStack, originX, originY, z, radius, radius, colour, segments);
    }

    private static void drawCircleOutline(PoseStack poseStack, float originX, float originY, float z, float radius, float thickness, int colour, int segments) {
        BufferBuilder buffer = CUtil.beginBuffer(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        ControlifyVertexConsumer vertexConsumer = ControlifyVertexConsumer.of((VertexConsumer)buffer);
        Matrix4f position = poseStack.m_85850_().m_252922_();
        float innerRadius = radius - thickness;
        for (int i = 0; i <= segments - 1; ++i) {
            float angle = (float)i / (float)segments * 360.0f;
            float nextAngle = (float)(i + 1) / (float)segments * 360.0f;
            float rad = angle * ((float)Math.PI / 180);
            float nextRad = nextAngle * ((float)Math.PI / 180);
            float xi1 = originX + Mth.m_14031_((float)rad) * innerRadius;
            float yi1 = originY + Mth.m_14089_((float)rad) * innerRadius;
            float xi2 = originX + Mth.m_14031_((float)nextRad) * innerRadius;
            float yi2 = originY + Mth.m_14089_((float)nextRad) * innerRadius;
            float xo1 = originX + Mth.m_14031_((float)rad) * radius;
            float yo1 = originY + Mth.m_14089_((float)rad) * radius;
            float xo2 = originX + Mth.m_14031_((float)nextRad) * radius;
            float yo2 = originY + Mth.m_14089_((float)nextRad) * radius;
            vertexConsumer.vertex(position, xi1, yi1, z).color(colour).endVertex();
            vertexConsumer.vertex(position, xo1, yo1, z).color(colour).endVertex();
            vertexConsumer.vertex(position, xo2, yo2, z).color(colour).endVertex();
            vertexConsumer.vertex(position, xi2, yi2, z).color(colour).endVertex();
        }
        RenderType renderType = RenderType.m_285907_();
        renderType.m_276775_(buffer, VertexSorting.f_276633_);
    }
}

