/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.guide;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.api.guide.ActionPriority;
import dev.isxander.controlify.api.guide.GuideActionNameSupplier;
import dev.isxander.controlify.api.ingameguide.ActionLocation;
import dev.isxander.controlify.api.ingameguide.IngameGuideContext;
import dev.isxander.controlify.api.ingameguide.IngameGuideRegistry;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.guide.GuideActionRenderer;
import dev.isxander.controlify.gui.layout.AnchorPoint;
import dev.isxander.controlify.gui.layout.ColumnLayoutComponent;
import dev.isxander.controlify.gui.layout.PositionedComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class InGameButtonGuide
implements IngameGuideRegistry {
    private final ControllerEntity controller;
    private final LocalPlayer player;
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final List<GuideAction<IngameGuideContext>> leftGuides = new ArrayList<GuideAction<IngameGuideContext>>();
    private final List<GuideAction<IngameGuideContext>> rightGuides = new ArrayList<GuideAction<IngameGuideContext>>();
    private PositionedComponent<ColumnLayoutComponent<GuideActionRenderer<IngameGuideContext>>> leftLayout;
    private PositionedComponent<ColumnLayoutComponent<GuideActionRenderer<IngameGuideContext>>> rightLayout;

    public InGameButtonGuide(ControllerEntity controller, LocalPlayer localPlayer) {
        this.controller = controller;
        this.player = localPlayer;
        this.registerDefaultActions();
        ControlifyEvents.INGAME_GUIDE_REGISTRY.invoke(new ControlifyEvents.IngameGuideRegistryEvent(controller, this));
        Collections.sort(this.leftGuides);
        Collections.sort(this.rightGuides);
        this.refreshLayout();
    }

    public void refreshLayout() {
        boolean bottom = this.controller.genericConfig().config().ingameGuideBottom;
        this.leftLayout = new PositionedComponent<ColumnLayoutComponent<GuideActionRenderer>>(ColumnLayoutComponent.builder().spacing(1).colPadding(2, 2).elementPosition(ColumnLayoutComponent.ElementPosition.LEFT).elements((Collection<GuideActionRenderer>)this.leftGuides.stream().map(guide -> new GuideActionRenderer(guide, false, true)).toList()).build(), !bottom ? AnchorPoint.TOP_LEFT : AnchorPoint.BOTTOM_LEFT, 0, 0, !bottom ? AnchorPoint.TOP_LEFT : AnchorPoint.BOTTOM_LEFT);
        this.rightLayout = new PositionedComponent<ColumnLayoutComponent<GuideActionRenderer>>(ColumnLayoutComponent.builder().spacing(1).colPadding(2, 2).elementPosition(ColumnLayoutComponent.ElementPosition.RIGHT).elements((Collection<GuideActionRenderer>)this.rightGuides.stream().map(guide -> new GuideActionRenderer(guide, true, true)).toList()).build(), !bottom ? AnchorPoint.TOP_RIGHT : AnchorPoint.BOTTOM_RIGHT, 0, 0, !bottom ? AnchorPoint.TOP_RIGHT : AnchorPoint.BOTTOM_RIGHT);
    }

    public void renderHud(GuiGraphics graphics, float tickDelta) {
        boolean debugOpen = this.minecraft.f_91066_.f_92063_;
        boolean hideGui = this.minecraft.f_91066_.f_92062_;
        if (!this.controller.genericConfig().config().showIngameGuide || this.minecraft.f_91080_ != null || debugOpen || hideGui) {
            return;
        }
        float scale = Controlify.instance().config().globalSettings().ingameButtonGuideScale;
        boolean customScale = scale != 1.0f;
        Matrix4f prevProjection = null;
        if (customScale) {
            graphics.m_280262_();
            prevProjection = RenderSystem.getProjectionMatrix();
            double guiScale = this.minecraft.m_91268_().m_85449_() * (double)scale;
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)((double)this.minecraft.m_91268_().m_85441_() / guiScale), (float)((double)this.minecraft.m_91268_().m_85442_() / guiScale), 0.0f, 1000.0f, 21000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (VertexSorting)VertexSorting.f_276633_);
        }
        this.leftLayout.renderComponent(graphics, tickDelta);
        this.rightLayout.renderComponent(graphics, tickDelta);
        if (customScale) {
            graphics.m_280262_();
            RenderSystem.setProjectionMatrix((Matrix4f)prevProjection, (VertexSorting)VertexSorting.f_276633_);
        }
    }

    public void tick() {
        IngameGuideContext context = new IngameGuideContext(Minecraft.m_91087_(), this.player, this.minecraft.f_91073_, this.calculateHitResult(), this.controller);
        this.leftLayout.getComponent().getChildComponents().forEach(renderer -> renderer.updateName(context));
        this.rightLayout.getComponent().getChildComponents().forEach(renderer -> renderer.updateName(context));
        double guiScale = this.minecraft.m_91268_().m_85449_() * (double)Controlify.instance().config().globalSettings().ingameButtonGuideScale;
        int width = (int)((double)this.minecraft.m_91268_().m_85441_() / guiScale);
        int height = (int)((double)this.minecraft.m_91268_().m_85442_() / guiScale);
        this.leftLayout.updatePosition(width, height);
        this.rightLayout.updatePosition(width, height);
    }

    @Override
    public void registerGuideAction(InputBinding binding, ActionLocation location, GuideActionNameSupplier<IngameGuideContext> supplier) {
        this.registerGuideAction(binding, location, ActionPriority.NORMAL, supplier);
    }

    @Override
    public void registerGuideAction(InputBinding binding, ActionLocation location, ActionPriority priority, GuideActionNameSupplier<IngameGuideContext> supplier) {
        if (location == ActionLocation.LEFT) {
            this.leftGuides.add(new GuideAction<IngameGuideContext>(binding, supplier, priority));
        } else {
            this.rightGuides.add(new GuideAction<IngameGuideContext>(binding, supplier, priority));
        }
    }

    private void registerDefaultActions() {
        Options options = Minecraft.m_91087_().f_91066_;
        this.registerGuideAction(ControlifyBindings.JUMP.on(this.controller), ActionLocation.LEFT, ctx -> {
            LocalPlayer player = ctx.player();
            if (player.m_150110_().f_35935_) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.fly_up"));
            }
            if (player.m_20096_()) {
                return Optional.of(Component.m_237115_((String)"key.jump"));
            }
            if (player.m_20069_()) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.swim_up"));
            }
            boolean canGlide = !player.m_20159_() && !player.m_21023_(MobEffects.f_19620_);
            ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
            if (!player.m_20096_() && !player.m_21255_() && !player.m_20069_() && (canGlide &= chestStack.m_150930_(Items.f_42741_) && ElytraItem.m_41140_((ItemStack)chestStack))) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.start_elytra"));
            }
            return Optional.empty();
        });
        boolean shifting = this.player.f_108618_.f_108573_;
        this.registerGuideAction(ControlifyBindings.SNEAK.on(this.controller), ActionLocation.LEFT, ctx -> {
            LocalPlayer player = ctx.player();
            if (player.m_20202_() != null) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.dismount"));
            }
            if (player.m_150110_().f_35935_) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.fly_down"));
            }
            if (player.m_20069_() && !player.m_20096_()) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.swim_down"));
            }
            if (ctx.controller().genericConfig().config().toggleSneak) {
                return Optional.of(Component.m_237115_((String)(shifting ? "controlify.guide.ingame.stop_sneaking" : "controlify.guide.ingame.start_sneaking")));
            }
            if (!shifting) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.sneak"));
            }
            return Optional.empty();
        });
        boolean sprinting = options.f_92091_.m_90857_();
        this.registerGuideAction(ControlifyBindings.SPRINT.on(this.controller), ActionLocation.LEFT, ctx -> {
            LocalPlayer player = ctx.player();
            if (!sprinting) {
                if (!player.f_108618_.m_108575_().m_82476_(Vec2.f_82462_)) {
                    if (player.m_5842_()) {
                        return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.start_swimming"));
                    }
                    return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.start_sprinting"));
                }
            } else if (ctx.controller().genericConfig().config().toggleSprint) {
                if (player.m_5842_()) {
                    return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.stop_swimming"));
                }
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.stop_sprinting"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(ControlifyBindings.INVENTORY.on(this.controller), ActionLocation.RIGHT, ctx -> {
            if (ctx.client().f_91080_ == null) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.inventory"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(ControlifyBindings.RADIAL_MENU.on(this.controller), ActionLocation.RIGHT, ctx -> {
            if (ctx.client().f_91080_ == null) {
                return Optional.of(Component.m_237115_((String)"controlify.gui.radial_menu"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(ControlifyBindings.ATTACK.on(this.controller), ActionLocation.RIGHT, ctx -> {
            HitResult hitResult = ctx.hitResult();
            if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                if (this.player.m_5833_()) {
                    return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.spectate"));
                }
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.attack"));
            }
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.break"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(ControlifyBindings.USE.on(this.controller), ActionLocation.RIGHT, ctx -> {
            HitResult hitResult = ctx.hitResult();
            LocalPlayer player = ctx.player();
            if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                if (player.m_5833_()) {
                    return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.spectate"));
                }
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.interact"));
            }
            if (hitResult.m_6662_() == HitResult.Type.BLOCK || player.m_21033_(EquipmentSlot.MAINHAND) || player.m_21033_(EquipmentSlot.OFFHAND)) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.use"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(ControlifyBindings.DROP_INGAME.on(this.controller), ActionLocation.RIGHT, ctx -> {
            ItemStack holdingItem = ctx.player().m_150109_().m_36056_();
            if (!holdingItem.m_41619_()) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.drop"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(ControlifyBindings.DROP_STACK.on(this.controller), ActionLocation.RIGHT, ctx -> {
            ItemStack holdingItem = ctx.player().m_150109_().m_36056_();
            if (!holdingItem.m_41619_() && holdingItem.m_41613_() > 1) {
                return Optional.of(Component.m_237115_((String)"controlify.binding.controlify.drop_stack"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(ControlifyBindings.SWAP_HANDS.on(this.controller), ActionLocation.RIGHT, ctx -> {
            LocalPlayer player = ctx.player();
            if (player.m_21033_(EquipmentSlot.MAINHAND) || player.m_21033_(EquipmentSlot.OFFHAND)) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.swap_hands"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(ControlifyBindings.PICK_BLOCK.on(this.controller), ActionLocation.RIGHT, ctx -> {
            if (ctx.hitResult().m_6662_() == HitResult.Type.BLOCK && ctx.player().m_7500_()) {
                return Optional.of(Component.m_237115_((String)"controlify.guide.ingame.pick_block"));
            }
            return Optional.empty();
        });
        this.registerGuideAction(ControlifyBindings.PICK_BLOCK_NBT.on(this.controller), ActionLocation.RIGHT, ctx -> {
            if (ctx.hitResult().m_6662_() == HitResult.Type.BLOCK && ctx.player().m_7500_()) {
                return Optional.of(Component.m_237115_((String)"controlify.binding.controlify.pick_block_nbt"));
            }
            return Optional.empty();
        });
    }

    private HitResult calculateHitResult() {
        AABB box;
        double pickRange = this.minecraft.f_91072_.m_105286_();
        HitResult pickResult = this.player.m_19907_(pickRange, 1.0f, false);
        Vec3 eyePos = this.player.m_20299_(1.0f);
        if (this.minecraft.f_91072_.m_105291_()) {
            pickRange = 6.0;
        }
        double maxPickRange = pickResult.m_82450_().m_82557_(eyePos);
        Vec3 viewVec = this.player.m_20252_(1.0f);
        Vec3 reachVec = eyePos.m_82520_(viewVec.f_82479_ * pickRange, viewVec.f_82480_ * pickRange, viewVec.f_82481_ * pickRange);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)this.player, (Vec3)eyePos, (Vec3)reachVec, (AABB)(box = this.player.m_20191_().m_82369_(viewVec.m_82490_(pickRange)).m_82377_(1.0, 1.0, 1.0)), entity -> !entity.m_5833_() && entity.m_6087_(), (double)maxPickRange);
        if (entityHitResult != null && entityHitResult.m_82450_().m_82557_(eyePos) < pickResult.m_82450_().m_82557_(eyePos)) {
            return entityHitResult;
        }
        return pickResult;
    }
}

