/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.controller.steamdeck.SteamDeckComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.gui.components.FakePositionPlainTextButton;
import dev.isxander.controlify.gui.screen.ControllerConfigScreenFactory;
import dev.isxander.controlify.gui.screen.GlobalSettingsScreenFactory;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ClientUtils;
import dev.isxander.controlify.utils.ColorUtils;
import dev.isxander.controlify.utils.animation.api.Animatable;
import dev.isxander.controlify.utils.animation.api.Animation;
import dev.isxander.controlify.utils.animation.api.EasingFunction;
import dev.isxander.controlify.utils.render.Blit;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerCarouselScreen
extends Screen
implements ScreenControllerEventListener {
    public static final ResourceLocation CHECKMARK = CUtil.mcRl("textures/gui/checkmark.png");
    public static final ResourceLocation DANGER = CUtil.mcRl("textures/gui/unseen_notification.png");
    private final Screen parent;
    private int footerY;
    private List<CarouselEntry> carouselEntries = null;
    private int carouselIndex;
    private Animatable carouselAnimation = null;
    private final Controlify controlify;
    private final ControllerManager controllerManager;
    private Button globalSettingsButton;
    private Button unbindControllerButton;
    private Button doneButton;
    private Button controllerNotDetectedButton;

    private ControllerCarouselScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"controlify.gui.carousel.title"));
        this.parent = parent;
        this.controlify = Controlify.instance();
        this.controllerManager = this.controlify.getControllerManager().orElseThrow();
        this.carouselIndex = this.controlify.getCurrentController().map(c -> this.controllerManager.getConnectedControllers().indexOf(c)).orElse(0);
    }

    public static void openConfigScreen(Screen parent) {
        Controlify controlify = Controlify.instance();
        controlify.finishControlifyInit().whenComplete((v, th) -> Minecraft.m_91087_().m_91152_((Screen)new ControllerCarouselScreen(parent)));
    }

    protected void m_7856_() {
        this.refreshControllers();
        MutableComponent donateText = Component.m_237115_((String)"controlify.gui.carousel.donate").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        FakePositionPlainTextButton donateBtn = (FakePositionPlainTextButton)this.m_142416_((GuiEventListener)new FakePositionPlainTextButton((Component)donateText, this.f_96547_, 3, 3, btn -> Util.m_137581_().m_137646_("https://ko-fi.com/isxander")));
        donateBtn.setFakePosition(new ScreenRectangle(0, this.f_96544_, this.f_96543_, 1));
        MutableComponent artCreditText = Component.m_237110_((String)"controlify.gui.carousel.art_credit", (Object[])new Object[]{Component.m_237113_((String)"Andrew Grant")}).m_130940_(ChatFormatting.DARK_GRAY);
        FakePositionPlainTextButton artCreditBtn = (FakePositionPlainTextButton)this.m_142416_((GuiEventListener)new FakePositionPlainTextButton((Component)artCreditText, this.f_96547_, this.f_96543_ - this.f_96547_.m_92852_((FormattedText)artCreditText) - 3, 3, btn -> Util.m_137581_().m_137646_("https://github.com/Andrew6rant")));
        artCreditBtn.setFakePosition(new ScreenRectangle(0, this.f_96544_ + 1, this.f_96543_, 1));
        GridLayout grid = new GridLayout().m_267749_(10);
        GridLayout.RowHelper rowHelper = grid.m_264606_(2);
        this.globalSettingsButton = (Button)rowHelper.m_264139_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"controlify.gui.global_settings.title"), btn -> this.f_96541_.m_91152_(GlobalSettingsScreenFactory.createGlobalSettingsScreen(this))).m_253136_());
        this.doneButton = (Button)rowHelper.m_264139_((LayoutElement)Button.m_253074_((Component)CommonComponents.f_130655_, btn -> this.m_7379_()).m_253136_());
        grid.m_264134_(widget -> {
            widget.m_267708_(1);
            this.m_142416_((GuiEventListener)widget);
        });
        grid.m_264036_();
        FrameLayout.m_264159_((LayoutElement)grid, (int)0, (int)(this.f_96544_ - 36), (int)this.f_96543_, (int)36);
        this.controllerNotDetectedButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"controlify.gui.carousel.controller_not_detected_btn"), btn -> Util.m_137581_().m_137646_("https://docs.isxander.dev/controlify/users/controller-issues#my-controller-is-not-detected")).m_252794_(this.f_96543_ / 2 - 75, (this.f_96544_ - 36) / 2 + 10).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"controlify.gui.carousel.controller_not_detected_btn.tooltip"))).m_253136_());
        this.controllerNotDetectedButton.f_93624_ = this.carouselEntries.isEmpty();
        ButtonGuideApi.addGuideToButton(this.globalSettingsButton, ControlifyBindings.GUI_ABSTRACT_ACTION_1, ButtonGuidePredicate.always());
        ButtonGuideApi.addGuideToButton(this.doneButton, ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always());
        this.footerY = Mth.m_144941_((int)(this.f_96544_ - 36 - 2), (int)2);
    }

    public void refreshControllers() {
        ControllerEntity prevSelectedController;
        if (this.carouselEntries != null && !this.carouselEntries.isEmpty()) {
            this.carouselEntries.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
            prevSelectedController = this.carouselEntries.get((int)this.carouselIndex).controller;
        } else {
            prevSelectedController = null;
        }
        this.carouselEntries = this.controllerManager.getConnectedControllers().stream().map(c -> new CarouselEntry((ControllerEntity)c, this.f_96543_ / 3, this.f_96544_ - 66)).peek(x$0 -> {
            CarouselEntry cfr_ignored_0 = (CarouselEntry)this.m_142416_((GuiEventListener)x$0);
        }).toList();
        this.carouselIndex = this.carouselEntries.stream().filter(e -> e.controller == prevSelectedController).findFirst().map(this.carouselEntries::indexOf).orElse(Controlify.instance().getCurrentController().map(c -> this.controllerManager.getConnectedControllers().indexOf(c)).orElse(0));
        if (!this.carouselEntries.isEmpty()) {
            this.carouselEntries.get((int)this.carouselIndex).overlayColor = 0;
        }
        float offsetX = (float)this.f_96543_ / 2.0f * (float)(-(this.carouselIndex - 1)) - (float)this.f_96543_ / 6.0f;
        for (int i = 0; i < this.carouselEntries.size(); ++i) {
            CarouselEntry entry = this.carouselEntries.get(i);
            entry.setX(offsetX + (float)this.f_96543_ / 2.0f * (float)i);
            entry.setY(i == this.carouselIndex ? 20.0f : 10.0f);
        }
        if (this.controllerNotDetectedButton != null) {
            this.controllerNotDetectedButton.f_93624_ = this.carouselEntries.isEmpty();
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        Blit.blitTex(graphics, CreateWorldScreen.f_273875_, 0, this.footerY, 0.0f, 0.0f, this.f_96543_, 2, 32, 2);
        if (this.carouselEntries.isEmpty()) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"controlify.gui.carousel.no_controllers"), this.f_96543_ / 2, (this.f_96544_ - 36) / 2 - 10, -5592406);
        }
    }

    public void m_280273_(GuiGraphics graphics) {
        graphics.m_280246_(0.5f, 0.5f, 0.5f, 1.0f);
        graphics.m_280398_(CreateWorldScreen.f_279536_, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.footerY, 32, 32);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280398_(CreateWorldScreen.f_279536_, 0, this.footerY, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_ - this.footerY, 32, 32);
    }

    public void focusOnEntry(int index) {
        if (this.carouselAnimation != null && !this.carouselAnimation.isDone()) {
            return;
        }
        int diff = index - this.carouselIndex;
        if (diff == 0) {
            return;
        }
        this.carouselIndex = index;
        Animation animation = Animation.of(10).easing(EasingFunction.EASE_IN_OUT_CUBIC);
        for (CarouselEntry entry : this.carouselEntries) {
            boolean selected = this.carouselEntries.indexOf((Object)entry) == index;
            animation.consumerF(entry::setX, entry.getX(), (float)entry.getX() + (float)(-diff) * ((float)this.f_96543_ / 2.0f));
            animation.consumerF(entry::setY, entry.getY(), selected ? 20.0 : 10.0);
            animation.consumerF(t -> {
                entry.overlayColor = ColorUtils.lerpARGB(t.floatValue(), entry.overlayColor, selected ? 0 : -1879048192);
            }, 0.0, 1.0);
        }
        this.carouselAnimation = animation.play();
    }

    @Override
    public void onControllerInput(ControllerEntity controller) {
        if (ControlifyBindings.GUI_ABSTRACT_ACTION_1.on(controller).justPressed()) {
            this.globalSettingsButton.m_5691_();
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    private class CarouselEntry
    extends AbstractContainerEventHandler
    implements Renderable,
    NarratableEntry {
        private int x;
        private int y;
        private final int width;
        private final int height;
        private float translationX;
        private float translationY;
        private final ControllerEntity controller;
        private final boolean hasNickname;
        private final Button useControllerButton;
        private final Button settingsButton;
        private final ImmutableList<? extends GuiEventListener> children;
        private boolean prevUse;
        private float currentlyUsedPos;
        private Animation currentlyUsedAnimation;
        private int overlayColor = -1879048192;
        private boolean hovered = false;
        private final boolean badSteamDeck;

        private CarouselEntry(ControllerEntity controller, int width, int height) {
            this.width = width;
            this.height = height;
            this.controller = controller;
            this.hasNickname = this.controller.genericConfig().config().nickname != null;
            this.settingsButton = Button.m_253074_((Component)Component.m_237115_((String)"controlify.gui.carousel.entry.settings"), btn -> ControllerCarouselScreen.this.f_96541_.m_91152_(ControllerConfigScreenFactory.generateConfigScreen(ControllerCarouselScreen.this, controller))).m_252780_((this.getWidth() - 2) / 2 - 2).m_253136_();
            this.useControllerButton = Button.m_253074_((Component)Component.m_237119_(), btn -> this.onUseStopUsingButton()).m_252780_(this.settingsButton.m_5711_()).m_253136_();
            this.updateUseStopUsingButton();
            this.children = ImmutableList.of((Object)this.settingsButton, (Object)this.useControllerButton);
            this.prevUse = this.isCurrentlyUsed();
            this.currentlyUsedPos = this.prevUse ? 1.0f : 0.0f;
            this.badSteamDeck = controller.info().type().isSteamDeck() && controller.getComponent(SteamDeckComponent.ID).isEmpty();
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            int n;
            this.hovered = this.m_5953_(mouseX, mouseY);
            graphics.m_280588_(this.x, this.y, this.x + this.width + (this.translationX > 0.0f ? 1 : 0), this.y + this.height + (this.translationY > 0.0f ? 1 : 0));
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(this.translationX, this.translationY, 0.0f);
            graphics.m_280637_(this.x, this.y, this.width, this.height, 0x5AFFFFFF);
            this.useControllerButton.m_88315_(graphics, mouseX, mouseY, delta);
            this.settingsButton.m_88315_(graphics, mouseX, mouseY, delta);
            Font font = ControllerCarouselScreen.this.f_96547_;
            String string = this.controller.name();
            int n2 = this.x + this.width / 2;
            Objects.requireNonNull(ControllerCarouselScreen.this.f_96547_);
            if (this.hasNickname) {
                Objects.requireNonNull(ControllerCarouselScreen.this.f_96547_);
                n = 9 + 1;
            } else {
                n = 0;
            }
            graphics.m_280137_(font, string, n2, this.y + this.height - 26 - 9 - n, 0xFFFFFF);
            if (this.hasNickname) {
                GenericControllerConfig config = this.controller.genericConfig().config();
                String nickname = config.nickname;
                config.nickname = null;
                Font font2 = ControllerCarouselScreen.this.f_96547_;
                String string2 = this.controller.name();
                int n3 = this.x + this.width / 2;
                Objects.requireNonNull(ControllerCarouselScreen.this.f_96547_);
                graphics.m_280137_(font2, string2, n3, this.y + this.height - 26 - 9, 0xAAAAAA);
                config.nickname = nickname;
            }
            MutableComponent currentlyInUseText = Component.m_237115_((String)"controlify.gui.carousel.entry.in_use").m_130940_(ChatFormatting.GREEN);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)(17 + ControllerCarouselScreen.this.f_96547_.m_92852_((FormattedText)currentlyInUseText)) * (this.currentlyUsedPos - 1.0f), 0.0f, 0.0f);
            if (this.currentlyUsedPos > 0.0f) {
                ClientUtils.drawSprite(graphics, CHECKMARK, this.x + 4, this.y + 4, 9, 8);
                graphics.m_280430_(ControllerCarouselScreen.this.f_96547_, (Component)currentlyInUseText, this.x + 17, this.y + 4, -1);
            }
            if (this.badSteamDeck) {
                ClientUtils.drawSprite(graphics, DANGER, this.x + 4, this.y + 4 + 10, 9, 8);
                graphics.m_280430_(ControllerCarouselScreen.this.f_96547_, (Component)Component.m_237115_((String)"controlify.steam_deck_no_driver"), this.x + 17, this.y + 4 + 10, -1);
            }
            graphics.m_280168_().m_85849_();
            int iconWidth = this.width - 6;
            Objects.requireNonNull(ControllerCarouselScreen.this.f_96547_);
            Objects.requireNonNull(ControllerCarouselScreen.this.f_96547_);
            int iconHeight = this.height - 22 - 4 - 9 - 8 - (9 * (this.hasNickname ? 2 : 1) + 1) - 6;
            int iconSize = Mth.m_144941_((int)Math.min(iconHeight, iconWidth), (int)2);
            graphics.m_280168_().m_85836_();
            PoseStack poseStack = graphics.m_280168_();
            float f = (float)this.x + (float)this.width / 2.0f - (float)iconSize / 2.0f;
            Objects.requireNonNull(ControllerCarouselScreen.this.f_96547_);
            poseStack.m_252880_(f, (float)(this.y + 9 + 12) + (float)iconHeight / 2.0f - (float)iconSize / 2.0f, 0.0f);
            graphics.m_280168_().m_85841_((float)iconSize / 64.0f, (float)iconSize / 64.0f, 1.0f);
            ClientUtils.drawSprite(graphics, this.controller.info().type().getIconSprite(), 0, 0, 64, 64);
            graphics.m_280168_().m_85849_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
            graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, this.overlayColor);
            graphics.m_280168_().m_85849_();
            graphics.m_280618_();
            if (this.prevUse != this.isCurrentlyUsed()) {
                if (this.currentlyUsedAnimation != null) {
                    this.currentlyUsedAnimation.skipToEnd();
                }
                this.currentlyUsedAnimation = Animation.of(20).easing(EasingFunction.EASE_OUT_QUINT).consumerF(t -> {
                    this.currentlyUsedPos = t.floatValue();
                }, this.currentlyUsedPos, this.isCurrentlyUsed() ? 1.0 : 0.0).play();
            }
            this.prevUse = this.isCurrentlyUsed();
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            int index;
            if (this.m_5953_(mouseX, mouseY) && (index = ControllerCarouselScreen.this.carouselEntries.indexOf((Object)this)) != ControllerCarouselScreen.this.carouselIndex) {
                if (ControllerCarouselScreen.this.carouselAnimation == null || ControllerCarouselScreen.this.carouselAnimation.isDone()) {
                    ControllerCarouselScreen.this.focusOnEntry(index);
                }
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        private void onUseStopUsingButton() {
            if (!this.isCurrentlyUsed()) {
                Controlify.instance().setCurrentController(this.controller, true);
            } else {
                Controlify.instance().setCurrentController(null, true);
                Controlify.instance().config().setCurrentControllerUid(null);
            }
            this.updateUseStopUsingButton();
        }

        private void updateUseStopUsingButton() {
            this.useControllerButton.m_93666_((Component)Component.m_237115_((String)(this.isCurrentlyUsed() ? "controlify.gui.carousel.entry.stop_using" : "controlify.gui.carousel.entry.use")));
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        }

        public void m_93692_(boolean focused) {
            super.m_93692_(focused);
            if (focused) {
                ControllerCarouselScreen.this.focusOnEntry(ControllerCarouselScreen.this.carouselEntries.indexOf((Object)this));
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public void setX(float x) {
            this.x = (int)x;
            this.settingsButton.m_252865_((int)x + 2);
            this.useControllerButton.m_252865_(this.settingsButton.m_252754_() + this.settingsButton.m_5711_() + 2);
            this.translationX = x - (float)((int)x);
        }

        public void setY(float y) {
            this.y = (int)y;
            this.useControllerButton.m_253211_((int)y + this.getHeight() - 20 - 2);
            this.settingsButton.m_253211_(this.useControllerButton.m_252907_());
            this.translationY = y - (float)((int)y);
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent event) {
            if (ControllerCarouselScreen.this.carouselAnimation != null && !ControllerCarouselScreen.this.carouselAnimation.isDone()) {
                return null;
            }
            return super.m_264064_(event);
        }

        public ScreenRectangle m_264198_() {
            return new ScreenRectangle(this.x, this.y, this.width, this.height);
        }

        public boolean isCurrentlyUsed() {
            return Controlify.instance().getCurrentController().orElse(null) == this.controller;
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return this.m_93696_() ? NarratableEntry.NarrationPriority.FOCUSED : (this.hovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE);
        }

        public void m_142291_(NarrationElementOutput builder) {
            builder.m_169143_(NarratedElementType.TITLE, this.controller.name());
            builder.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237113_((String)"Left arrow to go to previous controller, right arrow to go to next controller."));
        }
    }
}

