/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.gui.screen.RadialMenuScreen;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.DebugOverlayHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.player.inventory.Hotbar;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;

public final class RadialItems {
    public static final RadialMenuScreen.RadialItem EMPTY_ACTION = new RadialItemRecord((Component)Component.m_237119_(), RadialIcon.EMPTY, () -> false, RadialIcons.EMPTY);

    public static RadialMenuScreen.RadialItem[] createBindings(ControllerEntity controller) {
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[8];
        for (int i = 0; i < 8; ++i) {
            ResourceLocation bindingId = ((InputComponent.Config)controller.input().orElseThrow().confObj()).radialActions[i];
            items[i] = RadialItems.getItemForBinding(bindingId, controller);
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createGameModes() {
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[]{new GameModeItem(GameType.CREATIVE), new GameModeItem(GameType.SURVIVAL), new GameModeItem(GameType.ADVENTURE), new GameModeItem(GameType.SPECTATOR)};
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createHotbarSave() {
        Minecraft mc = Minecraft.m_91087_();
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[9];
        for (int i = 0; i < 9; ++i) {
            int j = i;
            items[i] = new RadialItemRecord((Component)Component.m_237110_((String)"controlify.radial.hotbar", (Object[])new Object[]{Component.m_237113_((String)Integer.toString(j + 1))}), RadialItems.getIconForHotbar(i, true), () -> {
                CreativeModeInventoryScreen.m_98598_((Minecraft)mc, (int)j, (boolean)false, (boolean)true);
                return true;
            }, CUtil.rl("hotbar_save/" + j));
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createHotbarLoad() {
        Minecraft mc = Minecraft.m_91087_();
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[9];
        for (int i = 0; i < items.length; ++i) {
            int j = i;
            items[i] = new RadialItemRecord((Component)Component.m_237110_((String)"controlify.radial.hotbar", (Object[])new Object[]{Component.m_237113_((String)Integer.toString(j + 1))}), RadialItems.getIconForHotbar(i, true), () -> {
                CreativeModeInventoryScreen.m_98598_((Minecraft)mc, (int)j, (boolean)true, (boolean)false);
                return true;
            }, CUtil.rl("hotbar_load/" + j));
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createHotbarItemSelect() {
        Minecraft mc = Minecraft.m_91087_();
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[9];
        for (int i = 0; i < items.length; ++i) {
            int j = i;
            items[i] = new RadialItemRecord((Component)Component.m_237110_((String)"controlify.radial.hotbar", (Object[])new Object[]{Component.m_237113_((String)Integer.toString(j + 1))}), (graphics, x, y, tickDelta) -> graphics.m_280480_(mc.f_91074_.m_150109_().m_8020_(j), x, y), () -> {
                mc.f_91074_.m_150109_().f_35977_ = j;
                return true;
            }, CUtil.rl("hotbar_item_select/" + j));
        }
        return items;
    }

    public static RadialMenuScreen.RadialItem[] createDebug() {
        RadialMenuScreen.RadialItem[] radialItemArray;
        RadialMenuScreen.RadialItem[] items = new RadialMenuScreen.RadialItem[]{new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.reload_chunks"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42522_)), () -> {
            DebugOverlayHelper.reloadChunks();
            return true;
        }, CUtil.rl("debug/reload_chunks")), new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.chunk_borders"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42573_)), () -> {
            DebugOverlayHelper.toggleChunkBorders();
            return true;
        }, CUtil.rl("debug/chunk_borders")), new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.advanced_tooltips"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42614_)), () -> {
            DebugOverlayHelper.toggleAdvancedTooltips();
            return true;
        }, CUtil.rl("debug/advanced_tooltips")), new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.entity_hitboxes"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42681_)), () -> {
            DebugOverlayHelper.toggleEntityHitboxes();
            return true;
        }, CUtil.rl("debug/entity_hitboxes")), new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.reload_packs"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42489_)), () -> {
            DebugOverlayHelper.reloadResourcePacks();
            return true;
        }, CUtil.rl("debug/reload_packs")), new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.clear_chat"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42409_)), () -> {
            DebugOverlayHelper.clearChat();
            return true;
        }, CUtil.rl("debug/clear_chat")), new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.profile"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42352_)), () -> {
            DebugOverlayHelper.startStopProfiling();
            return true;
        }, CUtil.rl("debug/profile"))};
        boolean overlayEnabled = DebugOverlayHelper.isOverlayEnabled();
        if (!overlayEnabled) {
            RadialMenuScreen.RadialItem[] radialItemArray2 = new RadialMenuScreen.RadialItem[3];
            radialItemArray2[0] = new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.overlay"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42751_)), () -> {
                DebugOverlayHelper.toggleOverlay();
                return true;
            }, CUtil.rl("debug/overlay"));
            radialItemArray2[1] = new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.overlay_fps"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42524_)), () -> {
                DebugOverlayHelper.toggleFpsOverlay();
                return true;
            }, CUtil.rl("debug/fps"));
            radialItemArray = radialItemArray2;
            radialItemArray2[2] = new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.overlay_charts"), RadialIcons.getIcons().get(RadialIcons.getItem(Items.f_42451_)), () -> {
                DebugOverlayHelper.toggleChartsOverlay();
                return true;
            }, CUtil.rl("debug/fps"));
        } else {
            RadialMenuScreen.RadialItem[] radialItemArray3 = new RadialMenuScreen.RadialItem[1];
            radialItemArray = radialItemArray3;
            radialItemArray3[0] = new RadialItemRecord((Component)Component.m_237115_((String)"controlify.radial.debug.hide_overlay"), RadialIcons.getIcons().get(RadialIcons.getEffect(MobEffects.f_19609_)), () -> {
                DebugOverlayHelper.toggleOverlay();
                return true;
            }, CUtil.rl("debug/reload_chunks"));
        }
        RadialMenuScreen.RadialItem[] overlayItems = radialItemArray;
        RadialMenuScreen.RadialItem[] allItems = new RadialMenuScreen.RadialItem[items.length + overlayItems.length];
        System.arraycopy(overlayItems, 0, allItems, 0, overlayItems.length);
        System.arraycopy(items, 0, allItems, overlayItems.length, items.length);
        return allItems;
    }

    private static RadialIcon getIconForHotbar(int hotbarIndex, boolean showNumbers) {
        Hotbar hotbar;
        Minecraft mc = Minecraft.m_91087_();
        Hotbar hotbarItems = hotbar = mc.m_91303_().m_90806_(hotbarIndex);
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)hotbarItems.get(i);
            if (stack.m_150930_(Items.f_41852_)) continue;
            return (graphics, x, y, tickDelta) -> {
                graphics.m_280480_(stack, x, y);
                if (showNumbers) {
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
                    graphics.m_280488_(mc.f_91062_, Integer.toString(hotbarIndex + 1), x, y, -1);
                    graphics.m_280168_().m_85849_();
                }
            };
        }
        return (graphics, x, y, tickDelta) -> {
            if (showNumbers) {
                graphics.m_280488_(mc.f_91062_, Integer.toString(hotbarIndex + 1), x, y, -1);
            }
        };
    }

    private static RadialMenuScreen.RadialItem getItemForBinding(ResourceLocation id, ControllerEntity controller) {
        InputBinding binding = controller.input().orElseThrow().getBinding(id);
        if (binding == null || binding.radialIcon().isEmpty()) {
            CUtil.LOGGER.warn("Binding {} does not exist or is not a radial candidate", binding);
            return EMPTY_ACTION;
        }
        RadialIcon icon = RadialIcons.getIcons().get(binding.radialIcon().get());
        return new RadialItemRecord(binding.name(), icon, () -> {
            binding.fakePress();
            return true;
        }, id);
    }

    private static class GameModeItem
    implements RadialMenuScreen.RadialItem {
        private final GameType gameType;
        private final Component name;
        private final RadialIcon icon;
        private final String command;

        public GameModeItem(GameType gameType) {
            this.gameType = gameType;
            this.name = gameType.m_151500_();
            ResourceLocation iconId = switch (gameType) {
                default -> throw new IncompatibleClassChangeError();
                case GameType.CREATIVE -> RadialIcons.getItem(Items.f_42276_);
                case GameType.SURVIVAL -> RadialIcons.getItem(Items.f_42383_);
                case GameType.ADVENTURE -> RadialIcons.getItem(Items.f_42676_);
                case GameType.SPECTATOR -> RadialIcons.getItem(Items.f_42545_);
            };
            this.icon = RadialIcons.getIcons().get(iconId);
            this.command = switch (gameType) {
                default -> throw new IncompatibleClassChangeError();
                case GameType.CREATIVE -> "gamemode creative";
                case GameType.SURVIVAL -> "gamemode survival";
                case GameType.ADVENTURE -> "gamemode adventure";
                case GameType.SPECTATOR -> "gamemode spectator";
            };
        }

        @Override
        public Component name() {
            return this.name;
        }

        @Override
        public RadialIcon icon() {
            return this.icon;
        }

        @Override
        public boolean playAction() {
            Minecraft client = Minecraft.m_91087_();
            if (client.f_91072_ != null && client.f_91074_ != null && client.f_91074_.m_20310_(2) && client.f_91072_.m_105295_() != this.gameType) {
                client.f_91074_.f_108617_.m_246979_(this.command);
                return true;
            }
            return false;
        }
    }

    private record RadialItemRecord(Component name, RadialIcon icon, Supplier<Boolean> action, ResourceLocation id) implements RadialMenuScreen.RadialItem
    {
        @Override
        public boolean playAction() {
            return this.action.get();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RadialItemRecord) {
                RadialItemRecord record = (RadialItemRecord)obj;
                return this.id.equals((Object)record.id);
            }
            return false;
        }
    }

    public static class BindingEditMode
    implements RadialMenuScreen.EditMode {
        private final ControllerEntity controller;

        public BindingEditMode(ControllerEntity controller) {
            this.controller = controller;
        }

        @Override
        public void setRadialItem(int index, RadialMenuScreen.RadialItem item) {
            ((InputComponent.Config)this.controller.input().orElseThrow().confObj()).radialActions[index] = ((RadialItemRecord)item).id();
        }

        @Override
        public List<RadialMenuScreen.RadialItem> getEditCandidates() {
            ArrayList<RadialMenuScreen.RadialItem> items = new ArrayList<RadialMenuScreen.RadialItem>();
            this.controller.input().orElseThrow().getAllBindings().forEach(binding -> binding.radialIcon().ifPresent(icon -> items.add(new RadialItemRecord(binding.name(), RadialIcons.getIcons().get(icon), () -> false, binding.id()))));
            return items;
        }
    }
}

