/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.hid;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import dev.isxander.controlify.hid.HIDIdentifier;
import dev.isxander.sdl3java.api.hidapi.SDL_hid_device;
import dev.isxander.sdl3java.api.hidapi.SdlHidApi;
import dev.isxander.sdl3java.jna.size_t;
import org.hid4java.HidDevice;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HIDDevice {
    public int vendorId();

    public int productId();

    public String path();

    public boolean supportsCommunication();

    public void open();

    public void close();

    public int read(byte[] var1);

    public int write(byte[] var1, int var2, byte var3);

    default public HIDIdentifier asIdentifier() {
        return new HIDIdentifier(this.vendorId(), this.productId());
    }

    public static final class SDLHidApi
    implements HIDDevice {
        private final int vendorId;
        private final int productId;
        private final String path;
        private SDL_hid_device device;

        public SDLHidApi(int vendorId, int productId, String path) {
            this.vendorId = vendorId;
            this.productId = productId;
            this.path = path;
            this.device = null;
        }

        @Override
        public int vendorId() {
            return this.vendorId;
        }

        @Override
        public int productId() {
            return this.productId;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public boolean supportsCommunication() {
            return true;
        }

        @Override
        public void open() {
            this.device = SdlHidApi.SDL_hid_open_path((String)this.path);
            SdlHidApi.SDL_hid_set_nonblocking((SDL_hid_device)this.device, (int)1);
        }

        @Override
        public void close() {
            SdlHidApi.SDL_hid_close((SDL_hid_device)this.device);
            this.device = null;
        }

        @Override
        public int read(byte[] buffer) {
            try (Memory memory = new Memory((long)buffer.length);){
                int ret = SdlHidApi.SDL_hid_read((SDL_hid_device)this.device, (Pointer)memory, (size_t)new size_t((long)buffer.length));
                memory.read(0L, buffer, 0, buffer.length);
                int n = ret;
                return n;
            }
        }

        @Override
        public int write(byte[] buffer, int packetLength, byte reportId) {
            try (Memory memory = new Memory((long)(buffer.length + 1));){
                memory.setByte((long)buffer.length, reportId);
                memory.write(1L, buffer, 0, buffer.length);
                int n = SdlHidApi.SDL_hid_write((SDL_hid_device)this.device, (Pointer)memory, (size_t)new size_t((long)buffer.length));
                return n;
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof HIDDevice) {
                HIDDevice hid = (HIDDevice)obj;
                return this.asIdentifier().equals(hid.asIdentifier());
            }
            return false;
        }
    }

    public record IDOnly(int vendorId, int productId, String path) implements HIDDevice
    {
        @Override
        public boolean supportsCommunication() {
            return false;
        }

        @Override
        public void open() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] buffer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(byte[] buffer, int packetLength, byte reportId) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof HIDDevice) {
                HIDDevice hid = (HIDDevice)obj;
                return this.asIdentifier().equals(hid.asIdentifier());
            }
            return false;
        }
    }

    public static final class Hid4Java
    implements HIDDevice {
        private final HidDevice hidDevice;

        public Hid4Java(HidDevice hidDevice) {
            this.hidDevice = hidDevice;
        }

        @Override
        public int vendorId() {
            return this.hidDevice.getVendorId();
        }

        @Override
        public int productId() {
            return this.hidDevice.getProductId();
        }

        @Override
        public String path() {
            return this.hidDevice.getPath();
        }

        @Override
        public boolean supportsCommunication() {
            return true;
        }

        @Override
        public void open() {
            this.hidDevice.open();
            this.hidDevice.setNonBlocking(true);
        }

        @Override
        public void close() {
            this.hidDevice.close();
        }

        @Override
        public int read(byte[] buffer) {
            return this.hidDevice.read(buffer);
        }

        @Override
        public int write(byte[] buffer, int packetLength, byte reportId) {
            return this.hidDevice.write(buffer, packetLength, reportId);
        }

        public boolean equals(Object obj) {
            if (obj instanceof HIDDevice) {
                HIDDevice hid = (HIDDevice)obj;
                return this.asIdentifier().equals(hid.asIdentifier());
            }
            return false;
        }
    }
}

