/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.ingame;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.ingame.DualInput;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.Nullable;

public class ControllerPlayerMovement
extends Input {
    private final ControllerEntity controller;
    private final LocalPlayer player;
    private boolean wasFlying;
    private boolean wasPassenger;

    public ControllerPlayerMovement(ControllerEntity controller, LocalPlayer player) {
        this.controller = controller;
        this.player = player;
    }

    public void m_214106_(boolean slowDown, float movementMultiplier) {
        if (Minecraft.m_91087_().f_91080_ != null || this.player == null) {
            this.setMoveVec(0.0f, 0.0f);
            this.f_108568_ = false;
            this.f_108569_ = false;
            this.f_108570_ = false;
            this.f_108571_ = false;
            this.f_108572_ = false;
            this.f_108573_ = false;
            return;
        }
        float forwardImpulse = ControlifyBindings.WALK_FORWARD.on(this.controller).analogueNow() - ControlifyBindings.WALK_BACKWARD.on(this.controller).analogueNow();
        float leftImpulse = ControlifyBindings.WALK_LEFT.on(this.controller).analogueNow() - ControlifyBindings.WALK_RIGHT.on(this.controller).analogueNow();
        if (Controlify.instance().config().globalSettings().shouldUseKeyboardMovement()) {
            float threshold = ((InputComponent.Config)this.controller.input().orElseThrow().confObj()).buttonActivationThreshold;
            forwardImpulse = Math.abs(forwardImpulse) >= threshold ? Math.copySign(1.0f, forwardImpulse) : 0.0f;
            leftImpulse = Math.abs(leftImpulse) >= threshold ? Math.copySign(1.0f, leftImpulse) : 0.0f;
        }
        this.f_108568_ = forwardImpulse > 0.0f;
        this.f_108569_ = forwardImpulse < 0.0f;
        this.f_108570_ = leftImpulse > 0.0f;
        boolean bl = this.f_108571_ = leftImpulse < 0.0f;
        if (slowDown) {
            leftImpulse *= movementMultiplier;
            forwardImpulse *= movementMultiplier;
        }
        this.setMoveVec(forwardImpulse, leftImpulse);
        InputBinding jump = ControlifyBindings.JUMP.on(this.controller);
        if (jump.justPressed()) {
            this.f_108572_ = true;
        }
        if (!jump.digitalNow()) {
            this.f_108572_ = false;
        }
        InputBinding sneak = ControlifyBindings.SNEAK.on(this.controller);
        if (this.player.m_150110_().f_35935_ || this.player.m_20069_() && !this.player.m_20096_() || this.player.m_20202_() != null || !this.controller.genericConfig().config().toggleSneak) {
            if (sneak.justPressed()) {
                this.f_108573_ = true;
            }
            if (!sneak.digitalNow()) {
                this.f_108573_ = false;
            }
        } else if (sneak.justPressed()) {
            boolean bl2 = this.f_108573_ = !this.f_108573_;
        }
        if (!this.player.m_150110_().f_35935_ && this.wasFlying && this.player.m_20096_() || !this.player.m_20159_() && this.wasPassenger) {
            this.f_108573_ = false;
        }
        this.wasFlying = this.player.m_150110_().f_35935_;
        this.wasPassenger = this.player.m_20159_();
    }

    private void setMoveVec(float forward, float left) {
        this.f_108567_ = forward;
        this.f_108566_ = left;
    }

    public static void updatePlayerInput(@Nullable LocalPlayer player) {
        if (player == null) {
            return;
        }
        if (ControllerPlayerMovement.shouldBeControllerInput()) {
            player.f_108618_ = new DualInput((Input)new KeyboardInput(Minecraft.m_91087_().f_91066_), new ControllerPlayerMovement(Controlify.instance().getCurrentController().get(), player));
        } else if (!(player.f_108618_ instanceof KeyboardInput)) {
            player.f_108618_ = new KeyboardInput(Minecraft.m_91087_().f_91066_);
        }
    }

    public static void ensureCorrectInput(@Nullable LocalPlayer player) {
        if (player == null) {
            return;
        }
        if (ControllerPlayerMovement.shouldBeControllerInput() && player.f_108618_.getClass() == KeyboardInput.class) {
            ControllerPlayerMovement.updatePlayerInput(player);
        }
    }

    public static boolean shouldBeControllerInput() {
        return Controlify.instance().getCurrentController().isPresent() && Controlify.instance().currentInputMode().isController();
    }
}

