/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenkeyboard;

import com.mojang.datafixers.util.Pair;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenkeyboard.KeyPressConsumer;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.ControlifySprite;
import dev.isxander.controlify.utils.render.ControlifyVertexConsumer;
import dev.isxander.controlify.utils.render.ExtraRenderTypes;
import dev.isxander.controlify.utils.render.SpriteScaling;
import dev.isxander.controlify.utils.render.SpriteUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class KeyboardWidget<T extends Key>
extends AbstractWidget
implements ContainerEventHandler {
    protected final List<T> keys;
    protected final KeyPressConsumer keyPressConsumer;
    protected boolean shiftMode;
    @Nullable
    private GuiEventListener focused;
    private boolean isDragging;
    private final Screen containingScreen;

    public KeyboardWidget(Screen screen, int x, int y, int width, int height, KeyPressConsumer keyPressConsumer) {
        super(x, y, width, height, (Component)Component.m_237113_((String)"On-screen keyboard"));
        this.containingScreen = screen;
        this.keyPressConsumer = keyPressConsumer;
        this.keys = new ArrayList<T>();
        this.arrangeKeys();
    }

    protected abstract void arrangeKeys();

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Key key : this.keys) {
            key.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        Blit.drawManaged(guiGraphics, bufferSource -> {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), Integer.MIN_VALUE);
            guiGraphics.m_280637_(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), -5592406);
            ControlifyVertexConsumer vertexConsumer = ControlifyVertexConsumer.of(bufferSource.m_6299_(ExtraRenderTypes.guiTextured(Key.SPRITE.atlas())));
            for (Key key : this.keys) {
                Matrix4f pose = guiGraphics.m_280168_().m_85850_().m_252922_();
                key.renderKeyBackground(vertexConsumer, pose, mouseX, mouseY, partialTick);
            }
            for (Key key : this.keys) {
                key.renderKeyForeground(guiGraphics, mouseX, mouseY, partialTick);
            }
        });
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    @NotNull
    public List<T> m_6702_() {
        return this.keys;
    }

    public boolean m_7282_() {
        return this.isDragging;
    }

    public void m_7897_(boolean dragging) {
        this.isDragging = dragging;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.focused;
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        if (this.focused != null) {
            this.focused.m_93692_(false);
        }
        if (focused != null) {
            focused.m_93692_(true);
        }
        this.focused = focused;
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent event) {
        return super.m_264064_(event);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_93696_() {
        return super.m_93696_();
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
    }

    public static class Key
    extends AbstractWidget
    implements ComponentProcessor,
    ScreenControllerEventListener {
        public static final ControlifySprite SPRITE = new ControlifySprite(CUtil.rl("textures/gui/sprites/keyboard/key.png"), new SpriteScaling.NineSlice(30, 24, new SpriteScaling.NineSlice.Border(1, 1, 3, 3)));
        private final KeyboardWidget<?> keyboard;
        private final KeyFunction normalFunction;
        private final KeyFunction shiftedFunction;
        private boolean highlighted;
        private final HoldRepeatHelper holdRepeatHelper;
        private final InputBindingSupplier shortcutPressBind;
        private boolean shortcutPressed;

        public Key(Screen screen, int x, int y, int width, int height, KeyFunction normalFunction, @Nullable KeyFunction shiftedFunction, KeyboardWidget<?> keyboard, @Nullable InputBindingSupplier shortcutPressBind) {
            super(x, y, width, height, (Component)Component.m_237113_((String)"Key"));
            this.keyboard = keyboard;
            this.normalFunction = normalFunction;
            this.shiftedFunction = shiftedFunction != null ? shiftedFunction : normalFunction;
            this.holdRepeatHelper = new HoldRepeatHelper(10, 2);
            this.shortcutPressBind = shortcutPressBind;
            ScreenProcessorProvider.provide(screen).addEventListener(this);
        }

        public Key(Screen screen, int x, int y, int width, int height, Pair<KeyFunction, KeyFunction> functions, KeyboardWidget<?> keyboard, @Nullable InputBindingSupplier shortcutPressBind) {
            this(screen, x, y, width, height, (KeyFunction)functions.getFirst(), (KeyFunction)functions.getSecond(), keyboard, shortcutPressBind);
        }

        protected void renderKeyBackground(ControlifyVertexConsumer vertexConsumer, Matrix4f pose, int mouseX, int mouseY, float partialTick) {
            SpriteUtils.blitSprite(vertexConsumer, pose, SPRITE, this.m_252754_() + 1, this.m_252907_() + 1, this.m_5711_() - 2, this.m_93694_() - 2);
        }

        protected void renderKeyForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            if (this.keyboard.shiftMode) {
                this.shiftedFunction.renderer.render(graphics, mouseX, mouseY, partialTick, this);
            } else {
                this.normalFunction.renderer.render(graphics, mouseX, mouseY, partialTick, this);
            }
            if (this.m_198029_() || this.shortcutPressed) {
                graphics.m_280637_(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), -1);
            } else {
                this.holdRepeatHelper.reset();
            }
        }

        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
            if (this.holdRepeatHelper.shouldAction(ControlifyBindings.GUI_PRESS.on(controller))) {
                this.onPress();
                this.holdRepeatHelper.onNavigate();
            }
            return true;
        }

        @Override
        public void onControllerInput(ControllerEntity controller) {
            if (this.shortcutPressBind == null) {
                return;
            }
            InputBinding shortcutBind = this.shortcutPressBind.on(controller);
            this.shortcutPressed = shortcutBind.digitalNow();
            if (this.holdRepeatHelper.shouldAction(shortcutBind)) {
                this.onPress();
                this.holdRepeatHelper.onNavigate();
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.m_5953_(mouseX, mouseY)) {
                this.onPress();
                return true;
            }
            return false;
        }

        protected void onPress() {
            if (this.keyboard.shiftMode) {
                this.shiftedFunction.consumer.accept(this.keyboard.keyPressConsumer, this);
            } else {
                this.normalFunction.consumer.accept(this.keyboard.keyPressConsumer, this);
            }
        }

        public Component modifyKeyName(Component name) {
            Optional<ControllerEntity> controller = ControlifyApi.get().getCurrentController().filter(c -> ControlifyApi.get().currentInputMode().isController());
            if (this.shortcutPressBind != null && controller.isPresent()) {
                InputBinding binding = this.shortcutPressBind.on(controller.get());
                return Component.m_237119_().m_7220_(binding.inputIcon()).m_7220_(name);
            }
            return name;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        }

        public void setHighlighted(boolean highlighted) {
            this.highlighted = highlighted;
        }

        public boolean isHighlighted() {
            return this.highlighted;
        }

        public static KeyBuilder<Key> builder(Pair<KeyFunction, KeyFunction> functions, @Nullable InputBindingSupplier shortcutPressBind) {
            return (screen, x, y, w, h, kb) -> new Key(screen, x, y, w, h, (KeyFunction)functions.getFirst(), (KeyFunction)functions.getSecond(), kb, shortcutPressBind);
        }

        public static KeyBuilder<Key> builder(KeyFunction normalFunction, KeyFunction shiftedFunction, @Nullable InputBindingSupplier shortcutPressBind) {
            return (screen, x, y, w, h, kb) -> new Key(screen, x, y, w, h, normalFunction, shiftedFunction, kb, shortcutPressBind);
        }

        public static interface ForegroundRenderer {
            public void render(GuiGraphics var1, int var2, int var3, float var4, Key var5);

            public static ForegroundRenderer text(Component text) {
                return (guiGraphics, mouseX, mouseY, partialTick, key) -> guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, key.modifyKeyName(text), key.m_252754_() + key.m_5711_() / 2, key.m_252907_() + key.m_93694_() / 2 - 4, -1);
            }
        }
    }

    @FunctionalInterface
    public static interface KeyBuilder<T extends Key> {
        public T build(Screen var1, int var2, int var3, int var4, int var5, KeyboardWidget<T> var6);
    }

    public static class KeyLayoutBuilder<T extends Key> {
        private final List<List<KeyLayout<T>>> layout;
        private final float maxUnitWidth;
        private final int rowCount;
        private final KeyboardWidget<T> keyboard;
        private float currentWidth;
        private int currentRow;

        public KeyLayoutBuilder(float maxUnitWidth, int rowCount, KeyboardWidget<T> keyboard) {
            this.maxUnitWidth = maxUnitWidth;
            this.rowCount = rowCount;
            this.keyboard = keyboard;
            this.layout = new ArrayList<List<KeyLayout<T>>>(rowCount);
            for (int i = 0; i < rowCount; ++i) {
                this.layout.add(new ArrayList());
            }
        }

        public void key(KeyBuilder<T> key, float width) {
            Validate.isTrue((this.currentWidth + width <= this.maxUnitWidth ? 1 : 0) != 0, (String)"Key width exceeds row width", (Object[])new Object[0]);
            this.layout.get(this.currentRow).add(new KeyLayout<T>(key, width));
            this.currentWidth += width;
        }

        public void nextRow() {
            Validate.isTrue((this.currentRow < this.rowCount ? 1 : 0) != 0, (String)"Row index out of bounds", (Object[])new Object[0]);
            this.currentWidth = 0.0f;
            ++this.currentRow;
        }

        public void build(Consumer<T> keyConsumer) {
            int trueWidth = this.keyboard.m_5711_();
            int trueHeight = this.keyboard.m_93694_();
            float unitWidth = (float)trueWidth / this.maxUnitWidth;
            float keyHeight = (float)trueHeight / (float)this.rowCount;
            float y = this.keyboard.m_252907_();
            for (List<KeyLayout<T>> row : this.layout) {
                float x = this.keyboard.m_252754_();
                for (KeyLayout<T> keyLayout : row) {
                    float keyWidth = unitWidth * keyLayout.unitWidth;
                    Object key = keyLayout.keyBuilder.build(this.keyboard.containingScreen, (int)x, (int)y, (int)keyWidth, (int)keyHeight, this.keyboard);
                    keyConsumer.accept(key);
                    x += keyWidth;
                }
                y += keyHeight;
            }
        }

        private record KeyLayout<T extends Key>(KeyBuilder<T> keyBuilder, float unitWidth) {
        }
    }

    public record KeyFunction(BiConsumer<KeyPressConsumer, Key> consumer, Key.ForegroundRenderer renderer) {
        public static Pair<KeyFunction, KeyFunction> ofChar(int normalKeyCode, char normalChar, int normalModifier, int shiftedKeyCode, char shiftedChar, int shiftedModifier) {
            return Pair.of((Object)new KeyFunction((screen, key) -> {
                screen.acceptKeyCode(normalKeyCode, 0, normalModifier);
                screen.acceptChar(normalChar, normalModifier);
            }, Key.ForegroundRenderer.text((Component)Component.m_237113_((String)String.valueOf(normalChar)))), (Object)new KeyFunction((screen, key) -> {
                screen.acceptKeyCode(shiftedKeyCode, 0, shiftedModifier);
                screen.acceptChar(shiftedChar, shiftedModifier);
            }, Key.ForegroundRenderer.text((Component)Component.m_237113_((String)String.valueOf(shiftedChar)))));
        }

        public static Pair<KeyFunction, KeyFunction> ofChar(int keyCode, char ch) {
            return KeyFunction.ofChar(keyCode, Character.toLowerCase(ch), 0, keyCode, Character.toUpperCase(ch), 1);
        }

        public static Pair<KeyFunction, KeyFunction> ofRegularKey(int keycode, String normal) {
            KeyFunction function = new KeyFunction((screen, key) -> screen.acceptKeyCode(keycode, 0, 0), Key.ForegroundRenderer.text((Component)Component.m_237113_((String)normal)));
            return Pair.of((Object)function, (Object)function);
        }

        public static Pair<KeyFunction, KeyFunction> ofShiftableKey(int normalKeyCode, int normalModifier, String normalName, int shiftKeyCode, int shiftModifier, String shiftName) {
            return Pair.of((Object)new KeyFunction((screen, key) -> screen.acceptKeyCode(normalKeyCode, 0, normalModifier), Key.ForegroundRenderer.text((Component)Component.m_237113_((String)normalName))), (Object)new KeyFunction((screen, key) -> screen.acceptKeyCode(shiftKeyCode, 0, shiftModifier), Key.ForegroundRenderer.text((Component)Component.m_237113_((String)shiftName))));
        }

        public static Pair<KeyFunction, KeyFunction> ofShiftableKey(int keyCode, String normal, String shift) {
            return KeyFunction.ofShiftableKey(keyCode, 0, normal, keyCode, 1, shift);
        }

        public Pair<KeyFunction, KeyFunction> copyShifted() {
            return Pair.of((Object)this, (Object)this);
        }
    }
}

