/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.api.buttonguide.ButtonGuideApi;
import dev.isxander.controlify.api.buttonguide.ButtonGuidePredicate;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.mixins.feature.screenop.vanilla.PauseScreenAccessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class PauseScreenProcessor
extends ScreenProcessor<PauseScreen> {
    private final Supplier<@Nullable Button> disconnectButtonSupplier;

    public PauseScreenProcessor(PauseScreen screen, Supplier<@Nullable Button> disconnectButtonSupplier) {
        super(screen);
        this.disconnectButtonSupplier = disconnectButtonSupplier;
    }

    @Override
    protected void handleButtons(ControllerEntity controller) {
        super.handleButtons(controller);
        if (ControlifyBindings.GUI_ABSTRACT_ACTION_1.on(controller).justPressed()) {
            minecraft.m_91152_((Screen)new OptionsScreen(this.screen, PauseScreenProcessor.minecraft.f_91066_));
        }
        if (ControlifyBindings.GUI_ABSTRACT_ACTION_2.on(controller).justPressed()) {
            ((PauseScreen)this.screen).m_7522_((GuiEventListener)this.disconnectButtonSupplier.get());
        }
    }

    @Override
    public void onWidgetRebuild() {
        super.onWidgetRebuild();
        if (((PauseScreenAccessor)this.screen).getShowPauseMenu()) {
            this.getWidget("menu.returnToGame").ifPresent(widget -> ButtonGuideApi.addGuideToButton((AbstractButton)widget, ControlifyBindings.GUI_BACK, ButtonGuidePredicate.always()));
            this.getWidget("menu.options").ifPresent(widget -> ButtonGuideApi.addGuideToButton((AbstractButton)widget, ControlifyBindings.GUI_ABSTRACT_ACTION_1, ButtonGuidePredicate.always()));
            Button disconnectButton = this.disconnectButtonSupplier.get();
            if (disconnectButton != null) {
                ButtonGuideApi.addGuideToButton(disconnectButton, () -> disconnectButton.m_93696_() ? ControlifyBindings.GUI_PRESS : ControlifyBindings.GUI_ABSTRACT_ACTION_2, ButtonGuidePredicate.always());
            }
        }
    }
}

