/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.isxander.controlify.platform.network.SidedNetworkApi;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.server.packets.EntityVibrationPacket;
import dev.isxander.controlify.server.packets.OriginVibrationPacket;
import dev.isxander.controlify.server.packets.VibrationPacket;
import dev.isxander.controlify.utils.CUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class VibrateCommand {
    private static final SuggestionProvider<CommandSourceStack> SOURCES_SUGGESTION = SuggestionProviders.m_121658_((ResourceLocation)CUtil.rl("vibration_sources"), (context, builder) -> SharedSuggestionProvider.m_82926_(RumbleSource.values().stream().map(RumbleSource::id).toList(), (SuggestionsBuilder)builder));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"vibratecontroller").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"receivers", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"low_freq_vibration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(Commands.m_82129_((String)"high_freq_vibration", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82127_((String)"static").executes(context -> VibrateCommand.vibrateStatic((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"receivers"), FloatArgumentType.getFloat((CommandContext)context, (String)"low_freq_vibration"), FloatArgumentType.getFloat((CommandContext)context, (String)"high_freq_vibration"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), RumbleSource.MASTER)))).then(Commands.m_82127_((String)"positioned").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"range", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).then(Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120847_((boolean)true)).executes(context -> VibrateCommand.vibrateFromOrigin((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"receivers"), Vec3Argument.m_120844_((CommandContext)context, (String)"position"), FloatArgumentType.getFloat((CommandContext)context, (String)"range"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), FloatArgumentType.getFloat((CommandContext)context, (String)"low_freq_vibration"), FloatArgumentType.getFloat((CommandContext)context, (String)"high_freq_vibration"), RumbleSource.MASTER)))).then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> VibrateCommand.vibrateFromEntity((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"receivers"), EntityArgument.m_91452_((CommandContext)context, (String)"entity"), FloatArgumentType.getFloat((CommandContext)context, (String)"range"), IntegerArgumentType.getInteger((CommandContext)context, (String)"duration"), FloatArgumentType.getFloat((CommandContext)context, (String)"low_freq_vibration"), FloatArgumentType.getFloat((CommandContext)context, (String)"high_freq_vibration"), RumbleSource.MASTER))))))))));
    }

    private static int vibrateStatic(CommandSourceStack source, Collection<ServerPlayer> targets, float lowFreqMagnitude, float highFreqMagnitude, int durationTicks, RumbleSource rumbleSource) {
        Object[] frames = new RumbleState[durationTicks];
        Arrays.fill(frames, new RumbleState(lowFreqMagnitude, highFreqMagnitude));
        VibrationPacket packet = new VibrationPacket(rumbleSource, (RumbleState[])frames);
        for (ServerPlayer player : targets) {
            SidedNetworkApi.S2C().sendPacket(player, VibrationPacket.CHANNEL, packet);
        }
        source.m_288197_(() -> targets.size() == 1 ? Component.m_237115_((String)"controlify.command.vibratecontroller.static.single") : Component.m_237110_((String)"controlify.command.vibratecontroller.static.multiple", (Object[])new Object[]{targets.size()}), true);
        return targets.size();
    }

    private static int vibrateFromOrigin(CommandSourceStack source, Collection<ServerPlayer> targets, Vec3 origin, float effectRange, int duration, float lowFreqMagnitude, float highFreqMagnitude, RumbleSource rumbleSource) {
        RumbleState state = new RumbleState(lowFreqMagnitude, highFreqMagnitude);
        OriginVibrationPacket packet = new OriginVibrationPacket(origin.m_252839_(), effectRange, duration, state, rumbleSource);
        for (ServerPlayer player : targets) {
            SidedNetworkApi.S2C().sendPacket(player, OriginVibrationPacket.CHANNEL, packet);
        }
        source.m_288197_(() -> targets.size() == 1 ? Component.m_237110_((String)"controlify.command.vibratecontroller.pos.single", (Object[])new Object[]{VibrateCommand.formatDouble(origin.f_82479_), VibrateCommand.formatDouble(origin.f_82480_), VibrateCommand.formatDouble(origin.f_82481_)}) : Component.m_237110_((String)"controlify.command.vibratecontroller.pos.multiple", (Object[])new Object[]{targets.size(), VibrateCommand.formatDouble(origin.f_82479_), VibrateCommand.formatDouble(origin.f_82480_), VibrateCommand.formatDouble(origin.f_82481_)}), true);
        return targets.size();
    }

    private static int vibrateFromEntity(CommandSourceStack source, Collection<ServerPlayer> targets, Entity origin, float effectRange, int duration, float lowFreqMagnitude, float highFreqMagnitude, RumbleSource rumbleSource) {
        RumbleState state = new RumbleState(lowFreqMagnitude, highFreqMagnitude);
        EntityVibrationPacket packet = new EntityVibrationPacket(origin.m_19879_(), effectRange, duration, state, rumbleSource);
        for (ServerPlayer player : targets) {
            SidedNetworkApi.S2C().sendPacket(player, EntityVibrationPacket.CHANNEL, packet);
        }
        source.m_288197_(() -> targets.size() == 1 ? Component.m_237110_((String)"controlify.command.vibratecontroller.entity.single", (Object[])new Object[]{origin.m_5446_()}) : Component.m_237110_((String)"controlify.command.vibratecontroller.entity.multiple", (Object[])new Object[]{targets.size(), origin.m_5446_()}), true);
        return targets.size();
    }

    private static String formatDouble(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }
}

