/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.server.packets;

import dev.isxander.controlify.platform.network.ControlifyPacketCodec;
import dev.isxander.controlify.rumble.ContinuousRumbleEffect;
import dev.isxander.controlify.rumble.RumbleEffect;
import dev.isxander.controlify.rumble.RumbleSource;
import dev.isxander.controlify.rumble.RumbleState;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.Easings;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public record EntityVibrationPacket(int entityId, float range, int duration, RumbleState state, RumbleSource source) {
    public static final ResourceLocation CHANNEL = CUtil.rl("vibrate_from_entity");
    public static final ControlifyPacketCodec<EntityVibrationPacket> CODEC = ControlifyPacketCodec.of((buf, packet) -> {
        buf.writeInt(packet.entityId());
        buf.writeFloat(packet.range());
        buf.writeInt(packet.duration());
        buf.writeInt(RumbleState.packToInt(packet.state()));
        buf.m_130085_(packet.source().id());
    }, buf -> new EntityVibrationPacket(buf.readInt(), buf.readFloat(), buf.readInt(), RumbleState.unpackFromInt(buf.readInt()), RumbleSource.get(buf.m_130281_())));

    public RumbleEffect createEffect() {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
        return ContinuousRumbleEffect.builder().constant(this.state).inWorld(() -> ((Entity)entity).m_20182_(), 0.0f, 1.0f, this.range, Easings.toFloat(Easings::easeInSine)).timeout(this.duration).build();
    }
}

