/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.virtualmouse;

import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.util.Pair;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.api.vmousesnapping.ISnapBehaviour;
import dev.isxander.controlify.api.vmousesnapping.SnapPoint;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.GamepadInputs;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.touchpad.TouchpadComponent;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.mixins.feature.virtualmouse.KeyboardHandlerAccessor;
import dev.isxander.controlify.mixins.feature.virtualmouse.MouseHandlerAccessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.utils.ToastUtils;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.lwjgl.glfw.GLFW;

public class VirtualMouseHandler {
    private static final ResourceLocation CURSOR_TEXTURE = CUtil.rl("textures/gui/virtual_mouse.png");
    private double targetX;
    private double targetY;
    private double currentX;
    private double currentY;
    private double scrollX;
    private double scrollY;
    private float prevXFinger;
    private float prevYFinger;
    private final Minecraft minecraft;
    private boolean virtualMouseEnabled;
    private Set<SnapPoint> snapPoints;
    private SnapPoint lastSnappedPoint;
    private final HoldRepeatHelper holdRepeatHelper = new HoldRepeatHelper(10, 3);

    public VirtualMouseHandler() {
        this.minecraft = Minecraft.m_91087_();
        this.snapPoints = this.collectSnapPoints();
        ControlifyEvents.INPUT_MODE_CHANGED.register(event -> this.onInputModeChanged(event.mode()));
    }

    public void handleControllerInput(ControllerEntity controller) {
        if (ControlifyBindings.VMOUSE_TOGGLE.on(controller).justPressed()) {
            this.toggleVirtualMouse();
        }
        if (!this.virtualMouseEnabled) {
            return;
        }
        InputComponent input = controller.input().orElseThrow();
        Optional<TouchpadComponent> touchpad = controller.touchpad();
        InputBinding moveRight = ControlifyBindings.VMOUSE_MOVE_RIGHT.on(controller);
        InputBinding moveLeft = ControlifyBindings.VMOUSE_MOVE_LEFT.on(controller);
        InputBinding moveDown = ControlifyBindings.VMOUSE_MOVE_DOWN.on(controller);
        InputBinding moveUp = ControlifyBindings.VMOUSE_MOVE_UP.on(controller);
        Vector2d impulse = ControllerUtils.applyEasingToLength(moveRight.analogueNow() - moveLeft.analogueNow(), moveDown.analogueNow() - moveUp.analogueNow(), x -> Math.pow(x, 3.0));
        Vector2d prevImpulse = ControllerUtils.applyEasingToLength(moveRight.analoguePrev() - moveLeft.analoguePrev(), moveDown.analoguePrev() - moveUp.analoguePrev(), x -> Math.pow(x, 3.0));
        this.snapPoints = this.collectSnapPoints();
        if (impulse.x == 0.0 && impulse.y == 0.0 && (prevImpulse.x != 0.0 || prevImpulse.y != 0.0)) {
            this.snapToClosestPoint();
        }
        float sensitivity = input.config().config().virtualMouseSensitivity;
        if (!((InputComponent.Config)input.confObj()).isLCE) {
            float windowSizeModifier = (float)Math.max(this.minecraft.m_91268_().m_85441_(), this.minecraft.m_91268_().m_85442_()) / 800.0f;
            this.targetX += impulse.x * 20.0 * (double)sensitivity * (double)windowSizeModifier;
            this.targetY += impulse.y * 20.0 * (double)sensitivity * (double)windowSizeModifier;
        } else {
            float windowSizeModifier = (float)this.minecraft.m_91268_().m_85443_() / (float)this.minecraft.m_91268_().m_85445_();
            this.targetX += impulse.x * 10.0 * (double)sensitivity * (double)windowSizeModifier;
            this.targetY += impulse.y * 10.0 * (double)sensitivity * (double)windowSizeModifier;
        }
        this.targetX = Mth.m_14008_((double)this.targetX, (double)0.0, (double)this.minecraft.m_91268_().m_85441_());
        this.targetY = Mth.m_14008_((double)this.targetY, (double)0.0, (double)this.minecraft.m_91268_().m_85442_());
        this.scrollY += (double)(ControlifyBindings.VMOUSE_SCROLL_UP.on(controller).analogueNow() - ControlifyBindings.VMOUSE_SCROLL_DOWN.on(controller).analogueNow());
        if (this.holdRepeatHelper.shouldAction(ControlifyBindings.VMOUSE_SNAP_UP.on(controller))) {
            this.snapInDirection(ScreenDirection.UP);
            this.holdRepeatHelper.onNavigate();
        } else if (this.holdRepeatHelper.shouldAction(ControlifyBindings.VMOUSE_SNAP_DOWN.on(controller))) {
            this.snapInDirection(ScreenDirection.DOWN);
            this.holdRepeatHelper.onNavigate();
        } else if (this.holdRepeatHelper.shouldAction(ControlifyBindings.VMOUSE_SNAP_LEFT.on(controller))) {
            this.snapInDirection(ScreenDirection.LEFT);
            this.holdRepeatHelper.onNavigate();
        } else if (this.holdRepeatHelper.shouldAction(ControlifyBindings.VMOUSE_SNAP_RIGHT.on(controller))) {
            this.snapInDirection(ScreenDirection.RIGHT);
            this.holdRepeatHelper.onNavigate();
        }
        if (ScreenProcessorProvider.provide(this.minecraft.f_91080_).virtualMouseBehaviour().isDefaultOr(VirtualMouseBehaviour.ENABLED)) {
            this.handleCompatibilityBinds(controller);
        }
        if (ControlifyBindings.GUI_BACK.on(controller).justPressed() && this.minecraft.f_91080_ != null) {
            ScreenProcessor.playClackSound();
            this.minecraft.f_91080_.m_7379_();
        }
    }

    public void handleCompatibilityBinds(ControllerEntity controller) {
        MouseHandlerAccessor mouseHandler = (MouseHandlerAccessor)this.minecraft.f_91067_;
        KeyboardHandlerAccessor keyboardHandler = (KeyboardHandlerAccessor)this.minecraft.f_91068_;
        InputComponent input = controller.input().orElseThrow();
        boolean touchpadPressed = input.stateNow().isButtonDown(GamepadInputs.TOUCHPAD_1_BUTTON);
        boolean prevTouchpadPressed = input.stateThen().isButtonDown(GamepadInputs.TOUCHPAD_1_BUTTON);
        if (ControlifyBindings.VMOUSE_LCLICK.on(controller).justPressed() || touchpadPressed && !prevTouchpadPressed) {
            mouseHandler.invokeOnPress(this.minecraft.m_91268_().m_85439_(), 0, 1, 0);
        } else if (ControlifyBindings.VMOUSE_LCLICK.on(controller).justReleased() || !touchpadPressed && prevTouchpadPressed) {
            mouseHandler.invokeOnPress(this.minecraft.m_91268_().m_85439_(), 0, 0, 0);
        }
        if (ControlifyBindings.VMOUSE_RCLICK.on(controller).justPressed() || touchpadPressed && !prevTouchpadPressed) {
            mouseHandler.invokeOnPress(this.minecraft.m_91268_().m_85439_(), 1, 1, 0);
        } else if (ControlifyBindings.VMOUSE_RCLICK.on(controller).justReleased() || !touchpadPressed && prevTouchpadPressed) {
            mouseHandler.invokeOnPress(this.minecraft.m_91268_().m_85439_(), 1, 0, 0);
        }
        if (ControlifyBindings.VMOUSE_SHIFT_CLICK.on(controller).justPressed()) {
            mouseHandler.invokeOnPress(this.minecraft.m_91268_().m_85439_(), 0, 1, 0);
        } else if (ControlifyBindings.VMOUSE_SHIFT_CLICK.on(controller).justReleased()) {
            mouseHandler.invokeOnPress(this.minecraft.m_91268_().m_85439_(), 0, 0, 0);
        }
    }

    public void updateMouse() {
        if (!this.virtualMouseEnabled) {
            return;
        }
        float delta = this.minecraft.m_91297_();
        if ((double)Math.round(this.targetX * 100.0) / 100.0 != (double)Math.round(this.currentX * 100.0) / 100.0 || (double)Math.round(this.targetY * 100.0) / 100.0 != (double)Math.round(this.currentY * 100.0) / 100.0) {
            this.currentX = Mth.m_14139_((double)delta, (double)this.currentX, (double)this.targetX);
            this.currentY = Mth.m_14139_((double)delta, (double)this.currentY, (double)this.targetY);
            ((MouseHandlerAccessor)this.minecraft.f_91067_).invokeOnMove(this.minecraft.m_91268_().m_85439_(), this.currentX, this.currentY);
        } else {
            this.currentX = this.targetX;
            this.currentY = this.targetY;
        }
        if (Math.abs(this.scrollX) >= 0.01 || Math.abs(this.scrollY) >= 0.01) {
            double currentScrollY = this.scrollY * (double)delta;
            this.scrollY -= currentScrollY;
            double currentScrollX = this.scrollX * (double)delta;
            this.scrollX -= currentScrollX;
            ((MouseHandlerAccessor)this.minecraft.f_91067_).invokeOnScroll(this.minecraft.m_91268_().m_85439_(), currentScrollX, currentScrollY);
        } else {
            this.scrollY = 0.0;
            this.scrollX = 0.0;
        }
    }

    public void snapToClosestPoint() {
        SnapPoint closestSnapPoint;
        Window window = this.minecraft.m_91268_();
        Vector2d scaleFactor = new Vector2d((double)window.m_85445_() / (double)window.m_85443_(), (double)window.m_85446_() / (double)window.m_85444_());
        Vector2d target = new Vector2d(this.targetX, this.targetY).mul((Vector2dc)scaleFactor);
        if (this.lastSnappedPoint != null && this.lastSnappedPoint.position().distanceSquared((Vector2ic)new Vector2i((Vector2dc)target, 2)) > (long)this.lastSnappedPoint.range() * (long)this.lastSnappedPoint.range()) {
            this.lastSnappedPoint = null;
        }
        if ((closestSnapPoint = (SnapPoint)this.snapPoints.stream().filter(snapPoint -> !snapPoint.equals(this.lastSnappedPoint)).map(snapPoint -> new Pair(snapPoint, (Object)snapPoint.position().distanceSquared((Vector2ic)new Vector2i((Vector2dc)target, 2)))).filter(point -> (Long)point.getSecond() <= (long)((SnapPoint)point.getFirst()).range() * (long)((SnapPoint)point.getFirst()).range()).min(Comparator.comparingLong(Pair::getSecond)).orElse(new Pair(null, (Object)Long.MAX_VALUE)).getFirst()) != null) {
            this.snapToPoint(closestSnapPoint, (Vector2dc)scaleFactor);
        }
    }

    public void snapInDirection(ScreenDirection direction) {
        Window window = this.minecraft.m_91268_();
        Vector2d scaleFactor = new Vector2d((double)window.m_85445_() / (double)window.m_85443_(), (double)window.m_85446_() / (double)window.m_85444_());
        Vector2d target = new Vector2d(this.targetX, this.targetY).mul((Vector2dc)scaleFactor);
        Optional<SnapPoint> closestSnapPoint = VirtualMouseHandler.findOrthogonalSnapPoint(this.lastSnappedPoint, direction, target, this.snapPoints).or(() -> {
            Vector2d orthogonalTarget = new Vector2d((Vector2dc)target);
            switch (direction) {
                case UP: {
                    orthogonalTarget.y = window.m_85446_();
                    break;
                }
                case DOWN: {
                    orthogonalTarget.y = 0.0;
                    break;
                }
                case LEFT: {
                    orthogonalTarget.x = window.m_85445_();
                    break;
                }
                case RIGHT: {
                    orthogonalTarget.x = 0.0;
                }
            }
            return VirtualMouseHandler.findOrthogonalSnapPoint(this.lastSnappedPoint, direction, orthogonalTarget, this.snapPoints);
        });
        closestSnapPoint.ifPresent(snapPoint -> this.snapToPoint((SnapPoint)snapPoint, (Vector2dc)scaleFactor));
    }

    private static Optional<SnapPoint> findOrthogonalSnapPoint(SnapPoint from, ScreenDirection direction, Vector2d target, Collection<SnapPoint> snapPoints) {
        return snapPoints.stream().filter(snapPoint -> !snapPoint.equals(from)).map(snapPoint -> new Pair(snapPoint, (Object)new Vector2d((double)snapPoint.position().x() - target.x(), (double)snapPoint.position().y() - target.y()))).filter(pair -> {
            Vector2d dist = (Vector2d)pair.getSecond();
            double axis = direction.m_264093_() == ScreenAxis.HORIZONTAL ? dist.x : dist.y;
            double positive = direction.m_264119_() ? 1.0 : -1.0;
            return axis * positive > 0.0;
        }).filter(pair -> {
            SnapPoint snapPoint = (SnapPoint)pair.getFirst();
            Vector2d dist = (Vector2d)pair.getSecond();
            double distance = Math.abs(direction.m_264093_() == ScreenAxis.HORIZONTAL ? dist.x : dist.y);
            double deviation = Math.abs(direction.m_264093_() == ScreenAxis.HORIZONTAL ? dist.y : dist.x);
            ((Vector2d)pair.getSecond()).set(distance, deviation * 4.0);
            return distance >= (double)snapPoint.range() && deviation < distance * 2.0;
        }).min(Comparator.comparingDouble(pair -> {
            Vector2d distDev = (Vector2d)pair.getSecond();
            return distDev.x + distDev.y;
        })).map(Pair::getFirst);
    }

    public void snapToPoint(SnapPoint snapPoint, Vector2dc scaleFactor) {
        this.lastSnappedPoint = snapPoint;
        this.targetX = this.currentX = (double)snapPoint.position().x() / scaleFactor.x();
        this.targetY = this.currentY = (double)snapPoint.position().y() / scaleFactor.y();
        ((MouseHandlerAccessor)this.minecraft.f_91067_).invokeOnMove(this.minecraft.m_91268_().m_85439_(), this.currentX, this.currentY);
    }

    public void onScreenChanged() {
        if (this.minecraft.f_91080_ != null) {
            if (this.requiresVirtualMouse()) {
                this.enableVirtualMouse();
            } else {
                this.disableVirtualMouse();
            }
            if (Controlify.instance().currentInputMode().isController()) {
                GLFW.glfwSetInputMode((long)this.minecraft.m_91268_().m_85439_(), (int)208897, (int)212994);
            }
        } else if (this.virtualMouseEnabled) {
            this.disableVirtualMouse();
            this.minecraft.f_91067_.m_91601_();
        }
    }

    public void onInputModeChanged(InputMode mode) {
        if (mode.isController()) {
            if (this.requiresVirtualMouse()) {
                this.enableVirtualMouse();
            }
        } else if (this.virtualMouseEnabled) {
            this.disableVirtualMouse();
        }
    }

    public void renderVirtualMouse(GuiGraphics graphics) {
        if (!this.virtualMouseEnabled) {
            return;
        }
        if (DebugProperties.DEBUG_SNAPPING) {
            for (SnapPoint snapPoint : this.snapPoints) {
                graphics.m_280509_(snapPoint.position().x() - snapPoint.range(), snapPoint.position().y() - snapPoint.range(), snapPoint.position().x() + snapPoint.range(), snapPoint.position().y() + snapPoint.range(), 0x33FFFFFF);
                graphics.m_280509_(snapPoint.position().x() - 1, snapPoint.position().y() - 1, snapPoint.position().x() + 1, snapPoint.position().y() + 1, snapPoint.equals(this.lastSnappedPoint) ? -256 : -65536);
            }
        }
        double scaledX = this.currentX * (double)this.minecraft.m_91268_().m_85445_() / (double)this.minecraft.m_91268_().m_85443_();
        double scaledY = this.currentY * (double)this.minecraft.m_91268_().m_85446_() / (double)this.minecraft.m_91268_().m_85444_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(scaledX, scaledY, 1000.0);
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        Blit.blitTex(graphics, CURSOR_TEXTURE, -16, -16, 0, 0, 32, 32, 32, 32);
        graphics.m_280168_().m_85849_();
    }

    public void enableVirtualMouse() {
        if (this.virtualMouseEnabled) {
            return;
        }
        GLFW.glfwSetInputMode((long)this.minecraft.m_91268_().m_85439_(), (int)208897, (int)212995);
        this.virtualMouseEnabled = true;
        if (this.minecraft.f_91067_.m_91589_() == -50.0 && this.minecraft.f_91067_.m_91594_() == -50.0) {
            this.targetX = this.currentX = (double)((float)this.minecraft.m_91268_().m_85443_() / 2.0f);
            this.targetY = this.currentY = (double)((float)this.minecraft.m_91268_().m_85444_() / 2.0f);
        } else {
            this.targetX = this.currentX = this.minecraft.f_91067_.m_91589_();
            this.targetY = this.currentY = this.minecraft.f_91067_.m_91594_();
        }
        this.setMousePosition();
        ControlifyEvents.VIRTUAL_MOUSE_TOGGLED.invoke(new ControlifyEvents.VirtualMouseToggled(true));
        if (this.minecraft.f_91080_ != null) {
            ScreenProcessorProvider.provide(this.minecraft.f_91080_).onVirtualMouseToggled(true);
        }
    }

    public void disableVirtualMouse() {
        if (!this.virtualMouseEnabled) {
            return;
        }
        ((MouseHandlerAccessor)this.minecraft.f_91067_).setMouseGrabbed(false);
        Controlify.instance().hideMouse(true, true);
        GLFW.glfwSetInputMode((long)this.minecraft.m_91268_().m_85439_(), (int)208897, (int)212993);
        this.setMousePosition();
        this.virtualMouseEnabled = false;
        this.targetX = this.currentX = this.minecraft.f_91067_.m_91589_();
        this.targetY = this.currentY = this.minecraft.f_91067_.m_91594_();
        ControlifyEvents.VIRTUAL_MOUSE_TOGGLED.invoke(new ControlifyEvents.VirtualMouseToggled(false));
        if (this.minecraft.f_91080_ != null) {
            ScreenProcessorProvider.provide(this.minecraft.f_91080_).onVirtualMouseToggled(false);
        }
    }

    private void setMousePosition() {
        GLFW.glfwSetCursorPos((long)this.minecraft.m_91268_().m_85439_(), (double)this.targetX, (double)this.targetY);
    }

    public boolean requiresVirtualMouse() {
        boolean hasScreen;
        boolean isController = Controlify.instance().currentInputMode().isController();
        boolean bl = hasScreen = this.minecraft.f_91080_ != null;
        if (isController && hasScreen) {
            return switch (ScreenProcessorProvider.provide(this.minecraft.f_91080_).virtualMouseBehaviour()) {
                default -> throw new IncompatibleClassChangeError();
                case VirtualMouseBehaviour.DEFAULT -> Controlify.instance().config().globalSettings().virtualMouseScreens.stream().anyMatch(s -> s.isAssignableFrom(this.minecraft.f_91080_.getClass()));
                case VirtualMouseBehaviour.ENABLED, VirtualMouseBehaviour.CURSOR_ONLY -> true;
                case VirtualMouseBehaviour.DISABLED -> false;
            };
        }
        return false;
    }

    public void toggleVirtualMouse() {
        if (this.minecraft.f_91080_ == null) {
            return;
        }
        if (ScreenProcessorProvider.provide(this.minecraft.f_91080_).virtualMouseBehaviour() != VirtualMouseBehaviour.DEFAULT) {
            ToastUtils.sendToast((Component)Component.m_237115_((String)"controlify.toast.vmouse_unavailable.title"), (Component)Component.m_237115_((String)"controlify.toast.vmouse_unavailable.description"), false);
            return;
        }
        List<Class<?>> screens = Controlify.instance().config().globalSettings().virtualMouseScreens;
        Class<?> screenClass = this.minecraft.f_91080_.getClass();
        if (screens.contains(screenClass)) {
            screens.remove(screenClass);
            this.disableVirtualMouse();
            Controlify.instance().hideMouse(true, false);
            ToastUtils.sendToast((Component)Component.m_237115_((String)"controlify.toast.vmouse_disabled.title"), (Component)Component.m_237115_((String)"controlify.toast.vmouse_disabled.description"), false);
        } else {
            screens.add(screenClass);
            this.enableVirtualMouse();
            ToastUtils.sendToast((Component)Component.m_237115_((String)"controlify.toast.vmouse_enabled.title"), (Component)Component.m_237115_((String)"controlify.toast.vmouse_enabled.description"), false);
        }
        Controlify.instance().config().save();
    }

    public boolean isVirtualMouseEnabled() {
        return this.virtualMouseEnabled;
    }

    public int getCurrentX(float deltaTime) {
        return (int)Mth.m_14139_((double)deltaTime, (double)this.currentX, (double)this.targetX);
    }

    public int getCurrentY(float deltaTime) {
        return (int)Mth.m_14139_((double)deltaTime, (double)this.currentY, (double)this.targetY);
    }

    public void preventScrollingThisTick() {
        this.scrollX = 0.0;
        this.scrollY = 0.0;
    }

    private Set<SnapPoint> collectSnapPoints() {
        Screen screen = this.minecraft.f_91080_;
        if (screen instanceof ISnapBehaviour) {
            ISnapBehaviour snapBehaviour = (ISnapBehaviour)screen;
            HashSet<SnapPoint> points = new HashSet<SnapPoint>();
            snapBehaviour.controlify$collectSnapPoints(points::add);
            return points;
        }
        return Set.of();
    }
}

