package dev.isxander.controlify.config;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import dev.isxander.controlify.driver.steamdeck.SteamDeckUtil;
import dev.isxander.controlify.reacharound.ReachAroundMode;
import dev.isxander.controlify.server.ServerPolicies;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ServerData;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GlobalSettings {
    public static final GlobalSettings DEFAULT = new GlobalSettings();

    public List<Class<?>> virtualMouseScreens = Lists.newArrayList(
            AbstractContainerScreen.class
            //? if april-fools-25
            /*,net.minecraft.client.gui.screens.unlocks.PlayerUnlocksScreen.class*/
    );

    @SerializedName("keyboardMovement") public boolean alwaysKeyboardMovement = false;
    public List<String> keyboardMovementWhitelist = new ArrayList<>();
    public boolean outOfFocusInput = false;
    public boolean loadVibrationNatives = false;
    public String customVibrationNativesPath = "";
    public boolean vibrationOnboarded = false;
    public ReachAroundMode reachAround = ReachAroundMode.OFF;
    public boolean allowServerRumble = true;
    public boolean uiSounds = false;
    public boolean notifyLowBattery = true;
    public boolean quietMode = false;
    public float ingameButtonGuideScale = 1f;
    public boolean useEnhancedSteamDeckDriver = true;

    public Set<String> seenServers = new HashSet<>();

    public boolean shouldUseKeyboardMovement() {
        ServerData server = Minecraft.getInstance().getCurrentServer();
        return alwaysKeyboardMovement
               || (server != null && keyboardMovementWhitelist.stream().anyMatch(server.ip::endsWith))
               || ServerPolicies.KEYBOARD_LIKE_MOVEMENT.get();
    }

    // Quiet mode does not work on Steam Deck
    public boolean isQuietMode() {
        return this.quietMode && !SteamDeckUtil.DECK_MODE.isSteamDeck();
    }
}
