/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify;

import com.mojang.blaze3d.Blaze3D;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.ControlifyBindApiImpl;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.bindings.defaults.DefaultBindManager;
import dev.isxander.controlify.compatibility.ControlifyCompat;
import dev.isxander.controlify.config.ControlifyConfig;
import dev.isxander.controlify.config.GlobalSettings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.id.ControllerTypeManager;
import dev.isxander.controlify.controller.input.ControllerState;
import dev.isxander.controlify.controller.input.ControllerStateView;
import dev.isxander.controlify.controller.input.HatState;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.controller.misc.BluetoothDeviceComponent;
import dev.isxander.controlify.controller.rumble.RumbleComponent;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.controllermanager.GLFWControllerManager;
import dev.isxander.controlify.controllermanager.SDLControllerManager;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.driver.sdl.SDL3NativesManager;
import dev.isxander.controlify.driver.steamdeck.SteamDeckMode;
import dev.isxander.controlify.driver.steamdeck.SteamDeckUtil;
import dev.isxander.controlify.font.InputFontMapper;
import dev.isxander.controlify.gui.guide.InGameButtonGuide;
import dev.isxander.controlify.gui.screen.AskToMapControllerScreen;
import dev.isxander.controlify.gui.screen.BluetoothWarningScreen;
import dev.isxander.controlify.gui.screen.ControllerCalibrationScreen;
import dev.isxander.controlify.gui.screen.ControllerCarouselScreen;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.gui.screen.NoSDLScreen;
import dev.isxander.controlify.gui.screen.SDLOnboardingScreen;
import dev.isxander.controlify.gui.screen.SteamDeckAlerts;
import dev.isxander.controlify.gui.screen.SubmitUnknownControllerScreen;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.ingame.ControllerPlayerMovement;
import dev.isxander.controlify.ingame.InGameInputHandler;
import dev.isxander.controlify.mixins.feature.virtualmouse.MouseHandlerAccessor;
import dev.isxander.controlify.platform.client.PlatformClientUtil;
import dev.isxander.controlify.platform.client.events.TickEvent;
import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.platform.network.SidedNetworkApi;
import dev.isxander.controlify.rumble.RumbleManager;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.server.ControlifyHandshake;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.server.ServerPolicy;
import dev.isxander.controlify.server.packets.EntityVibrationPacket;
import dev.isxander.controlify.server.packets.OriginVibrationPacket;
import dev.isxander.controlify.server.packets.ServerPolicyPacket;
import dev.isxander.controlify.server.packets.VibrationPacket;
import dev.isxander.controlify.sound.ControlifyClientSounds;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ControllerSetupWizard;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.DebugDump;
import dev.isxander.controlify.utils.DebugLog;
import dev.isxander.controlify.utils.InitialScreenRegistryDuck;
import dev.isxander.controlify.utils.ToastUtils;
import dev.isxander.controlify.utils.UnhandledCompletableFutures;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import dev.isxander.controlify.wireless.LowBatteryNotifier;
import dev.isxander.yacl3.gui.YACLScreen;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.MixinEnvironment;

public class Controlify
implements ControlifyApi {
    private static Controlify instance = null;
    private Minecraft minecraft = null;
    private ControllerManager controllerManager;
    private boolean finishedInit = false;
    private boolean probeMode = false;
    private ControllerEntity currentController = null;
    private InputMode currentInputMode = InputMode.KEYBOARD_MOUSE;
    private InGameInputHandler inGameInputHandler;
    public InGameButtonGuide inGameButtonGuide;
    private VirtualMouseHandler virtualMouseHandler;
    private InputFontMapper inputFontMapper;
    private DefaultBindManager defaultBindManager;
    private ControllerTypeManager controllerTypeManager;
    private Set<BindContext> thisTickContexts;
    private ControllerHIDService controllerHIDService;
    private CompletableFuture<Boolean> nativeOnboardingFuture = null;
    private final ControlifyConfig config = new ControlifyConfig(this);
    private final Queue<ControllerSetupWizard> setupWizards = new ArrayDeque<ControllerSetupWizard>();
    private ControllerSetupWizard currentSetupWizard = null;
    private boolean hasDiscoveredControllers = false;
    private int consecutiveInputSwitches = 0;
    private double lastInputSwitchTime = 0.0;
    private int showMouseTicks = 0;

    public void preInitialiseControlify() {
        DebugProperties.printProperties();
        CUtil.LOGGER.log("Pre-initializing Controlify...");
        if (DebugProperties.MIXIN_AUDIT) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
        this.inputFontMapper = new InputFontMapper();
        this.defaultBindManager = new DefaultBindManager();
        this.controllerTypeManager = new ControllerTypeManager();
        PlatformClientUtil.registerAssetReloadListener(this.inputFontMapper);
        PlatformClientUtil.registerAssetReloadListener(this.defaultBindManager);
        PlatformClientUtil.registerAssetReloadListener(this.controllerTypeManager);
        this.controllerHIDService = new ControllerHIDService();
        this.controllerHIDService.start();
        this.registerBuiltinPack("legacy_console");
        ControlifyClientSounds.init();
        ControlifyHandshake.setupOnClient();
        SidedNetworkApi.S2C().listenForPacket(VibrationPacket.CHANNEL, packet -> {
            if (this.config().globalSettings().allowServerRumble) {
                this.getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> rumble.rumbleManager().play(packet.source(), packet.createEffect()));
            }
        });
        SidedNetworkApi.S2C().listenForPacket(OriginVibrationPacket.CHANNEL, packet -> {
            if (this.config().globalSettings().allowServerRumble) {
                this.getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> rumble.rumbleManager().play(packet.source(), packet.createEffect()));
            }
        });
        SidedNetworkApi.S2C().listenForPacket(EntityVibrationPacket.CHANNEL, packet -> {
            if (this.config().globalSettings().allowServerRumble) {
                this.getCurrentController().flatMap(ControllerEntity::rumble).ifPresent(rumble -> rumble.rumbleManager().play(packet.source(), packet.createEffect()));
            }
        });
        SidedNetworkApi.S2C().listenForPacket(ServerPolicyPacket.CHANNEL, packet -> {
            CUtil.LOGGER.log("Connected server specified '{}' policy is {}.", packet.id(), packet.allowed() ? "ALLOWED" : "DISALLOWED");
            ServerPolicies.getById(packet.id()).set(ServerPolicy.fromBoolean(packet.allowed()));
        });
        PlatformClientUtil.registerClientDisconnected(client -> {
            DebugLog.log("Disconnected from server, resetting server policies", new Object[0]);
            ServerPolicies.unsetAll();
        });
        PlatformClientUtil.addHudLayer(CUtil.rl("button_guide"), (graphics, tickDelta) -> this.inGameButtonGuide().ifPresent(guide -> guide.renderHud(graphics, tickDelta)));
        PlatformMainUtil.applyToControlifyEntrypoint(entrypoint -> {
            try {
                entrypoint.onControlifyPreInit(new PreInitContext(){});
            }
            catch (Throwable e) {
                CUtil.LOGGER.error("Failed to run `onControlifyPreInit` on Controlify entrypoint: {}", entrypoint.getClass().getName(), e);
            }
        });
    }

    private void registerBuiltinPack(String id) {
        PlatformClientUtil.registerBuiltinResourcePack(CUtil.rl(id), (Component)Component.m_237115_((String)("controlify.extra_pack." + id + ".name")));
    }

    public void initializeControlify() {
        CUtil.LOGGER.log("Initializing Controlify...");
        this.minecraft = Minecraft.m_91087_();
        this.inGameInputHandler = null;
        this.virtualMouseHandler = new VirtualMouseHandler();
        this.config().load();
        ControlifyEvents.CONTROLLER_CONNECTED.register(event -> this.onControllerAdded(event.controller(), event.hotplugged(), event.newController()));
        ControlifyEvents.CONTROLLER_DISCONNECTED.register(event -> this.onControllerRemoved(event.controller()));
        ControlifyBindings.registerModdedBindings();
        PlatformClientUtil.registerPostScreenRender((screen, graphics, mouseX, mouseY, tickDelta) -> ControlifyApi.get().getCurrentController().ifPresent(controller -> {
            this.virtualMouseHandler().renderVirtualMouse(graphics);
            ScreenProcessorProvider.provide(screen).render((ControllerEntity)controller, graphics, tickDelta);
        }));
        if (this.config().globalSettings().isQuietMode()) {
            boolean controllersConnected = GLFWControllerManager.areControllersConnected();
            if (controllersConnected) {
                ToastUtils.sendToast((Component)Component.m_237115_((String)"controlify.toast.setup_in_config.title"), (Component)Component.m_237110_((String)"controlify.toast.setup_in_config.description", (Object[])new Object[]{Component.m_237115_((String)"options.title"), Component.m_237115_((String)"controls.title"), Component.m_237113_((String)"Controlify")}), false);
            } else {
                this.probeMode = true;
                PlatformClientUtil.registerClientTickEnded(TickEvent.interval(20, client -> this.probeTick()));
            }
        } else {
            this.finishControlifyInit();
        }
        PlatformClientUtil.registerClientStopping(client -> this.controllerHIDService().stop());
        if (this.config().globalSettings().useEnhancedSteamDeckDriver) {
            this.doSteamDeckChecks();
        }
        PlatformMainUtil.applyToControlifyEntrypoint(entrypoint -> {
            try {
                entrypoint.onControlifyInit(new InitContext(){

                    @Override
                    public ControlifyBindApi bindings() {
                        return ControlifyBindApiImpl.INSTANCE;
                    }

                    @Override
                    public ControlifyApi controlify() {
                        return Controlify.this;
                    }
                });
            }
            catch (Throwable e) {
                CUtil.LOGGER.error("Failed to run `onControlifyInit` on Controlify entrypoint: {}", entrypoint.getClass().getName(), e);
            }
        });
    }

    private void doSteamDeckChecks() {
        CUtil.LOGGER.log("Steam Deck state: {}", new Object[]{SteamDeckUtil.DECK_MODE});
        if (!SteamDeckUtil.IS_STEAM_DECK) {
            return;
        }
        boolean connectedToCef = SteamDeckUtil.getDeckInstance().isPresent();
        if (!connectedToCef) {
            CUtil.LOGGER.error("Controlify could not connect to CEF debugger instance. Decky is probably not installed.");
            InitialScreenRegistryDuck.registerInitialScreen(SteamDeckAlerts::createDeckyRequiredWarning);
        }
        if (SteamDeckUtil.DECK_MODE == SteamDeckMode.DESKTOP_MODE) {
            CUtil.LOGGER.warn("Controlify is running in SteamOS desktop mode.");
            InitialScreenRegistryDuck.registerInitialScreen(SteamDeckAlerts::createDesktopModeWarning);
        }
        if (connectedToCef && SteamDeckUtil.DECK_MODE == SteamDeckMode.GAMING_MODE) {
            CUtil.LOGGER.log("Steam Deck is in gaming mode and Controlify has successfully connected to CEF.");
        }
    }

    public void discoverControllers() {
        if (this.hasDiscoveredControllers) {
            CUtil.LOGGER.warn("Attempted to discover controllers twice!");
            return;
        }
        this.hasDiscoveredControllers = true;
        DebugLog.log("Discovering and initializing controllers...", new Object[0]);
        this.controllerManager.discoverControllers();
        if (this.controllerManager.getConnectedControllers().isEmpty()) {
            CUtil.LOGGER.log("No controllers found.");
        }
        if (this.getCurrentController().isEmpty()) {
            if (this.config().currentControllerUid() == null) {
                Optional preferredController = this.controllerManager.getConnectedControllers().stream().findAny();
                this.setCurrentController(preferredController.orElse(null), false);
            } else {
                Optional<ControllerEntity> preferredController = this.controllerManager.getConnectedControllers().stream().filter(c -> c.uid().equals(this.config().currentControllerUid())).findAny();
                this.setCurrentController(preferredController.orElse(null), false);
            }
        }
        this.config().saveIfDirty();
        PlatformMainUtil.applyToControlifyEntrypoint(entrypoint -> {
            try {
                entrypoint.onControllersDiscovered(this);
            }
            catch (Throwable e) {
                CUtil.LOGGER.error("Failed to run `onControllersDiscovered` on Controlify entrypoint: {}", entrypoint.getClass().getName(), e);
            }
        });
    }

    public CompletableFuture<Void> finishControlifyInit() {
        if (this.finishedInit) {
            return CompletableFuture.completedFuture(null);
        }
        this.probeMode = false;
        this.finishedInit = true;
        return ((CompletableFuture)this.askNatives().whenComplete((loaded, th) -> UnhandledCompletableFutures.run(() -> {
            CUtil.LOGGER.log("Finishing Controlify init...");
            if (!loaded.booleanValue()) {
                CUtil.LOGGER.warn("CONTROLIFY DID NOT LOAD SDL3 NATIVES. MANY FEATURES DISABLED!");
            }
            try {
                this.controllerManager = loaded != false ? new SDLControllerManager(CUtil.LOGGER) : new GLFWControllerManager(CUtil.LOGGER);
            }
            catch (Throwable throwable) {
                CUtil.LOGGER.error("Failed to initialize controller manager", throwable);
                return;
            }
            PlatformClientUtil.registerClientTickStarted(this::tick);
            ControlifyCompat.init();
            ControlifyBindApiImpl.INSTANCE.lock();
            if (this.config().globalSettings().isQuietMode()) {
                this.config().globalSettings().quietMode = false;
                this.config().setDirty();
            }
            this.discoverControllers();
            if (DebugProperties.INIT_DUMP) {
                CUtil.LOGGER.log("\n{}", DebugDump.dumpDebug());
            }
        }, this.minecraft))).thenApply(t -> null);
    }

    private void onControllerAdded(ControllerEntity controller, boolean hotplugged, boolean newController) {
        Screen screen;
        boolean calibrated;
        ControllerSetupWizard wizard = new ControllerSetupWizard();
        wizard.addStage(() -> SubmitUnknownControllerScreen.canSubmit(controller), nextScreen -> new SubmitUnknownControllerScreen(controller, nextScreen));
        boolean bl = calibrated = controller.input().map(input -> input.config().config().deadzonesCalibrated).orElse(false) != false || controller.gyro().map(gyro -> gyro.config().config().calibrated).orElse(false) != false;
        if (hotplugged && this.getCurrentController().isEmpty() && (this.config().currentControllerUid() == null || controller.uid().equals(this.config().currentControllerUid()))) {
            this.setCurrentController(controller, true);
        }
        wizard.addStage(() -> {
            Optional<InputComponent> inputOpt = controller.input();
            if (inputOpt.isPresent()) {
                InputComponent input = inputOpt.get();
                return !input.isDefinitelyGamepad() && ((InputComponent.Config)input.confObj()).mapping == null;
            }
            return false;
        }, nextScreen -> new AskToMapControllerScreen(controller, nextScreen));
        wizard.addStage(() -> !calibrated, nextScreen -> new ControllerCalibrationScreen(controller, nextScreen));
        wizard.addStage(() -> controller.dualSense().isPresent() && controller.bluetooth().map(bt -> !((BluetoothDeviceComponent.Config)bt.confObj()).dontShowWarningAgain).orElse(false) != false, nextScreen -> new BluetoothWarningScreen(controller.bluetooth().orElseThrow(), nextScreen));
        if (hotplugged) {
            ToastUtils.sendToast((Component)Component.m_237115_((String)"controlify.toast.controller_connected.title"), (Component)Component.m_237110_((String)"controlify.toast.controller_connected.description", (Object[])new Object[]{controller.name()}), false);
        }
        if ((screen = this.minecraft.f_91080_) instanceof ControllerCarouselScreen) {
            ControllerCarouselScreen controllerListScreen = (ControllerCarouselScreen)screen;
            controllerListScreen.refreshControllers();
        }
        if (hotplugged) {
            this.config().saveIfDirty();
        }
        this.setupWizards.add(wizard);
    }

    private void onControllerRemoved(ControllerEntity controller) {
        if (this.getCurrentController().isPresent() && this.getCurrentController().get().equals(controller)) {
            this.setCurrentController(null, true);
            this.setInputMode(InputMode.KEYBOARD_MOUSE);
        }
        ToastUtils.sendToast((Component)Component.m_237115_((String)"controlify.toast.controller_disconnected.title"), (Component)Component.m_237110_((String)"controlify.toast.controller_disconnected.description", (Object[])new Object[]{controller.name()}), false);
    }

    public CompletableFuture<Boolean> askNatives() {
        if (this.nativeOnboardingFuture != null) {
            return this.nativeOnboardingFuture;
        }
        GlobalSettings settings = this.config().globalSettings();
        if ((!settings.vibrationOnboarded || settings.loadVibrationNatives) && SDL3NativesManager.tryOfflineLoadAndStart()) {
            settings.vibrationOnboarded = true;
            settings.loadVibrationNatives = true;
            this.config().setDirty();
            this.nativeOnboardingFuture = CompletableFuture.completedFuture(true);
            return this.nativeOnboardingFuture;
        }
        if (!SDL3NativesManager.isSupportedOnThisPlatform()) {
            CUtil.LOGGER.warn("SDL is not supported on this platform. Platform: {}", SDL3NativesManager.Target.CURRENT);
            this.nativeOnboardingFuture = new CompletableFuture();
            this.minecraft.m_91152_((Screen)new NoSDLScreen(() -> this.nativeOnboardingFuture.complete(false), this.minecraft.f_91080_));
            return this.nativeOnboardingFuture;
        }
        if (this.config().globalSettings().vibrationOnboarded) {
            if (this.config().globalSettings().loadVibrationNatives) {
                this.nativeOnboardingFuture = SDL3NativesManager.maybeLoad();
                return this.nativeOnboardingFuture;
            }
            this.nativeOnboardingFuture = CompletableFuture.completedFuture(false);
            return this.nativeOnboardingFuture;
        }
        this.nativeOnboardingFuture = new CompletableFuture();
        InitialScreenRegistryDuck.registerInitialScreen(runnable -> new SDLOnboardingScreen((Runnable)runnable, answer -> {
            if (answer) {
                SDL3NativesManager.maybeLoad().whenComplete((loaded, th) -> {
                    if (th != null) {
                        this.nativeOnboardingFuture.completeExceptionally((Throwable)th);
                    } else {
                        this.nativeOnboardingFuture.complete((Boolean)loaded);
                    }
                });
            } else {
                this.nativeOnboardingFuture.complete(false);
            }
        }));
        return this.nativeOnboardingFuture;
    }

    public void tick(Minecraft client) {
        if (this.minecraft.m_91265_() == null) {
            if (this.currentSetupWizard != null && this.currentSetupWizard.isDone()) {
                this.currentSetupWizard = null;
            }
            if (!this.setupWizards.isEmpty() && !(this.minecraft.f_91080_ instanceof DontInteruptScreen)) {
                this.currentSetupWizard = this.setupWizards.poll();
                this.minecraft.m_91152_(this.currentSetupWizard.start(this.minecraft.f_91080_));
            }
        }
        boolean outOfFocus = !this.config().globalSettings().outOfFocusInput && !client.m_91302_();
        this.thisTickContexts = BindContext.REGISTRY.m_123024_().filter(ctx -> ctx.isApplicable().apply(this.minecraft)).collect(Collectors.toUnmodifiableSet());
        this.controllerManager.tick(outOfFocus);
        if (this.minecraft.f_91067_.m_91600_()) {
            this.showMouseTicks = 0;
        }
        if (this.currentInputMode() == InputMode.MIXED && this.showMouseTicks > 0) {
            --this.showMouseTicks;
            if (this.showMouseTicks == 0) {
                this.hideMouse(true, false);
                if (this.virtualMouseHandler().requiresVirtualMouse()) {
                    this.virtualMouseHandler().enableVirtualMouse();
                }
            }
        }
        LowBatteryNotifier.tick();
        this.getCurrentController().ifPresent(currentController -> ControllerUtils.wrapControllerError(() -> this.tickController((ControllerEntity)currentController, outOfFocus), "Ticking current controller", currentController));
    }

    /*
     * Unable to fully structure code
     */
    private void tickController(ControllerEntity controller, boolean outOfFocus) {
        input = controller.input().orElseThrow();
        state = input.stateNow();
        rumbleManager = controller.rumble().map((Function<RumbleComponent, RumbleManager>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, rumbleManager(), (Ldev/isxander/controlify/controller/rumble/RumbleComponent;)Ldev/isxander/controlify/rumble/RumbleManager;)());
        isPaused = this.minecraft.m_91104_() != false || this.minecraft.f_91080_ instanceof PauseScreen != false;
        isConfigScreen = this.minecraft.f_91080_ instanceof YACLScreen;
        rumbleManager.ifPresent((Consumer<RumbleManager>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$tickController$41(boolean boolean boolean dev.isxander.controlify.rumble.RumbleManager ), (Ldev/isxander/controlify/rumble/RumbleManager;)V)((boolean)outOfFocus, (boolean)isPaused, (boolean)isConfigScreen));
        if (outOfFocus) {
            state = ControllerState.EMPTY;
        } else {
            rumbleManager.ifPresent((Consumer<RumbleManager>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, tick(), (Ldev/isxander/controlify/rumble/RumbleManager;)V)());
        }
        if (state.getButtons().stream().anyMatch((Predicate<ResourceLocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isButtonDown(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Z)((ControllerStateView)state))) ** GOTO lbl-1000
        if (state.getAxes().stream().map((Function<ResourceLocation, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getAxisState(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Float;)((ControllerStateView)state)).anyMatch((Predicate<Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$tickController$42(java.lang.Float ), (Ljava/lang/Float;)Z)())) ** GOTO lbl-1000
        if (state.getHats().stream().map((Function<ResourceLocation, HatState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getHatState(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Ldev/isxander/controlify/controller/input/HatState;)((ControllerStateView)state)).anyMatch((Predicate<HatState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$tickController$43(dev.isxander.controlify.controller.input.HatState ), (Ldev/isxander/controlify/controller/input/HatState;)Z)())) lbl-1000:
        // 3 sources

        {
            v0 = true;
        } else {
            v0 = givingInput = false;
        }
        if (givingInput && !this.currentInputMode().isController()) {
            this.setInputMode(((InputComponent.Config)input.confObj()).mixedInput != false ? InputMode.MIXED : InputMode.CONTROLLER);
            return;
        }
        if (this.consecutiveInputSwitches > 100) {
            CUtil.LOGGER.warn("Controlify detected current controller to be constantly giving input and has been disabled.");
            ToastUtils.sendToast((Component)Component.m_237115_((String)"controlify.toast.faulty_input.title"), (Component)Component.m_237115_((String)"controlify.toast.faulty_input.description"), true);
            this.setCurrentController(null, true);
            this.consecutiveInputSwitches = 0;
            return;
        }
        if (this.minecraft.f_91073_ != null) {
            this.inGameInputHandler().ifPresent((Consumer<InGameInputHandler>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, inputTick(), (Ldev/isxander/controlify/ingame/InGameInputHandler;)V)());
        }
        if (this.currentInputMode().isController()) {
            if (this.minecraft.f_91080_ != null) {
                ScreenProcessorProvider.provide(this.minecraft.f_91080_).onControllerUpdate(controller);
            }
            ControlifyEvents.ACTIVE_CONTROLLER_TICKED.invoke(new ControlifyEvents.ControllerStateUpdate(controller));
        }
    }

    private void probeTick() {
        if (this.probeMode && GLFWControllerManager.areControllersConnected()) {
            this.probeMode = false;
            this.minecraft.execute(this::finishControlifyInit);
        }
    }

    public ControlifyConfig config() {
        return this.config;
    }

    @Override
    @NotNull
    public Optional<ControllerEntity> getCurrentController() {
        return Optional.ofNullable(this.currentController);
    }

    public void setCurrentController(@Nullable ControllerEntity controller, boolean changeInputMode) {
        if (this.currentController == controller) {
            return;
        }
        this.currentController = controller;
        if (controller == null) {
            this.setInputMode(InputMode.KEYBOARD_MOUSE);
            this.inGameInputHandler = null;
            this.inGameButtonGuide = null;
            DebugLog.log("Updated current controller to null", new Object[0]);
            this.config().save();
            return;
        }
        DebugLog.log("Updated current controller to {}({})", controller.name(), controller.uid());
        if (!controller.uid().equals(this.config().currentControllerUid())) {
            this.config().setCurrentControllerUid(controller.uid());
            this.config().setDirty();
        }
        this.inGameInputHandler = new InGameInputHandler(controller);
        ControllerPlayerMovement.ensureCorrectInput(this.minecraft.f_91074_);
        if (controller.input().map(input -> input.config().config().mixedInput).orElse(false).booleanValue()) {
            this.setInputMode(InputMode.MIXED);
        } else if (changeInputMode) {
            this.setInputMode(InputMode.CONTROLLER);
        }
        this.config().saveIfDirty();
    }

    public Optional<ControllerManager> getControllerManager() {
        return Optional.ofNullable(this.controllerManager);
    }

    public Optional<InGameInputHandler> inGameInputHandler() {
        return Optional.ofNullable(this.inGameInputHandler);
    }

    public Optional<InGameButtonGuide> inGameButtonGuide() {
        return Optional.ofNullable(this.inGameButtonGuide);
    }

    public VirtualMouseHandler virtualMouseHandler() {
        return this.virtualMouseHandler;
    }

    public ControllerHIDService controllerHIDService() {
        return this.controllerHIDService;
    }

    @Override
    @NotNull
    public InputMode currentInputMode() {
        return this.currentInputMode;
    }

    @Override
    public boolean setInputMode(@NotNull InputMode currentInputMode) {
        if (this.currentInputMode == currentInputMode) {
            return false;
        }
        this.currentInputMode = currentInputMode;
        if (!this.minecraft.f_91067_.m_91600_()) {
            this.hideMouse(currentInputMode.isController(), true);
        }
        if (this.minecraft.f_91080_ != null) {
            ScreenProcessorProvider.provide(this.minecraft.f_91080_).onInputModeChanged(currentInputMode);
        }
        if (Minecraft.m_91087_().f_91074_ != null) {
            this.inGameButtonGuide = currentInputMode == InputMode.KEYBOARD_MOUSE ? null : (InGameButtonGuide)this.getCurrentController().map(c -> new InGameButtonGuide((ControllerEntity)c, Minecraft.m_91087_().f_91074_)).orElse(null);
        }
        this.consecutiveInputSwitches = Blaze3D.m_83640_() - this.lastInputSwitchTime < 20.0 ? ++this.consecutiveInputSwitches : 0;
        this.lastInputSwitchTime = Blaze3D.m_83640_();
        if (this.currentInputMode.isController()) {
            this.getCurrentController().flatMap(ControllerEntity::input).ifPresent(state -> {
                state.rawStateNow().clearState();
                state.rawStateThen().clearState();
            });
            if (this.minecraft.m_91089_() != null) {
                this.notifyNewServer(this.minecraft.m_91089_());
            }
        }
        KeyMapping.m_289723_();
        ControllerPlayerMovement.updatePlayerInput(this.minecraft.f_91074_);
        ControlifyEvents.INPUT_MODE_CHANGED.invoke(new ControlifyEvents.InputModeChanged(currentInputMode));
        return true;
    }

    public void hideMouse(boolean hide, boolean moveMouse) {
        GLFW.glfwSetInputMode((long)this.minecraft.m_91268_().m_85439_(), (int)208897, (int)(hide ? 212994 : 212993));
        if (this.minecraft.f_91080_ != null) {
            MouseHandlerAccessor mouseHandlerAccessor = (MouseHandlerAccessor)this.minecraft.f_91067_;
            if (hide && !this.virtualMouseHandler().isVirtualMouseEnabled() && moveMouse) {
                mouseHandlerAccessor.invokeOnMove(this.minecraft.m_91268_().m_85439_(), -50.0, -50.0);
            }
        }
    }

    public void showCursorTemporarily() {
        if (this.currentInputMode() == InputMode.MIXED && !this.minecraft.f_91067_.m_91600_()) {
            this.hideMouse(false, false);
            this.showMouseTicks = 40;
            if (this.virtualMouseHandler().isVirtualMouseEnabled()) {
                this.virtualMouseHandler().disableVirtualMouse();
            }
        }
    }

    public InputFontMapper inputFontMapper() {
        return this.inputFontMapper;
    }

    public DefaultBindManager defaultBindManager() {
        return this.defaultBindManager;
    }

    public ControllerTypeManager controllerTypeManager() {
        return this.controllerTypeManager;
    }

    public Set<BindContext> thisTickBindContexts() {
        return this.thisTickContexts;
    }

    public void notifyNewServer(ServerData data) {
        if (!this.currentInputMode().isController()) {
            return;
        }
        if (this.config().globalSettings().seenServers.add(data.f_105363_)) {
            ToastUtils.sendToast((Component)Component.m_237115_((String)"controlify.toast.new_server.title"), (Component)Component.m_237110_((String)"controlify.toast.new_server.description", (Object[])new Object[]{data.f_105362_}), true);
            this.config().save();
        }
    }

    public static Controlify instance() {
        if (instance == null) {
            instance = new Controlify();
        }
        return instance;
    }

    private static /* synthetic */ boolean lambda$tickController$43(HatState hat) {
        return hat != HatState.CENTERED;
    }

    private static /* synthetic */ boolean lambda$tickController$42(Float axis) {
        return Math.abs(axis.floatValue()) > 0.1f;
    }

    private static /* synthetic */ void lambda$tickController$41(boolean outOfFocus, boolean isPaused, boolean isConfigScreen, RumbleManager rumble) {
        rumble.setSilent(outOfFocus || isPaused && !isConfigScreen);
    }
}

