/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.config.GlobalSettings;
import dev.isxander.controlify.config.TypeAdapters;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.input.mapping.MappingEntry;
import dev.isxander.controlify.controller.input.mapping.MappingEntryTypeAdapter;
import dev.isxander.controlify.controllermanager.ControllerManager;
import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.DebugLog;
import dev.isxander.controlify.utils.GsonCodecAdapter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlifyConfig {
    public static final Path CONFIG_PATH = PlatformMainUtil.getConfigDir().resolve("controlify.json");
    public static final Gson GSON = new GsonBuilder().serializeNulls().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeHierarchyAdapter(Class.class, (Object)new TypeAdapters.ClassTypeAdapter()).registerTypeHierarchyAdapter(ResourceLocation.class, new GsonCodecAdapter(ResourceLocation.f_135803_)).registerTypeAdapter(MappingEntry.class, (Object)new MappingEntryTypeAdapter()).create();
    private final Controlify controlify;
    private boolean dirty;
    private boolean firstLaunch;
    private String currentControllerUid = null;
    private final Map<String, JsonObject> storedControllerConfig = new HashMap<String, JsonObject>();
    @NotNull
    private GlobalSettings globalSettings = new GlobalSettings();

    public ControlifyConfig(Controlify controlify) {
        this.controlify = controlify;
    }

    public void save() {
        JsonObject serialObject;
        CUtil.LOGGER.log("Saving Controlify config...");
        try {
            serialObject = this.createSerialObject();
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to serialize Controlify config. Controlify will not be saved!", e);
            return;
        }
        try {
            Files.deleteIfExists(CONFIG_PATH);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((JsonElement)serialObject), StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING);
            this.dirty = false;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to save Controlify config to file!", e);
        }
    }

    public void saveIfDirty() {
        if (this.dirty) {
            this.save();
        }
    }

    public void load() {
        CUtil.LOGGER.log("Loading Controlify config...");
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            CUtil.LOGGER.log("First launch detected. Creating initial config file!");
            this.firstLaunch = true;
            this.save();
            return;
        }
        try {
            this.applyConfig((JsonObject)GSON.fromJson(Files.readString(CONFIG_PATH), JsonObject.class));
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to load Controlify config!", e);
        }
        if (this.dirty) {
            DebugLog.log("Config was dirty after load, saving...", new Object[0]);
            this.save();
        }
    }

    private JsonObject createSerialObject() {
        JsonObject obj = new JsonObject();
        obj.addProperty("current_controller", this.currentControllerUid());
        this.controlify.getControllerManager().ifPresent(this::updateStoredControllerConfig);
        JsonObject controllersObj = new JsonObject();
        this.storedControllerConfig.forEach((arg_0, arg_1) -> ((JsonObject)controllersObj).add(arg_0, arg_1));
        obj.add("controllers", (JsonElement)controllersObj);
        JsonElement globalJson = GSON.toJsonTree((Object)this.globalSettings);
        obj.add("global", globalJson);
        return obj;
    }

    private void updateStoredControllerConfig(ControllerManager controllerManager) {
        for (ControllerEntity controller : controllerManager.getConnectedControllers()) {
            JsonObject controllerObject = this.storedControllerConfig.computeIfAbsent(controller.uid(), k -> new JsonObject());
            JsonObject configObject = controllerObject.getAsJsonObject("config");
            if (configObject == null) {
                configObject = new JsonObject();
                controllerObject.add("config", (JsonElement)configObject);
            }
            controller.serializeToObject(configObject, GSON);
            this.storedControllerConfig.put(controller.uid(), controllerObject);
        }
    }

    private void applyConfig(JsonObject json) {
        try {
            JsonElement primitive = json.get("current_controller");
            if (primitive != null) {
                this.currentControllerUid = primitive.isJsonNull() ? null : primitive.getAsString();
            } else {
                CUtil.LOGGER.warn("Current controller is not defined in config!");
                this.setDirty();
            }
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to apply current controller from config file!", e);
            this.setDirty();
        }
        try {
            JsonObject controllersMap = json.getAsJsonObject("controllers");
            controllersMap.asMap().forEach((uid, element) -> this.storedControllerConfig.put((String)uid, element.getAsJsonObject()));
            this.controlify.getControllerManager().ifPresent(this::applyControllerConfig);
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to apply controller config from config file!", e);
            this.setDirty();
        }
        try {
            GlobalSettings newGlobalSettings = (GlobalSettings)GSON.fromJson(json.get("global"), GlobalSettings.class);
            if (newGlobalSettings != null) {
                this.globalSettings = newGlobalSettings;
            }
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to apply global settings from config file!", e);
            this.setDirty();
        }
    }

    private void applyControllerConfig(ControllerManager controllerManager) {
        for (ControllerEntity controller : controllerManager.getConnectedControllers()) {
            this.loadControllerConfig(controller);
        }
    }

    public boolean loadControllerConfig(ControllerEntity controller) {
        JsonObject json = this.storedControllerConfig.get(controller.uid());
        if (json == null) {
            CUtil.LOGGER.warn("Controller {} has no config to load. Using defaults.", controller.uid());
            this.setDirty();
            return true;
        }
        JsonObject innerJson = json.getAsJsonObject("config");
        try {
            controller.deserializeFromObject(innerJson.deepCopy(), GSON);
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to load controller {} config!", controller.uid(), e);
            this.setDirty();
        }
        return false;
    }

    @Nullable
    public String currentControllerUid() {
        return this.currentControllerUid;
    }

    public void setCurrentControllerUid(@Nullable String uid) {
        this.currentControllerUid = uid;
    }

    @NotNull
    public GlobalSettings globalSettings() {
        return this.globalSettings;
    }

    public boolean isFirstLaunch() {
        return this.firstLaunch;
    }

    public void setDirty() {
        this.dirty = true;
    }
}

