/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.driver.sdl;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.config.ControlifyConfig;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.gui.screen.DownloadingSDLScreen;
import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.Platform;
import dev.isxander.controlify.utils.TrackingBodySubscriber;
import dev.isxander.controlify.utils.TrackingConsumer;
import dev.isxander.controlify.utils.log.ControlifyLogger;
import dev.isxander.sdl3java.api.SdlInit;
import dev.isxander.sdl3java.api.error.SdlError;
import dev.isxander.sdl3java.api.hints.SdlHints;
import dev.isxander.sdl3java.api.version.SdlVersion;
import dev.isxander.sdl3java.api.version.SdlVersionRecord;
import dev.isxander.sdl3java.jna.SdlNativeLibraryLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.apache.commons.codec.digest.DigestUtils;

public class SDL3NativesManager {
    private static final String SDL3_VERSION = String.valueOf(SDL3NativesManager.getJavaBindingsVersion()) + ".release-3.2.18";
    private static final Map<Target, NativeFileInfo> NATIVE_LIBRARIES = Map.of(new Target(Platform.WINDOWS, true, false), new NativeFileInfo("win32-x86-64", "windows-x86_64", "dll"), new Target(Platform.WINDOWS, false, false), new NativeFileInfo("win32-x86", "window-x86", "dll"), new Target(Platform.LINUX, true, false), new NativeFileInfo("linux-x86-64", "linux-x86_64", "so"), new Target(Platform.LINUX, true, true), new NativeFileInfo("linux-aarch64", "linux-aarch64", "so"), new Target(Platform.MAC, true, false), new NativeFileInfo("darwin-x86-64", "macos-universal", "dylib"), new Target(Platform.MAC, true, true), new NativeFileInfo("darwin-aarch64", "macos-universal", "dylib"));
    private static final String NATIVE_LIBRARY_URL = "https://maven.isxander.dev/releases/dev/isxander/libsdl4j-natives/%s/".formatted(SDL3_VERSION);
    private static boolean loaded = false;
    private static boolean attemptedLoad = false;
    private static CompletableFuture<Boolean> initFuture;
    private static final ControlifyLogger logger;

    public static CompletableFuture<Boolean> maybeLoad() {
        if (initFuture != null) {
            return initFuture;
        }
        if (!Controlify.instance().config().globalSettings().loadVibrationNatives) {
            initFuture = CompletableFuture.completedFuture(false);
            return initFuture;
        }
        if (attemptedLoad) {
            initFuture = CompletableFuture.completedFuture(loaded);
            return initFuture;
        }
        attemptedLoad = true;
        if (SDL3NativesManager.tryOfflineLoadAndStart()) {
            initFuture = CompletableFuture.completedFuture(true);
            return initFuture;
        }
        if (!SDL3NativesManager.isSupportedOnThisPlatform()) {
            CUtil.LOGGER.warn("No native library for current platform, skipping SDL3 load");
            initFuture = CompletableFuture.completedFuture(false);
            return initFuture;
        }
        Path nativesFolder = SDL3NativesManager.getNativesFolderPath();
        Path localLibraryPath = nativesFolder.resolve(Target.CURRENT.getArtifactName());
        Path checksumPath = nativesFolder.resolve(Target.CURRENT.getArtifactMD5Name());
        if (Files.exists(localLibraryPath, new LinkOption[0])) {
            if (Files.notExists(checksumPath, new LinkOption[0])) {
                logger.log("Downloading checksum for existing SDL natives");
                SDL3NativesManager.downloadChecksum(checksumPath);
            }
            if (SDL3NativesManager.verifyFileMd5(localLibraryPath, checksumPath, true) && SDL3NativesManager.loadAndStart(localLibraryPath)) {
                initFuture = CompletableFuture.completedFuture(true);
                return initFuture;
            }
            CUtil.LOGGER.warn("Failed to load SDL3 from local file, attempting to re-download");
        }
        initFuture = SDL3NativesManager.downloadAndStart(localLibraryPath);
        return initFuture;
    }

    public static boolean tryOfflineLoadAndStart() {
        if (initFuture != null) {
            throw new IllegalStateException("Tried to start offline mode but initialization already in progress.");
        }
        String path = "SDL3";
        if (CUtil.IS_POJAV_LAUNCHER) {
            logger.log("Detected PojavLauncher.");
            String nativesFolderName = System.getenv("POJAV_NATIVEDIR");
            Path libsLocation = Path.of(nativesFolderName, new String[0]).toAbsolutePath();
            path = libsLocation.resolve("libSDL3.so").toString();
        }
        try {
            SdlNativeLibraryLoader.loadLibSDL3FromFilePathNow((String)path);
        }
        catch (UnsatisfiedLinkError e) {
            if (CUtil.IS_POJAV_LAUNCHER) {
                logger.error("Failed to find SDL3, even though PojavLauncher should provide it. Is it up to date?");
            }
            return false;
        }
        initFuture = new CompletableFuture();
        try {
            SDL3NativesManager.startSDL3();
            loaded = true;
            initFuture.complete(true);
        }
        catch (Throwable t) {
            CUtil.LOGGER.error("Failed to start SDL3", t);
            initFuture.complete(false);
            return false;
        }
        return true;
    }

    private static boolean loadAndStart(Path localLibraryPath) {
        try {
            if (!SDL3NativesManager.verifyJarMd5(localLibraryPath)) {
                throw new IllegalStateException("SDL3 native library jar checksum did not match.");
            }
            SdlNativeLibraryLoader.loadLibSDL3FromFilePathNow((String)localLibraryPath.toAbsolutePath().toString());
            SDL3NativesManager.startSDL3();
            loaded = true;
            return true;
        }
        catch (Throwable e) {
            CUtil.LOGGER.error("Failed to start SDL3", e);
            return false;
        }
    }

    private static void startSDL3() {
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_ENHANCED_REPORTS", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_STEAM", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_ROG_CHAKRAM", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_ALLOW_BACKGROUND_EVENTS", (String)"1");
        SdlHints.SDL_SetHint((String)"SDL_JOYSTICK_LINUX_DEADZONES", (String)"1");
        SdlVersionRecord nativesVersion = SdlVersionRecord.fromPacked((int)SdlVersion.SDL_GetVersion());
        SdlVersionRecord javaVersion = SdlVersion.SDL_GetJavaBindingsVersion();
        logger.log("Loading SDL3 version: {}. Java bindings targeting: {}", nativesVersion, javaVersion);
        if (!nativesVersion.equals((Object)javaVersion)) {
            logger.warn("SDL3 NATIVE LIBRARY VERSION MISMATCH! Java bindings are targeting a different version of SDL3 than the loaded native library. This may cause issues.");
        }
        if (!SdlInit.SDL_Init((int)25104)) {
            CUtil.LOGGER.error("Failed to initialise SDL3: {}", SdlError.SDL_GetError());
            throw new RuntimeException("Failed to initialise SDL3: " + SdlError.SDL_GetError());
        }
        logger.log("Successfully initialised SDL subsystems");
    }

    private static CompletableFuture<Boolean> downloadAndStart(Path localLibraryPath) {
        return ((CompletableFuture)SDL3NativesManager.downloadLibrary(localLibraryPath.getParent()).thenCompose(success -> {
            if (!success.booleanValue()) {
                return CompletableFuture.completedFuture(false);
            }
            return CompletableFuture.completedFuture(SDL3NativesManager.loadAndStart(localLibraryPath));
        })).thenCompose(success -> Minecraft.m_91087_().m_18691_(() -> success));
    }

    private static CompletableFuture<Boolean> downloadLibrary(Path targetFolder) {
        String artifactName = Target.CURRENT.getArtifactName();
        String md5Name = Target.CURRENT.getArtifactMD5Name();
        Path artifactPath = targetFolder.resolve(artifactName);
        Path md5Path = targetFolder.resolve(md5Name);
        try {
            Files.deleteIfExists(artifactPath);
            Files.deleteIfExists(md5Path);
            Files.createDirectories(targetFolder, new FileAttribute[0]);
            Files.createFile(artifactPath, new FileAttribute[0]);
            Files.createFile(md5Path, new FileAttribute[0]);
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to delete existing SDL3 native library file", e);
            return CompletableFuture.completedFuture(false);
        }
        String url = NATIVE_LIBRARY_URL + artifactName;
        String md5Url = NATIVE_LIBRARY_URL + md5Name;
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest libRequest = HttpRequest.newBuilder(URI.create(url)).build();
        HttpRequest hashRequest = HttpRequest.newBuilder(URI.create(md5Url)).build();
        Minecraft minecraft = Minecraft.m_91087_();
        DownloadingSDLScreen downloadScreen = new DownloadingSDLScreen(minecraft.f_91080_, 0L, artifactPath);
        minecraft.m_91152_((Screen)downloadScreen);
        CompletableFuture<?> libFuture = SDL3NativesManager.downloadTracked(httpClient, libRequest, downloadScreen, targetFolder, minecraft);
        CompletableFuture<?> hashFuture = SDL3NativesManager.downloadTracked(httpClient, hashRequest, downloadScreen, targetFolder, minecraft);
        return CompletableFuture.allOf(libFuture, hashFuture).handle((response, throwable) -> {
            if (throwable != null) {
                CUtil.LOGGER.error("Failed to download SDL3 native library", (Throwable)throwable);
                return false;
            }
            CUtil.LOGGER.log("Finished downloading SDL3 native library");
            minecraft.execute(downloadScreen::finishDownload);
            return SDL3NativesManager.verifyFileMd5(artifactPath, md5Path, true);
        });
    }

    private static boolean verifyMd5(Path filePath, InputStream md5Hash) {
        try {
            String fileMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(filePath, new OpenOption[0]));
            String checksum = new String(md5Hash.readAllBytes()).trim();
            if (!fileMd5.equals(checksum)) {
                throw new Exception("Checksum did not match");
            }
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to verify checksum for " + String.valueOf(filePath), e);
            return false;
        }
        return true;
    }

    private static boolean verifyFileMd5(Path localLibraryPath, Path checksumPath, boolean deleteOnFail) {
        boolean bl;
        block9: {
            InputStream md5Stream = Files.newInputStream(checksumPath, new OpenOption[0]);
            try {
                boolean verified = SDL3NativesManager.verifyMd5(localLibraryPath, md5Stream);
                if (!verified && deleteOnFail) {
                    Files.deleteIfExists(localLibraryPath);
                }
                bl = verified;
                if (md5Stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (md5Stream != null) {
                        try {
                            md5Stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CUtil.LOGGER.error("Failed to read SDL3 native library checksum", e);
                    return false;
                }
            }
            md5Stream.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean verifyJarMd5(Path localLibraryPath) {
        if (!DebugProperties.USE_JAR_CHECKSUM) {
            if (PlatformMainUtil.isDevEnv()) return true;
            CUtil.LOGGER.warn("Jar checksum verification is disabled in production environment. Only enable this setting if you really know what you're doing. You're leaving yourself open to security vulnerabilities.");
            return true;
        }
        String md5Name = Target.CURRENT.getArtifactMD5Name();
        try (InputStream md5Stream = SDL3NativesManager.class.getResourceAsStream("/sdl3-hashes/" + md5Name);){
            if (md5Stream == null) {
                CUtil.LOGGER.error("Failed to find SDL3 native library checksum in jar");
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = SDL3NativesManager.verifyMd5(localLibraryPath, md5Stream);
            return bl;
        }
        catch (IOException e) {
            CUtil.LOGGER.error("Failed to read SDL3 native library checksum from jar", e);
            return false;
        }
    }

    private static CompletableFuture<?> downloadTracked(HttpClient client, HttpRequest request, DownloadingSDLScreen downloadScreen, Path folder, Minecraft minecraft) {
        return client.sendAsync(request, TrackingBodySubscriber.bodyHandler(HttpResponse.BodyHandlers.ofFileDownload(folder, StandardOpenOption.WRITE), new TrackingConsumer(downloadScreen::increaseTotal, (received, total) -> downloadScreen.updateDownloadProgress((long)received), error -> {
            if (error.isPresent()) {
                CUtil.LOGGER.error("Failed to download SDL3 native library", (Throwable)error.get());
                minecraft.execute(() -> downloadScreen.failDownload((Throwable)error.get()));
            }
        })));
    }

    private static void downloadChecksum(Path checksumPath) {
        try {
            Path nativesFolder = checksumPath.getParent();
            Files.deleteIfExists(checksumPath);
            Files.createDirectories(nativesFolder, new FileAttribute[0]);
            Files.createFile(checksumPath, new FileAttribute[0]);
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(URI.create(NATIVE_LIBRARY_URL + Target.CURRENT.getArtifactMD5Name())).build();
            client.send(request, HttpResponse.BodyHandlers.ofFileDownload(nativesFolder, StandardOpenOption.WRITE));
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to download checksum", e);
        }
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean hasAttemptedLoad() {
        return attemptedLoad;
    }

    public static boolean isSupportedOnThisPlatform() {
        return Target.CURRENT.hasNativeLibrary();
    }

    private static Path getNativesFolderPath() {
        Path nativesFolderPath = PlatformMainUtil.getGameDir();
        ControlifyConfig config = Controlify.instance().config();
        String customPath = config.globalSettings().customVibrationNativesPath;
        if (!customPath.isEmpty()) {
            try {
                nativesFolderPath = Path.of(customPath, new String[0]);
            }
            catch (InvalidPathException e) {
                CUtil.LOGGER.error("Invalid custom SDL3 native library path. Using default and resetting custom path.", e);
                config.globalSettings().customVibrationNativesPath = "";
                config.save();
            }
        }
        return nativesFolderPath.resolve("controlify-natives");
    }

    private static SdlVersionRecord getJavaBindingsVersion() {
        return new SdlVersionRecord(3, 2, 18);
    }

    static {
        logger = CUtil.LOGGER.createSubLogger("SDL3NativesManager");
    }

    public record Target(Platform platform, boolean is64Bit, boolean isARM) {
        public static final Target CURRENT = (Target)Util.m_137537_(() -> {
            Platform platform = Platform.current();
            String arch = System.getProperty("os.arch");
            boolean is64bit = arch.contains("64");
            boolean isARM = arch.contains("arm") || arch.contains("aarch");
            return new Target(platform, is64bit, isARM);
        });

        public boolean hasNativeLibrary() {
            return NATIVE_LIBRARIES.containsKey(this);
        }

        public String getArtifactName() {
            NativeFileInfo file = NATIVE_LIBRARIES.get(this);
            return "libsdl4j-natives-" + SDL3_VERSION + "-" + file.downloadSuffix + "." + file.fileExtension;
        }

        public String getArtifactMD5Name() {
            return this.getArtifactName() + ".md5";
        }

        public String formatted() {
            return this.platform().name() + " 64bit=" + this.is64Bit() + ";isARM=" + this.isARM();
        }
    }

    public record NativeFileInfo(String folderName, String downloadSuffix, String fileExtension) {
        public Path getNativePath() {
            return this.getSearchPath().resolve(this.folderName).resolve("SDL3." + this.fileExtension);
        }

        public Path getSearchPath() {
            return PlatformMainUtil.getGameDir().resolve("controlify-natives").resolve(SDL3_VERSION);
        }
    }
}

